<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Validation\Property;

use idoit\Module\Api\Exception\ValidationException;
use idoit\Module\Api\Validation\PropertyValidation;

/**
 * Class Integer
 *
 * @package idoit\Module\Api\Validation\Property
 */
class Integer extends PropertyValidation
{

    /**
     * Validate value
     *
     * @return bool
     * @throws ValidationException
     */
    public function validate()
    {
        if (!is_int($this->getValue())) {
            throw new ValidationException($this->getPropertyType(), 'Please provide an integer value.');
        }

        return true;
    }
}
