<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Validation\Property;

use idoit\Module\Api\Exception\ValidationException;
use idoit\Module\Api\Validation\Validation;

/**
 * Class Virtual
 *
 * @package idoit\Module\Api\Validation\Property
 */
class Virtual extends Validation
{
    /**
     * Validate value
     *
     * @throws ValidationException
     */
    public function validate()
    {
        throw new ValidationException($this->getPropertyType(), 'Virtual/Autotext properties are read only and cannot be modified by the api.');
    }
}
