<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Validation;

/**
 * Class Validation
 *
 * @package idoit\Module\Api\Validation
 */
abstract class Validation implements Validatable
{
    /**
     * Property definition
     *
     * @var array
     */
    protected $propertyDefinition;

    /**
     * Property title
     *
     * @var string
     */
    protected $title;

    /**
     * Property value
     *
     * @var mixed
     */
    protected $value;

    /**
     * @return string
     */
    protected function getTitle()
    {
        return $this->title;
    }

    /**
     * @param string $title
     *
     * @return Validation
     */
    protected function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * @return mixed
     */
    protected function getValue()
    {
        return $this->value;
    }

    /**
     * @param mixed $value
     *
     * @return Validation
     */
    protected function setValue($value)
    {
        $this->value = $value;

        return $this;
    }

    /**
     * @return array
     */
    protected function getPropertyDefinition()
    {
        return $this->propertyDefinition;
    }

    /**
     * @param array $propertyDefinition
     *
     * @return Validation
     */
    protected function setPropertyDefinition(array $propertyDefinition)
    {
        $this->propertyDefinition = $propertyDefinition;

        return $this;
    }

    /**
     * Get property type
     *
     * @return string
     */
    protected function getPropertyType()
    {
        return $this->getPropertyDefinition()[C__PROPERTY__INFO][C__PROPERTY__INFO__TYPE];
    }

    /**
     * Validation constructor.
     *
     * @param string $title
     * @param mixed  $value
     * @param array  $propertyDefinition
     */
    public function __construct($title, $value, array $propertyDefinition)
    {
        /**
         * @todo Use new 'Property' class instead of array as property definition
         */

        // Initialize information
        $this->setTitle($title)
            ->setValue($value)
            ->setPropertyDefinition($propertyDefinition);
    }
}