<?php
/*
#===========================================================================
#= Script : Blog
#= File   : admin.php
#= Version: 1.55b RC2
#= Author : Jonathan Beckett
#= Email  : jonbeckett@pluggedout.com
#= Support: http://www.pluggedout.com/development/forums/viewforum.php?f=5
#= Edits: Soulsniper, Kevin A. Sesock, Craig Roberts-Thomson, others
#===========================================================================
#= Copyright (c) 2003 Jonathan Beckett
#= You are free to use and modify this script as long as this header
#= section stays intact. This file is part of BLOG.
#=
#= This program is free software; you can redistribute it and/or modify
#= it under the terms of the GNU General Public License as published by
#= the Free Software Foundation; either version 2 of the License, or
#= (at your option) any later version.
#=
#= This program is distributed in the hope that it will be useful,
#= but WITHOUT ANY WARRANTY; without even the implied warranty of
#= MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#= GNU General Public License for more details.
#=
#= You should have received a copy of the GNU General Public License
#= along with BLOG files; if not, write to the Free Software
#= Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#===========================================================================
*/

require "./lib/session.php";
require "./lib/config.php";
require "./lib/database.php";
require "./lib/html.php";
require "./lib/misc.php";
require "./lib/jsheader.php";
require "./lib/html_user.php";
require "./lib/options.php";

if (!isset($_SESSION["showblognum"]) || $_SESSION["showblognum"]==0) {
  load_config();
}

// get the data from the database

$result = db_prepare();
$con = db_connect();


// start outputting the page

// head tag
print html_pageheader();

// body tag
print html_pagebody();

// banner
print html_pagestart();

if ($_SESSION["userid"]=="") {

	// login attempted - no session data
	if ($_GET["action"]=="postlogin"){
		$html = "<br><table width='400' border='0' cellspacing='1' cellpadding='1' bgcolor='#cccccc' align='center'>\n"
			."  <tr><td bgcolor='#dddddd' align='center'><span class='small'><b>Login Failure</b></span></td></tr>\n"
			."  <tr><td bgcolor='#ffffff' align='center'>\n"
			."<p class='normal' align='center'>You have attempted to login and the login has failed. This could be for a number of reasons, such as an incorrect username and/or password.</p>\n"
			."  </td></tr>\n"
			."</table>\n";
		print $html;
	}

	// show a login form
	$html = "<br><br>"
		."<form method='POST' action='blog_exec.php?action=login'>\n"
		."<table align='center' border='0' cellspacing='1' cellpadding='2' bgcolor='#cccccc'>\n"
		."<tr><td colspan='2' bgcolor='#dddddd' align='center'><span class='small'>Login Form</span></td></tr>\n"
		."<tr><td bgcolor='#eeeeee'><span class='normal'>Username</span></td><td bgcolor='#eeeeee'><input type='text' class='text' name='username' size='20'></td></tr>\n"
		."<tr><td bgcolor='#eeeeee'><span class='normal'>Password</span></td><td bgcolor='#eeeeee'><input type='password' class='text' name='password' size='20'></td></tr>\n"
		."<tr><td colspan='2' bgcolor='#ffffff' align='right'><input type='submit' value='Login' class='button'></td></tr>\n"
		."</table>\n"
                ."<br><br><a href=\"index.php\"><span class='small'><center>Return to Blog</center></a>"
		."</form>\n";
	print $html;


} else {
	if ($_GET["action"]=="" || $_GET["action"]=="postlogin") {

		// start whole page table to hold calendar, list and entries
		print "<table width='100%' border='0' cellspacing='1' cellpadding='5'><tr><td valign='top' width='200'>\n";
		// show the calendar
		print html_calendar($month,$year);
		// white space
                print html_gap();
		print html_archive();
		print html_gap();
		print html_categories();
		print html_gap();
		// add link
                print html_command();
		// white space
		print html_gap();
		// show the blog list
		print html_bloglist($list_rows,$blogid);
		// white space
		print html_gap();
		// show the logout control
		//print html_logout($list_rows,$blogid);
		// seperate the main columns of the page table
		print "  </td><td valign='top'>\n";
		// show the diary entry (or entries)
		print html_blogview($view_rows,$view_comment_rows,"0");
		// end the page table
		print "</td></tr></table>\n";

	}
}

   if (isset($_GET['action']) && $_GET["action"]=="add_blog") { 
      // show the add blog form 
	  Print Header_Emoticon();
      $html = "<br><table border='0' cellspacing='1' cellpadding='1' bgcolor='#cccccc' align='center'>\n" 
         ."  <tr><td bgcolor='#dddddd' align='center'><span class='small'><b>Add Blog</b></span></td></tr>\n" 
         ."  <tr><td bgcolor='#ffffff' align='center'>\n" 
         ."<form method='POST' name='add_form' action='".form_url("blog_exec.php?action=add_blog")."'>\n"
         ."<table border='0' cellspacing='1' cellpadding='1' align='center'>\n"
         ."  <tr><td bgcolor='#eeeeee'><span class='normal'>Date:</span></td><td bgcolor='#eeeeee'><input type='text' name='date' size='20' class='blog_body' value='".$dateNow."'>&nbsp;&nbsp;&nbsp;&nbsp;<span class='normal'>(YYYY-MM-DD HH:MM:SS)</span></td></tr>\n"
         ."  <tr><td bgcolor='#eeeeee'><span class='normal'>Title:&nbsp;</span></td><td bgcolor='#eeeeee'><input type='text' name='title' size='75' class='blog_body'></td></tr>\n" 
         ."  <tr><td bgcolor='#eeeeee'><span class='normal'>Body:&nbsp;</span></td><td bgcolor='#eeeeee'><textarea name='body' cols='120' rows='15' class='blog_body'></textarea></td></tr>\n" 
         ."  <tr><td bgcolor='#eeeeee'><span class='normal'>Image:</span></td><td bgcolor='#eeeeee'><input type='button' name='upload' value='Upload Image' onClick='imageupload();'></td></tr>\n"
         ."  <script language='javascript'>\n function imageupload(){ \n window.open('./lib/image_upload.php', 'Upload Image', 'resizable=no, menubar=no, scrollbars=no, toolbar=no, fullscreen=no, width=500, height=150')}\n </script>"
         ."  <tr><td bgcolor='#eeeeee'><span class='normal'>Draft:&nbsp;</span></td><td bgcolor='#eeeeee'>&nbsp;&nbsp;<input type='checkbox' name='bDraft' value='on'><span class='normal'>(Do not show in Standard View)</span></td></tr>\n"
         ."  <tr><td bgcolor='#eeeeee'><span class='normal'>Pre-Post:&nbsp;</span></td><td bgcolor='#eeeeee'>&nbsp;&nbsp;<input type='checkbox' name='bPrePost' value='on'><span class='normal'>(Only show after Date/Time entered above.)</span></td></tr>\n"
         //Category implementation below
         ."  <tr><td bgcolor='#eeeeee'><span class='normal'>Category:&nbsp;</span></td><td bgcolor='#eeeeee'>\n"
         ."     <select name='nCategory'>\n";
         $sql_categories = "SELECT * FROM blog_category;";
         $result_cats = mysql_query($sql_categories, $con);
         if ($result_cats){
            while ($catrow = mysql_fetch_array($result_cats)) {
              $html .="<option name=".$catrow['cCategory']." value=".$catrow['nCatIDCode'].">".$catrow['cCategory']."</option>/n";
            }
         }
  $html .="     </select></td></td></tr>\n"
         //End Category implementation
	 ."  <tr><td bgcolor='#eeeeee'><span class='normal'>Submit:</span></td><td bgcolor='#eeeeee'>&nbsp;&nbsp;<input type='submit' value='Add Blog Entry'></td></tr>\n"
         ."</table>\n" 
   		 ."<center>\n"
		 ."<A HREF=\"javascript:emoticon(':angry:')\" title='Insert Angry Smiley'><img src='images/smileys/angry.gif' border='0'></a>\n"
		 ."<A HREF=\"javascript:emoticon(':cheesy:')\" title='Insert Cheesy Grin Smiley'><img src='images/smileys/cheesy.gif' border='0'></a>\n"
		 ."<A HREF=\"javascript:emoticon(':cool:')\" title='Insert Cool Smiley'><img src='images/smileys/cool.gif' border='0'></a>\n"
		 ."<A HREF=\"javascript:emoticon(':cry:')\" title='Insert Crying Smiley'><img src='images/smileys/cry.gif' border='0'></a>\n"
		 ."<A HREF=\"javascript:emoticon(':embarassed:')\" title='Insert Embarssed Smiley'><img src='images/smileys/embarassed.gif' border='0'></a>\n"
		 ."<A HREF=\"javascript:emoticon(':huh:')\" title='Insert Confused Smiley'><img src='images/smileys/huh.gif' border='0'></a>\n"
		 ."<A HREF=\"javascript:emoticon(':rolleyes:')\" title='Insert Sarcastic Smiley'><img src='images/smileys/rolleyes.gif' border='0'></a>\n"
 		 ."<A HREF=\"javascript:emoticon(':sad:')\" title='Insert Sad Smiley'><img src='images/smileys/sad.gif' border='0'></a>\n"
 		 ."<A HREF=\"javascript:emoticon(':shocked:')\" title='Insert Shocked Smiley'><img src='images/smileys/shocked.gif' border='0'></a>\n"
 		 ."<A HREF=\"javascript:emoticon(':smiley:')\" title='Insert Smiley'><img src='images/smileys/smiley.gif' border='0'></a>\n"
 		 ."<A HREF=\"javascript:emoticon(':tongue:')\" title='Insert Cheeky-bastard Smiley'><img src='images/smileys/tongue.gif' border='0'></a>\n"
 		 ."<A HREF=\"javascript:emoticon(':wink:')\" title='Insert Winking Smiley'><img src='images/smileys/wink.gif' border='0'></a>\n"
		 ."</center>\n"
         ."</form>\n"
		 ."</td></tr>\n" 
         ."</table>\n";
      print $html;
	}

	if (isset($_GET['action']) && $_GET["action"]=="edit_blog") {
		// get blog from database
		$con = db_connect();
		$sql = "SELECT * FROM blog WHERE nIdCode=".$_GET["blogid"];
		$result = mysql_query($sql,$con);
		if ($result!=false) {
			// show blog editing form
			$row = mysql_fetch_array($result);
                        Print Header_Emoticon();
			$html = "<br><table border='0' cellspacing='1' cellpadding='1' bgcolor='#cccccc' align='center'>\n"
				."  <tr><td bgcolor='#dddddd' align='center'><span class='small'><b>Edit Blog</b></span></td></tr>\n"
				."  <tr><td bgcolor='#ffffff' align='center'>\n"
				."<form method='POST' name='add_form' action='".form_url("blog_exec.php?action=edit_blog")."'>\n"
				."  <input type='hidden' name='blogid' value='".$row["nIdCode"]."'>\n"
				."  <table border='0' cellspacing='1' cellpadding='1' align='center'>\n"
                                ."  <tr><td bgcolor='#eeeeee'><span class='normal'>Date:</span></td><td bgcolor='#eeeeee'><input type='text' name='date' size='20' value='".$row['dEntryDate']."'>&nbsp;&nbsp;&nbsp;&nbsp;<span class='normal'>(YYYY-MM-DD HH:MM:SS)</span></td></tr>\n"
                                ."  <tr><td bgcolor='#eeeeee'><span class='normal'>Title:</span></td><td bgcolor='#eeeeee'><input type='text' name='title' size='75' value='".stripslashes(htmlspecialchars($row["cTitle"], ENT_QUOTES))."' class='blog_body'></td></tr>\n"
				."  <tr><td bgcolor='#eeeeee'><span class='normal'>Body:</span></td><td bgcolor='#eeeeee'><textarea name='body' cols='120' rows='15' class='blog_body'>".stripslashes($row["cBody"])."</textarea></td></tr>\n"
                                ."  <tr><td bgcolor='#eeeeee'><span class='normal'>Image:</span></td><td bgcolor='#eeeeee'><input type='button' name='upload' value='Upload Image' onClick='imageupload();'></td></tr>\n"
                                ."  <script language='javascript'>\n function imageupload(){ \n window.open('./lib/image_upload.php', 'Upload Image', 'resizable=no, menubar=no, scrollbars=no, toolbar=no, fullscreen=no, width=500, height=150')}\n </script>";
                                if ($row["bDraft"]==1)
                                    $html .= "  <tr><td bgcolor='#eeeeee'><span class='normal'>Draft:&nbsp;</span></td><td bgcolor='#eeeeee'>&nbsp;&nbsp;<input type='checkbox' name='bDraft' value='on' checked><span class='normal'>(Do not show in Standard View)</span></td></tr>\n";
                                else
                                    $html .= "  <tr><td bgcolor='#eeeeee'><span class='normal'>Draft:&nbsp;</span></td><td bgcolor='#eeeeee'>&nbsp;&nbsp;<input type='checkbox' name='bDraft' value='on'><span class='normal'>(Do not show in Standard View)</span></td></tr>\n";
                                if ($row["bPrePost"]==1)
                                    $html .= "  <tr><td bgcolor='#eeeeee'><span class='normal'>Pre-Post:&nbsp;</span></td><td bgcolor='#eeeeee'>&nbsp;&nbsp;<input type='checkbox' name='bPrePost' value='on' checked><span class='normal'>(Only show after Date/Time entered above.)</span></td></tr>\n";
                                else
                                    $html .= "  <tr><td bgcolor='#eeeeee'><span class='normal'>Pre-Post:&nbsp;</span></td><td bgcolor='#eeeeee'>&nbsp;&nbsp;<input type='checkbox' name='bPrePost' value='on'><span class='normal'>Only show after Date/Time entered above.</span></td></tr>\n";
                                //Category implementation below
                                $html .="  <tr><td bgcolor='#eeeeee'><span class='normal'>Category:&nbsp;</span></td><td bgcolor='#eeeeee'>\n";
                                $html .="     <select name='nCategory'>\n";
                                $sql_categories = "SELECT * FROM blog_category;";
                                $result_cats = mysql_query($sql_categories, $con);
                                if ($result_cats){
                                   while ($catrow = mysql_fetch_array($result_cats)) {
                                      if ($catrow['nCatIDCode']==$row['nCategory']){
                                         $html .="<option name=".$catrow['cCategory']." value=".$catrow['nCatIDCode']." selected>".$catrow['cCategory']."</option>/n";
                                      } else {
                                         $html .="<option name=".$catrow['cCategory']." value=".$catrow['nCatIDCode'].">".$catrow['cCategory']."</option>/n";
                                      }
                                   }
                                }
                                $html .="     </select></td></td></tr>\n"
                                //End Category implementation
                                ."  <tr><td bgcolor='#eeeeee'><span class='normal'>Submit:</span></td><td bgcolor='#eeeeee'>&nbsp;&nbsp;<input type='submit' value='Submit Changes'></td></tr>\n"
         		."</table>\n"
   		 		."<center>\n"
				."<A HREF=\"javascript:emoticon(':angry:')\" title='Insert Angry Smiley'><img src='images/smileys/angry.gif' border='0'></a>\n"
				."<A HREF=\"javascript:emoticon(':cheesy:')\" title='Insert Cheesy Grin Smiley'><img src='images/smileys/cheesy.gif' border='0'></a>\n"
				."<A HREF=\"javascript:emoticon(':cool:')\" title='Insert Cool Smiley'><img src='images/smileys/cool.gif' border='0'></a>\n"
			 	."<A HREF=\"javascript:emoticon(':cry:')\" title='Insert Crying Smiley'><img src='images/smileys/cry.gif' border='0'></a>\n"
		 		."<A HREF=\"javascript:emoticon(':embarassed:')\" title='Insert Embarssed Smiley'><img src='images/smileys/embarassed.gif' border='0'></a>\n"
				."<A HREF=\"javascript:emoticon(':huh:')\" title='Insert Confused Smiley'><img src='images/smileys/huh.gif' border='0'></a>\n"
			 	."<A HREF=\"javascript:emoticon(':rolleyes:')\" title='Insert Sarcastic Smiley'><img src='images/smileys/rolleyes.gif' border='0'></a>\n"
 				."<A HREF=\"javascript:emoticon(':sad:')\" title='Insert Sad Smiley'><img src='images/smileys/sad.gif' border='0'></a>\n"
 			 	."<A HREF=\"javascript:emoticon(':shocked:')\" title='Insert Shocked Smiley'><img src='images/smileys/shocked.gif' border='0'></a>\n"
 				."<A HREF=\"javascript:emoticon(':smiley:')\" title='Insert Smiley'><img src='images/smileys/smiley.gif' border='0'></a>\n"
   				."<A HREF=\"javascript:emoticon(':tongue:')\" title='Insert Cheeky-bastard Smiley'><img src='images/smileys/tongue.gif' border='0'></a>\n"
    			        ."<A HREF=\"javascript:emoticon(':wink:')\" title='Insert Winking Smiley'><img src='images/smileys/wink.gif' border='0'></a>\n"
		 		."</center>\n"
         		."</form>\n"
		 		."</td></tr>\n" 
         		."</table>\n"
                 	// CRTMOD - edit date
			// New line
			."<input type='hidden' name='origdate' value='".$row['dEntryDate']."'>";
      		print $html;
		}
	}
        //Series of calls to options.php for category modifications
	if (isset($_GET['action']) && $_GET["action"]=="cat_listview") {
           print cat_listview();
        }
        if (isset($_GET['action']) && $_GET["action"]=="cat_add") {
           print cat_add();
        }
        if (isset($_GET['action']) && $_GET["action"]=="cat_edit") {
           print cat_edit();
        }
        //Series of calls to options.php for tagline modifications
        if (isset($_GET['action']) && $_GET["action"]=="tag_listview") {
           print tag_listview();
        }
        if (isset($_GET['action']) && $_GET["action"]=="tag_add") {
           print tag_add();
        }
        if (isset($_GET['action']) && $_GET["action"]=="tag_edit") {
           print tag_edit();
        }
        //Series of calls to options.php for link modifications
        if (isset($_GET['action']) && $_GET["action"]=="link_listview") {
           print link_listview();
        }
        if (isset($_GET['action']) && $_GET["action"]=="link_add") {
           print link_add();
        }
        if (isset($_GET['action']) && $_GET["action"]=="link_edit") {
           print link_edit();
        }
        //Series of calls to options.php for profile modifications
        if (isset($_GET['action']) && $_GET["action"]=="prof_listview") {
           print prof_listview();
        }
        if (isset($_GET['action']) && $_GET["action"]=="prof_add") {
           print prof_add();
        }
        if (isset($_GET['action']) && $_GET["action"]=="prof_edit") {
           print prof_edit();
        }
        //Call to options.php for blog_config modifications
        if (isset($_GET['action']) && $_GET["action"]=="options") {
          print options_edit();
        }
        
// put in any other stuff
print html_pageend($_SESSION["copyright"]);

// finish
print html_pagefooter();

?>