<?php
/*
#===========================================================================
#= Script : Blog
#= File   : index.php
#= Version: 1.55b RC2
#= Author : Jonathan Beckett
#= Email  : jonbeckett@pluggedout.com
#= Support: http://www.pluggedout.com/development/forums/viewforum.php?f=5
#= Edits: Soulsniper, Kevin A. Sesock, Craig Roberts-Thomson
#===========================================================================
#= Copyright (c) 2003 Jonathan Beckett
#= You are free to use and modify this script as long as this header
#= section stays intact. This file is part of BLOG.
#=
#= This program is free software; you can redistribute it and/or modify
#= it under the terms of the GNU General Public License as published by
#= the Free Software Foundation; either version 2 of the License, or
#= (at your option) any later version.
#=
#= This program is distributed in the hope that it will be useful,
#= but WITHOUT ANY WARRANTY; without even the implied warranty of
#= MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#= GNU General Public License for more details.
#=
#= You should have received a copy of the GNU General Public License
#= along with BLOG files; if not, write to the Free Software
#= Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#===========================================================================
*/

require "./lib/session.php";
require "./lib/config.php";
require "./lib/database.php";
require "./lib/html.php";
require "./lib/html_user.php";
require "./lib/misc.php";
require "./lib/jsheader.php";

if (!isset($_SESSION["showblognum"]) || $_SESSION["showblognum"]==0) {
  load_config();
}

// get the data from the database
$result = db_prepare();

// start outputting the page

// head tag

print html_pageheader();
print Header_Clock();

// body tag
print html_pagebody();

// banner
print html_pagestart();

// start whole page table to hold calendar, list and entries
print "<table width='100%' border='0' cellspacing='1' cellpadding='5'><tr><td valign='top' width='200'>\n";

	// show the calendar
	print html_calendar($month,$year);
	
	print html_gap();
	
	print html_showlimit();
	
	print html_gap();
	
	print html_archive();
	
	print html_gap();
	
	print html_categories();
	
	// white space
	print html_gap();
	
	print html_search();
	
	print html_gap();
	// SOULEDIT: This runs the ShowTime function to... show the time.
	print html_showtime();
	
	// white space
	print html_gap();
	// show the blog list
	print html_bloglist($list_rows,$blogid);
	
	print html_gap();
	
	// seperate the main columns of the page table
	print "  </td><td valign='top'>\n";

	// SoulSniper Addon: Find out if the url has ?limit=X at the end
	// If so, add the X to $limit and pass this to the blogview function.
	// This is for limiting the number of posts on the main page
	// If no limit is specified send 0 which shows all.
	if (isset($_GET['limit'])) {
	$limit = $_GET['limit'];
	print html_blogview($view_rows,$view_comment_rows,$limit);
	} else {
	print html_blogview($view_rows,$view_comment_rows,"0");
	}
	
	// seperate the main columns of the page table
	print "  </td><td valign='top' width='150'>\n";
	
	// SOULEDIT: Run the MyPic function to show an avatar above the profile
        if ($_SESSION["show_avatar"]){
           print html_mypic();
	   print html_gap();
        }
	
        //WildFireX: For the Tagline/Fortune Cookie
        if ($_SESSION["use_tagline"]){
           print html_tagline();
	   print html_gap();
        }
	
	print html_myprofile();

	// white space
	print html_gap();
	
	print html_gap();

	print html_mylinks();
	
	print html_gap();
	
	// SOULEDIT: Run the MySong function to show the user's currently playing song.
	print html_mysong();
	
	print html_gap();
	
	// SOULEDIT: Show a RSS button linked to the user's RSS feed.
	print html_showxml();

// end the page table
print "</td></tr></table>\n";

// put in any other stuff
print html_pageend($_SESSION["copyright"]);

// finish
print html_pagefooter();

?>