<?php
/*
#===========================================================================
#= Script : Blog
#= File   : install.php
#= Version: 1.55b RC2
#= Author : Kevin A. Sesock
#= Email  : kevin@sesock.com
#= Support: http://www.pluggedout.com/development/forums/viewforum.php?f=5
#===========================================================================
#= Copyright (c) 2003 Jonathan Beckett & Kevin A. Sesock
#= You are free to use and modify this script as long as this header
#= section stays intact. This file is part of BLOG.
#=
#= This program is free software; you can redistribute it and/or modify
#= it under the terms of the GNU General Public License as published by
#= the Free Software Foundation; either version 2 of the License, or
#= (at your option) any later version.
#=
#= This program is distributed in the hope that it will be useful,
#= but WITHOUT ANY WARRANTY; without even the implied warranty of
#= MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#= GNU General Public License for more details.
#=
#= You should have received a copy of the GNU General Public License
#= along with BLOG files; if not, write to the Free Software
#= Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#===========================================================================
*/

require "./lib/config.php";
require "./lib/database.php";
require "./lib/html.php";

ini_set("track_errors", 1);

error_reporting  (E_ALL ^ E_NOTICE ^ E_WARNING);
set_magic_quotes_runtime(0);

$root = "./";
$con = db_connect();
session_start();

// head tag
print html_pageheader();

// body tag
print html_pagebody();

// banner
print html_pagestart();

if (file_exists($root.'no.setup')) {
   print "<center><span class='normal'>This installer is locked!<br>Please remove the 'no.setup' file in this directory</span></center>";
   print html_pagefooter();
   die();
}

if (!isset($_GET["step"])) {
   $html .=      "<form method='POST' action='install.php?step=1'>\n"
		."<table align='center' border='0' cellspacing='1' cellpadding='2' bgcolor='#cccccc'>\n"
		."<tr><td colspan='2' bgcolor='#dddddd' align='center'><span class='small'>Installation Select</span></td></tr>\n"
		."<tr><td bgcolor='#eeeeee'><span class='normal'>Install/Upgrade:</span></td><td bgcolor='#eeeeee'><select name='style'>"
                ."  <option value='1' selected='selected'>Install New</option>\n"
                ."  <option value='2'>Upgrade From v1.55a</option>\n"
                ."  <option value='3'>Upgrade From v1.54</option>\n"
                ."  <option value='4'>Upgrade From v1.51</option>\n"
                ."</select>\n"
                ."</td></tr>\n"
		."<tr><td colspan='2' bgcolor='#ffffff' align='center'><input type='submit' value='Begin Installation' class='button'></td></tr>\n"
		."</table>\n"
		."</form>\n";
   print $html;
}

if ((isset($_GET["step"])) && ($_GET["step"]=="1")) {
  $_SESSION["install_style"] = $_POST["style"];
  $html .=       "<center><div class='normal'>Check the following for accuracy. Modify config.php as necessary:</span></center>"
                ."<form method='POST' action='install.php?step=2'>\n"
		."<table align='center' border='0' cellspacing='1' cellpadding='2' bgcolor='#cccccc'>\n"
		."<tr><td colspan='2' bgcolor='#dddddd' align='center'><span class='small'>Installation Step 1</span></td></tr>\n"
                ."<tr><td bgcolor='#eeeeee'><span class='normal'>DB Server:</span></td><td bgcolor='#eeeeee'><input type='text' class='text' name='db_server' size='20' value='".$db_server."' disabled='disabled'></td></tr>\n"
		."<tr><td bgcolor='#eeeeee'><span class='normal'>DB Name:</span></td><td bgcolor='#eeeeee'><input type='text' class='text' name='db_name' size='20' value='".$db_name."' disabled='disabled'></td></tr>\n"
		."<tr><td bgcolor='#eeeeee'><span class='normal'>DB UserName:</span></td><td bgcolor='#eeeeee'><input type='text' class='text' name='db_username' size='20' value='".$db_username."' disabled='disabled'></td></tr>\n"
		."<tr><td bgcolor='#eeeeee'><span class='normal'>DB Password:</span></td><td bgcolor='#eeeeee'><input type='text' class='text' name='db_password' size='20' value='".$db_password."' disabled='disabled'></td></tr>\n"
		."<tr><td colspan='2' bgcolor='#ffffff' align='center'><input type='submit' value='Next' class='button'></td></tr>\n"
		."</table>\n"
		."</form>\n";
  print $html;
}

if ((isset($_GET["step"])) && ($_GET["step"]=="2")) {
   $sql = sql_data($_SESSION["install_style"]);
   $html .=       "<form method='POST' action='install.php?step=3'>\n"
		."<table align='center' border='0' cellspacing='1' cellpadding='2' bgcolor='#cccccc'>\n"
		."<tr><td colspan='2' bgcolor='#dddddd' align='center'><span class='small'>Installation Step 2</span></td></tr>\n";
   foreach ($sql as $sql_command) {
      $result=  mysql_query($sql_command, $con);
      if (!$result) {
         $html .= "</table></form><br><center><span class='normal'>Could not create database tables<br>Please ensure that the database is created and access rights assigned. The SQL error was:".mysql_error($con)."</span></center>";
         db_disconnect($con);
         print $html;
         die();
      } else {
          $html .="<tr><td bgcolor='#eeeeee'><span class='normal'>Table Create:</span></td><td bgcolor='#eeeeee'><span class='small'>Complete!</span></td></tr>\n";
      }
   }
  $html .="<tr><td colspan='2' bgcolor='#ffffff' align='right'><input type='submit' value='Complete Installation' class='button'></td></tr>\n</table></form>";
  print $html;
}

if ((isset($_GET["step"])) && ($_GET["step"]=="3")) {
  $html .= "<center><div class='normal'>Check for Status, then continue on to modify your options.</span></center>"
          ."<form method='POST' action='admin.php?action=options'>\n"
          ."<table align='center' border='0' cellspacing='1' cellpadding='2' bgcolor='#cccccc'>\n";
  $fs_result = true;
  if ($fs_result = @fopen($root.'no.setup', 'w')) {
     @fwrite($locksetup, 'locked', 4 );
     @fclose($locksetup);
     @chmod( $root.'no.setup', 0666 );
  }
  $fs_result = @chmod( $root.'rss.xml', 0777 );
  $fs_result = @chmod( $root.'/images/upload', 0777 );
  $fs_result = @chmod( $root.'/lib/song.txt', 0777 );
  $fs_result = @chmod( $root.'/lib/links-update-cache.xml', 0777 );

  if ($fs_result) {
     $html .= "<tr><td bgcolor='#dddddd' align='center'><span class='small'>File System Modification</span></td></tr>";
     $html .= "<tr><td bgcolor='#dddddd' align='center'><span class='small'>Installer has been successfully locked.</span></td></tr>";
  }else{
     $html .= "<tr><td bgcolor='#dddddd' align='center'><span class='small'>File System Modification</span></td></tr>";
     $html .= "<tr><td bgcolor='#dddddd' align='center'><span class='small'>Installer has NOT been locked.</span></td></tr>";
     $html .= "<tr><td bgcolor='#dddddd' align='center'><span class='small'>File System has NOT been correctly modified.</span></td></tr>";
     $html .= "<tr><td bgcolor='#dddddd' align='center'><span class='small'>Please delete install.php to prevent security flaws.</span></td></tr>";
     $html .= "<tr><td bgcolor='#dddddd' align='center'><span class='small'>Additionally, please check all file system permissions.</span></td></tr>";
  }
  $html .="<tr><td colspan='2' bgcolor='#ffffff' align='right'><input type='submit' value='Modify Options' class='button'></td></tr>\n</table></form>";
  $html .=
  load_config(); //Load configuration data.
  $_SESSION["userid"]="temp"; //Temporarily login administrator to complete changes.
  print $html;
}

// finish
print html_pagefooter();

//----------------------------------------------------------------------------
// Data

function sql_data($style){
  $SQL = array();
  switch ($style) {
    case "1":
         $SQL[] = "CREATE TABLE `blog` (`nIdCode` bigint( 20 ) NOT NULL AUTO_INCREMENT ,`dEntryDate` datetime NOT NULL default '0000-00-00 00:00:00',`cTitle` varchar( 100 ) NOT NULL default '',`cBody` mediumtext NOT NULL ,`nViews` bigint( 20 ) NOT NULL default '0',`nComments` bigint( 20 ) NOT NULL default '0',`bDraft` tinyint( 1 ) unsigned NOT NULL default '0',`bPrePost` tinyint( 1 ) NOT NULL default '0',`nCategory` bigint( 20 ) NOT NULL default '0',UNIQUE KEY `nIdCode` ( `nIdCode` ) ,KEY `dEntryDate` ( `dEntryDate` )) TYPE = MYISAM COMMENT = 'Journal Table';";
         $SQL[] = "CREATE TABLE `blog_comments` (`nIdCode` bigint( 20 ) NOT NULL AUTO_INCREMENT ,`nBlogId` bigint( 20 ) NOT NULL default '0',`cUsername` varchar( 75 ) NOT NULL default '',`cIPAddr` varchar( 16 ) NOT NULL default '000.000.000.000',`cEMail` varchar( 75 ) NOT NULL default '',`cURL` varchar( 150 ) NOT NULL default '',`cComment` mediumtext NOT NULL ,UNIQUE KEY `nIdCode` ( `nIdCode` )) TYPE = MYISAM ;";
         $SQL[] = "CREATE TABLE `blog_category` (`nCatIDCode` bigint( 20 ) NOT NULL AUTO_INCREMENT ,`cCategory` mediumtext,`cImgPath` mediumtext,`bNoImg` tinyint( 1 ) NOT NULL default '0',UNIQUE KEY `nIdCode` ( `nCatIDCode` )) TYPE = MYISAM ;";
         $SQL[] = "CREATE TABLE `blog_config` (`nConfigIDCode` smallint( 6 ) NOT NULL default '0',`login_name` tinytext NOT NULL ,`login_pass` tinytext NOT NULL ,`blog_url` mediumtext NOT NULL ,`login_email` tinytext NOT NULL ,`copyright` mediumtext NOT NULL ,`author_name` mediumtext NOT NULL ,`show_avatar` tinyint( 1 ) NOT NULL default '0',`avatar_path` varchar( 120 ) NOT NULL default 'images\\logo\\avatar.gif',`rss_feedname` varchar( 30 ) NOT NULL default '',`blog_title` text NOT NULL ,`blog_subtext` text NOT NULL ,`timezone` smallint( 6 ) NOT NULL default '-5',`dst_on` tinyint( 1 ) NOT NULL default '0',`viewcomments` tinyint( 1 ) NOT NULL default '0',`showblognum` smallint( 6 ) NOT NULL default '0',`use_tagline` tinyint( 1 ) NOT NULL default '0',`use_categories` tinyint( 1 ) NOT NULL default '0',`swearfilter_comments` tinyint( 1 ) NOT NULL default '0',`swearfilter_blog` tinyint( 1 ) NOT NULL default '0',`addcomments` tinyint( 1 ) NOT NULL default '1',`ping_weblogs` tinyint( 1 ) NOT NULL default '0',`HourUpdatePersist` smallint( 5 ) NOT NULL default '8',`use_weblogsxml` tinyint( 1 ) NOT NULL default '0',`use_technorati` tinyint( 1 ) NOT NULL default '0',`technorati_devkey` varchar( 30 ) NOT NULL default '',`use_amazon` tinyint( 1 ) NOT NULL default '0',`amazon_devkey` varchar( 30 ) NOT NULL default '',UNIQUE KEY `nConfigIDCode` ( `nConfigIDCode` )) TYPE = MYISAM COMMENT = 'Configuration Settings';";
         $SQL[] = "CREATE TABLE `blog_links` (`nLinkIDCode` bigint( 20 ) NOT NULL AUTO_INCREMENT ,`cTitle` mediumtext NOT NULL ,`cURL` mediumtext NOT NULL ,`dLastUpdate` datetime NOT NULL default '0000-00-00 00:00:00',UNIQUE KEY `nLinkCodeID` ( `nLinkIDCode` )) TYPE = MYISAM COMMENT = 'Link';";
         $SQL[] = "CREATE TABLE `blog_profile` (`nProfileIDCode` bigint( 20 ) NOT NULL AUTO_INCREMENT ,`cProfileTitle` mediumtext NOT NULL ,`cProfileText` mediumtext NOT NULL ,UNIQUE KEY `nProfileCodeID` ( `nProfileIDCode` )) TYPE = MYISAM COMMENT = 'Profile Information';";
         $SQL[] = "CREATE TABLE `blog_quotes` (`nQuoteIDCode` bigint( 20 ) NOT NULL AUTO_INCREMENT ,`cQuote` mediumtext NOT NULL ,`bUsableQuote` tinyint( 1 ) unsigned NOT NULL default '0',UNIQUE KEY `nQuoteIdCode` ( `nQuoteIDCode` )) TYPE = MYISAM PACK_KEYS =0;";
         $SQL[] = "INSERT INTO blog_config (nConfigIDCode, blog_title, blog_subtext, author_name, copyright, login_name, login_pass) VALUES ('0', 'Blog v1.55b', 'A Weblog PHP Script from PluggedOut.com', 'Your Name Here', 'Your Copyright Here', 'default', 'default')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle, cProfileText) VALUES ('Name','Your Name Here')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle, cProfileText) VALUES ('DOB','YYYY-MM-DD')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle, cProfileText) VALUES ('Job','Blogging')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle) VALUES ('AOL IM')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle) VALUES ('ICQ')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle) VALUES ('Interests')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle) VALUES ('Movies')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle) VALUES ('Music')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle) VALUES ('Books')";
         break;
    case "2": //Upgrade from v1.55a
         $SQL[] = "ALTER TABLE blog ADD bPrePost tinyint( 1 ) NOT NULL default '0';";
         $SQL[] = "ALTER TABLE blog_comments ADD cIPAddr varchar( 16 ) NOT NULL default '000.000.000.000';";
         $SQL[] = "CREATE TABLE `blog_config` (`nConfigIDCode` smallint( 6 ) NOT NULL default '0',`login_name` tinytext NOT NULL ,`login_pass` tinytext NOT NULL ,`blog_url` mediumtext NOT NULL ,`login_email` tinytext NOT NULL ,`copyright` mediumtext NOT NULL ,`author_name` mediumtext NOT NULL ,`show_avatar` tinyint( 1 ) NOT NULL default '0',`avatar_path` varchar( 120 ) NOT NULL default 'images\\logo\\avatar.gif',`rss_feedname` varchar( 30 ) NOT NULL default '',`blog_title` text NOT NULL ,`blog_subtext` text NOT NULL ,`timezone` smallint( 6 ) NOT NULL default '-5',`dst_on` tinyint( 1 ) NOT NULL default '0',`viewcomments` tinyint( 1 ) NOT NULL default '0',`showblognum` smallint( 6 ) NOT NULL default '0',`use_tagline` tinyint( 1 ) NOT NULL default '0',`use_categories` tinyint( 1 ) NOT NULL default '0',`swearfilter_comments` tinyint( 1 ) NOT NULL default '0',`swearfilter_blog` tinyint( 1 ) NOT NULL default '0',`addcomments` tinyint( 1 ) NOT NULL default '1',`ping_weblogs` tinyint( 1 ) NOT NULL default '0',`HourUpdatePersist` smallint( 5 ) NOT NULL default '8',`use_weblogsxml` tinyint( 1 ) NOT NULL default '0',`use_technorati` tinyint( 1 ) NOT NULL default '0',`technorati_devkey` varchar( 30 ) NOT NULL default '',`use_amazon` tinyint( 1 ) NOT NULL default '0',`amazon_devkey` varchar( 30 ) NOT NULL default '',UNIQUE KEY `nConfigIDCode` ( `nConfigIDCode` )) TYPE = MYISAM COMMENT = 'Configuration Settings';";
         $SQL[] = "CREATE TABLE `blog_links` (`nLinkIDCode` bigint( 20 ) NOT NULL AUTO_INCREMENT ,`cTitle` mediumtext NOT NULL ,`cURL` mediumtext NOT NULL ,`dLastUpdate` datetime NOT NULL default '0000-00-00 00:00:00',UNIQUE KEY `nLinkCodeID` ( `nLinkIDCode` )) TYPE = MYISAM COMMENT = 'Link';";
         $SQL[] = "CREATE TABLE `blog_profile` (`nProfileIDCode` bigint( 20 ) NOT NULL AUTO_INCREMENT ,`cProfileTitle` mediumtext NOT NULL ,`cProfileText` mediumtext NOT NULL ,UNIQUE KEY `nProfileCodeID` ( `nProfileIDCode` )) TYPE = MYISAM COMMENT = 'Profile Information';";
         $SQL[] = "INSERT INTO blog_config (nConfigIDCode, blog_title, blog_subtext, author_name, copyright, login_name, login_pass) VALUES ('0', 'Blog v1.55b', 'A Weblog PHP Script from PluggedOut.com', 'Your Name Here', 'Your Copyright Here', 'default', 'default')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle, cProfileText) VALUES ('Name','Your Name Here')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle, cProfileText) VALUES ('DOB','YYYY-MM-DD')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle, cProfileText) VALUES ('Job','Blogging')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle) VALUES ('AOL IM')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle) VALUES ('ICQ')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle) VALUES ('Interests')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle) VALUES ('Movies')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle) VALUES ('Music')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle) VALUES ('Books')";
         break;
    case "3": //Upgrade from v.154
         $SQL[] = "ALTER TABLE blog ADD bPrePost tinyint( 1 ) NOT NULL default '0';";
         $SQL[] = "ALTER TABLE blog_comments ADD cIPAddr varchar( 16 ) NOT NULL default '000.000.000.000';";
         $SQL[] = "ALTER TABLE blog_category (`cCategory` mediumtext,`cImgPath` mediumtext,`bNoImg` tinyint( 1 ) NOT NULL default '0');";
         $SQL[] = "CREATE TABLE `blog_config` (`nConfigIDCode` smallint( 6 ) NOT NULL default '0',`login_name` tinytext NOT NULL ,`login_pass` tinytext NOT NULL ,`blog_url` mediumtext NOT NULL ,`login_email` tinytext NOT NULL ,`copyright` mediumtext NOT NULL ,`author_name` mediumtext NOT NULL ,`show_avatar` tinyint( 1 ) NOT NULL default '0',`avatar_path` varchar( 120 ) NOT NULL default 'images\\logo\\avatar.gif',`rss_feedname` varchar( 30 ) NOT NULL default '',`blog_title` text NOT NULL ,`blog_subtext` text NOT NULL ,`timezone` smallint( 6 ) NOT NULL default '-5',`dst_on` tinyint( 1 ) NOT NULL default '0',`viewcomments` tinyint( 1 ) NOT NULL default '0',`showblognum` smallint( 6 ) NOT NULL default '0',`use_tagline` tinyint( 1 ) NOT NULL default '0',`use_categories` tinyint( 1 ) NOT NULL default '0',`swearfilter_comments` tinyint( 1 ) NOT NULL default '0',`swearfilter_blog` tinyint( 1 ) NOT NULL default '0',`addcomments` tinyint( 1 ) NOT NULL default '1',`ping_weblogs` tinyint( 1 ) NOT NULL default '0',`HourUpdatePersist` smallint( 5 ) NOT NULL default '8',`use_weblogsxml` tinyint( 1 ) NOT NULL default '0',`use_technorati` tinyint( 1 ) NOT NULL default '0',`technorati_devkey` varchar( 30 ) NOT NULL default '',`use_amazon` tinyint( 1 ) NOT NULL default '0',`amazon_devkey` varchar( 30 ) NOT NULL default '',UNIQUE KEY `nConfigIDCode` ( `nConfigIDCode` )) TYPE = MYISAM COMMENT = 'Configuration Settings';";
         $SQL[] = "CREATE TABLE `blog_links` (`nLinkIDCode` bigint( 20 ) NOT NULL AUTO_INCREMENT ,`cTitle` mediumtext NOT NULL ,`cURL` mediumtext NOT NULL ,`dLastUpdate` datetime NOT NULL default '0000-00-00 00:00:00',UNIQUE KEY `nLinkCodeID` ( `nLinkIDCode` )) TYPE = MYISAM COMMENT = 'Link';";
         $SQL[] = "CREATE TABLE `blog_profile` (`nProfileIDCode` bigint( 20 ) NOT NULL AUTO_INCREMENT ,`cProfileTitle` mediumtext NOT NULL ,`cProfileText` mediumtext NOT NULL ,UNIQUE KEY `nProfileCodeID` ( `nProfileIDCode` )) TYPE = MYISAM COMMENT = 'Profile Information';";
         $SQL[] = "CREATE TABLE `blog_quotes` (`nQuoteIDCode` bigint( 20 ) NOT NULL AUTO_INCREMENT ,`cQuote` mediumtext NOT NULL ,`bUsableQuote` tinyint( 1 ) unsigned NOT NULL default '0',UNIQUE KEY `nQuoteIdCode` ( `nQuoteIDCode` )) TYPE = MYISAM PACK_KEYS =0;";
         $SQL[] = "INSERT INTO blog_config (nConfigIDCode, blog_title, blog_subtext, author_name, copyright, login_name, login_pass) VALUES ('0', 'Blog v1.55b', 'A Weblog PHP Script from PluggedOut.com', 'Your Name Here', 'Your Copyright Here', 'default', 'default')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle, cProfileText) VALUES ('Name','Your Name Here')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle, cProfileText) VALUES ('DOB','YYYY-MM-DD')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle, cProfileText) VALUES ('Job','Blogging')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle) VALUES ('AOL IM')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle) VALUES ('ICQ')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle) VALUES ('Interests')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle) VALUES ('Movies')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle) VALUES ('Music')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle) VALUES ('Books')";
         break;
    case "4": //Upgrade from v.151
         $SQL[] = "ALTER TABLE blog ADD (bPrePost tinyint( 1 ) NOT NULL default '0', bDraft tinyint( 1 ) NOTNULL default '0');";
         $SQL[] = "ALTER TABLE blog_comments ADD cIPAddr varchar( 16 ) NOT NULL default '000.000.000.000';";
         $SQL[] = "CREATE TABLE `blog_category` (`nCatIDCode` bigint( 20 ) NOT NULL AUTO_INCREMENT ,`cCategory` mediumtext,`cImgPath` mediumtext,`bNoImg` tinyint( 1 ) NOT NULL default '0',UNIQUE KEY `nIdCode` ( `nCatIDCode` )) TYPE = MYISAM ;";
         $SQL[] = "CREATE TABLE `blog_config` (`nConfigIDCode` smallint( 6 ) NOT NULL default '0',`login_name` tinytext NOT NULL ,`login_pass` tinytext NOT NULL ,`blog_url` mediumtext NOT NULL ,`login_email` tinytext NOT NULL ,`copyright` mediumtext NOT NULL ,`author_name` mediumtext NOT NULL ,`show_avatar` tinyint( 1 ) NOT NULL default '0',`avatar_path` varchar( 120 ) NOT NULL default 'images\\logo\\avatar.gif',`rss_feedname` varchar( 30 ) NOT NULL default '',`blog_title` text NOT NULL ,`blog_subtext` text NOT NULL ,`timezone` smallint( 6 ) NOT NULL default '-5',`dst_on` tinyint( 1 ) NOT NULL default '0',`viewcomments` tinyint( 1 ) NOT NULL default '0',`showblognum` smallint( 6 ) NOT NULL default '0',`use_tagline` tinyint( 1 ) NOT NULL default '0',`use_categories` tinyint( 1 ) NOT NULL default '0',`swearfilter_comments` tinyint( 1 ) NOT NULL default '0',`swearfilter_blog` tinyint( 1 ) NOT NULL default '0',`addcomments` tinyint( 1 ) NOT NULL default '1',`ping_weblogs` tinyint( 1 ) NOT NULL default '0',`HourUpdatePersist` smallint( 5 ) NOT NULL default '8',`use_weblogsxml` tinyint( 1 ) NOT NULL default '0',`use_technorati` tinyint( 1 ) NOT NULL default '0',`technorati_devkey` varchar( 30 ) NOT NULL default '',`use_amazon` tinyint( 1 ) NOT NULL default '0',`amazon_devkey` varchar( 30 ) NOT NULL default '',UNIQUE KEY `nConfigIDCode` ( `nConfigIDCode` )) TYPE = MYISAM COMMENT = 'Configuration Settings';";
         $SQL[] = "CREATE TABLE `blog_links` (`nLinkIDCode` bigint( 20 ) NOT NULL AUTO_INCREMENT ,`cTitle` mediumtext NOT NULL ,`cURL` mediumtext NOT NULL ,`dLastUpdate` datetime NOT NULL default '0000-00-00 00:00:00',UNIQUE KEY `nLinkCodeID` ( `nLinkIDCode` )) TYPE = MYISAM COMMENT = 'Link';";
         $SQL[] = "CREATE TABLE `blog_profile` (`nProfileIDCode` bigint( 20 ) NOT NULL AUTO_INCREMENT ,`cProfileTitle` mediumtext NOT NULL ,`cProfileText` mediumtext NOT NULL ,UNIQUE KEY `nProfileCodeID` ( `nProfileIDCode` )) TYPE = MYISAM COMMENT = 'Profile Information';";
         $SQL[] = "CREATE TABLE `blog_quotes` (`nQuoteIDCode` bigint( 20 ) NOT NULL AUTO_INCREMENT ,`cQuote` mediumtext NOT NULL ,`bUsableQuote` tinyint( 1 ) unsigned NOT NULL default '0',UNIQUE KEY `nQuoteIdCode` ( `nQuoteIDCode` )) TYPE = MYISAM PACK_KEYS =0;";
         $SQL[] = "INSERT INTO blog_config (nConfigIDCode, blog_title, blog_subtext, author_name, copyright, login_name, login_pass) VALUES ('0', 'Blog v1.55b', 'A Weblog PHP Script from PluggedOut.com', 'Your Name Here', 'Your Copyright Here', 'default', 'default')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle, cProfileText) VALUES ('Name','Your Name Here')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle, cProfileText) VALUES ('DOB','YYYY-MM-DD')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle, cProfileText) VALUES ('Job','Blogging')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle) VALUES ('AOL IM')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle) VALUES ('ICQ')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle) VALUES ('Interests')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle) VALUES ('Movies')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle) VALUES ('Music')";
         $SQL[] = "INSERT INTO blog_profile (cProfileTitle) VALUES ('Books')";
         break;
  }
  return $SQL;
}

?>