<?php
/*
#===========================================================================
#= Script : Blog
#= File   : database.php
#= Version: 1.55a
#= Author : Jonathan Beckett
#= Email  : jonbeckett@pluggedout.com
#= Support: http://www.pluggedout.com/development/forums/viewforum.php?f=5
#= Edits: Kevin A. Sesock, Soulsniper
#===========================================================================
#= Copyright (c) 2003 Jonathan Beckett
#= You are free to use and modify this script as long as this header
#= section stays intact. This file is part of BLOG.
#=
#= This program is free software; you can redistribute it and/or modify
#= it under the terms of the GNU General Public License as published by
#= the Free Software Foundation; either version 2 of the License, or
#= (at your option) any later version.
#=
#= This program is distributed in the hope that it will be useful,
#= but WITHOUT ANY WARRANTY; without even the implied warranty of
#= MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#= GNU General Public License for more details.
#=
#= You should have received a copy of the GNU General Public License
#= along with BLOG files; if not, write to the Free Software
#= Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#===========================================================================
*/

// Function    : show_error
// Description : In the event of a database connection error, thus kills the attempt
// Arguments   : None
// Returns     : Nothing
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function show_error()
{
	die("Error " . mysql_errno() . " : " . mysql_error());
}


// Function    : sql_quote
// Description : Returns data passed to it surrounded with single quotes
// Arguments   : $input - the data to be transformed
// Returns     : the transformed data
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function sql_quote($input)
{
	return "'".$input."'";
}

// Function    : db_connect
// Description : Connects to the blog database (using global variables to do so)
// Arguments   : None
// Returns     : handle for database connection
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function db_connect()
{

	global $db_server;
	global $db_username;
	global $db_password;
	global $db_name;

	$con = mysql_connect($db_server,$db_username,$db_password);
	if (!(mysql_select_db($db_name,$con)))
	{
		show_error();
	}

	return $con;
}

// Function    : load_config
// Description : Loads configuration information from the MySQL table into the $_SESSION array
// Arguments   : None
// Returns     : True/False
// Author      : Kevin A. Sesock
// Last Change : 2004-06-30
function load_config(){
   $con = db_connect();
   $sql = "SELECT * FROM blog_config WHERE nConfigIDCode=0";
   $result = mysql_query($sql, $con);
   if ($result){
      $settings = mysql_fetch_assoc($result); //This needs assoc and not array for some reason. Wierd.
      foreach ($settings as $key=>$value) {
        $_SESSION[$key]=$value;
      }
   } else {
      die ("Configuration Table not Loaded!");
   }
   return $result;
}


// Function    : db_disconnect
// Description : Closes a database connection
// Arguments   : $con - database connection handle
// Returns     : True/False
// Author      : Jonathan Beckett/Kevin A. Sesock
// Last Change : 2004-07-10
function db_disconnect($con)
{
	$result = mysql_close($con);
	return $result;
}


// Function    : db_prepare
// Description : Fills the blog_view, blog_list and blog_view_comments arrays with data
// Arguments   : None (it works from GET parameters)
// Returns     : Nothing (it effects global arrays)
// Author      : Jonathan Beckett/Kevin A. Sesock
// Last Change : 2004-07-08
function db_prepare(){

	global $day;
	global $month;
	global $year;
	global $category;

        //calendar
	global $maxMonth;
	global $maxYear;
	global $minMonth;
	global $minYear;

        global $list_rows;
	global $view_rows;
	global $view_comment_rows;

	global $viewcomments;

	// connect to the database
	$con = db_connect();
	$date_today = getdate();
	// work out what to show based on URL parameters
	$blogid="";
        if ($_GET["blogidlist"]!="") {
            $blogidlist = $_GET["blogidlist"];
            // I wasn't sure what to do about the calendar, so I had it get the date of the most recent result - I think I need to revisit this - Aerik
            // get the blog entry from the database to find out what month it was (for the list and view sql)
            if (strpos($_SERVER["PHP_SELF"], "admin.php")==true) {
               $sql_findmonth = "SELECT *,MONTH(dEntryDate) AS month,YEAR(dEntryDate) AS year FROM blog WHERE nIdCode IN (".$blogidlist.") ORDER BY dEntryDate DESC;";
            } else {
               $sql_findmonth = "SELECT *,MONTH(dEntryDate) AS month,YEAR(dEntryDate) AS year FROM blog WHERE nIdCode IN (".$blogidlist.") AND ((bDraft=0 AND bPrePost=0) OR (bPrePost=1 AND bDraft=0 AND dEntryDate < '".gmdate('Y-m-d H:i:s',gmtime())."'));";
            }
            $result = mysql_query($sql_findmonth,$con);
            if ($result!=false) {
               $row = mysql_fetch_array($result);
               $month = $row["month"];
               $year = $row["year"];
            } else {
              // revert to nothing sent
              $blogidlist="";
            }
        } else {
	   if ($_GET["blogid"]!="") {
	      $blogid = $_GET["blogid"];
	      // get the blog entry from the database to find out what month it was (for the list and view sql)
              if (strpos($_SERVER["PHP_SELF"],"admin.php")==true){
                 $sql_findmonth = "SELECT *,MONTH(dEntryDate) AS month,YEAR(dEntryDate) AS year FROM blog WHERE nIdCode=".$blogid;
              } else {
                 $sql_findmonth = "SELECT *,MONTH(dEntryDate) AS month,YEAR(dEntryDate) AS year FROM blog WHERE nIdCode=".$blogid."AND ((bDraft=0 AND bPrePost=0) OR (bPrePost=1 AND bDraft=0 AND dEntryDate < '".gmdate('Y-m-d H:i:s',gmtime())."'));";
              }
	      $result = mysql_query($sql_findmonth,$con);
	      if ($result!=false) {
	         $row = mysql_fetch_array($result);
	         $month = $row["month"];
	         $year = $row["year"];
              } else {
                 // revert to nothing sent
	         $blogid="";
              }
          }
	}
        if ($blogid=="" && $blogidlist=="") { // added to accomodate search results
	   // Figure out what parts of the date we have got
           if ($_GET["day"]!="" || $_GET["month"]!="" || $_GET["year"]!=""){
	      if ($_GET["day"]!=""){
                 $day = $_GET["day"];
              } else {
		 $day = "";
	      }
              if ($_GET["month"]!=""){
                 $month = $_GET["month"];
              } else {
	         $month = $date_today["mon"];
              }
              if ($_GET["year"]!=""){
	         $year = $_GET["year"];
              } else {
	         $year = $date_today["year"];
              }
           } else {
	      $day = "";
	      $month = $date_today["mon"];
	      $year = $date_today["year"];
           }
           // find the date of the first and last posts
           $con = db_connect();
           $sql = "SELECT MONTH(MAX(dEntryDate)) as maxmonth, YEAR(MAX(dEntryDate)) AS maxyear, ";
           $sql.= "MONTH(MIN(dEntryDate)) AS minmonth, YEAR(MIN(dEntryDate)) AS minyear ";
           $sql.= "FROM blog";
           if (strpos($_SERVER["PHP_SELF"], "admin.php")==true) {
              //None
           } else {
              $sql .= " WHERE (bDraft=0 AND bPrePost=0) OR (bPrePost=1 AND bDraft=0 AND dEntryDate < '".gmdate('Y-m-d H:i:s',gmtime())."');";
           }
           $result = mysql_query($sql,$con);
           if ($result!=false) {
              $row=@mysql_fetch_array($result);
              // Get the date of the last entry
              $maxYear=$row['maxyear'];
              $maxMonth=$row['maxmonth'];
              // Check if we are past the last entry
              if ($year>$maxYear || ($year==$maxYear && $month>$maxMonth)) {
                $year=$maxYear;
                $month=$maxMonth;
              }
              // Get the date of the first entry
              $minYear=$row['minyear'];
              $minMonth=$row['minmonth'];
              // Check if we are past the last entry
              if ($year<$minYear || ($year==$minYear && $month<$minMonth)) {
                $year=$minYear;
                $month=$minMonth;
              }
           } else {
              print "<li>Problem with SQL<br>[".$sql."]";
           }
        }
        
        // Build the SQL statements for the listviews and blogviews
        if ($_GET["category"]!=""){ //Show category view
           $category= $_GET["category"];
           if (strpos($_SERVER["PHP_SELF"],"admin.php")==true){
              $sql_list = "SELECT * FROM blog WHERE nCategory=".$category." ORDER BY dEntryDate DESC;";
              $sql_view = "SELECT * FROM blog WHERE nCategory=".$category." ORDER BY dEntryDate DESC;";
           } else {
              $sql_list = "SELECT * FROM blog WHERE nCategory=".$category." AND ((bDraft=0 AND bPrePost=0) OR (bPrePost=1 AND bDraft=0 AND dEntryDate < '".gmdate('Y-m-d H:i:s',gmtime())."')) ORDER BY dEntryDate DESC;";
              $sql_view = "SELECT * FROM blog WHERE nCategory=".$category." AND ((bDraft=0 AND bPrePost=0) OR (bPrePost=1 AND bDraft=0 AND dEntryDate < '".gmdate('Y-m-d H:i:s',gmtime())."')) ORDER BY dEntryDate DESC;";
           }
        } else {
           if ($day!=""){ //Show day view
              if (strpos($_SERVER["PHP_SELF"],"admin.php")==true){
                 $sql_list = "SELECT * FROM blog WHERE MONTH(dEntryDate)=".$month." AND YEAR(dEntryDate)=".$year." ORDER BY dEntryDate DESC;";
                 $sql_view = "SELECT * FROM blog WHERE MONTH(dEntryDate)=".$month." AND YEAR(dEntryDate)=".$year." AND DAYOFMONTH(dEntryDate)=".$day." ORDER BY dEntryDate DESC;";
              } else {
                 $sql_list = "SELECT * FROM blog WHERE MONTH(dEntryDate)=".$month." AND YEAR(dEntryDate)=".$year." AND ((bDraft=0 AND bPrePost=0) OR (bPrePost=1 AND bDraft=0 AND dEntryDate < '".gmdate('Y-m-d H:i:s',gmtime())."')) ORDER BY dEntryDate DESC;";
                 $sql_view = "SELECT * FROM blog WHERE MONTH(dEntryDate)=".$month." AND YEAR(dEntryDate)=".$year." AND DAYOFMONTH(dEntryDate)=".$day." AND ((bDraft=0 AND bPrePost=0) OR (bPrePost=1 AND bDraft=0 AND dEntryDate < '".gmdate('Y-m-d H:i:s',gmtime())."')) ORDER BY dEntryDate DESC;";
              }
           } else {
              if ($_GET["month"]!=""){    //Show month view
                 if (strpos($_SERVER["PHP_SELF"],"admin.php")==true){
                    $sql_list = "SELECT * FROM blog WHERE MONTH(dEntryDate)=".$month." AND YEAR(dEntryDate)=".$year." ORDER BY dEntryDate DESC;";
                    $sql_view = "SELECT * FROM blog WHERE MONTH(dEntryDate)=".$month." AND YEAR(dEntryDate)=".$year." ORDER BY dEntryDate DESC;";
                 } else {
                    $sql_list = "SELECT * FROM blog WHERE MONTH(dEntryDate)=".$month." AND YEAR(dEntryDate)=".$year." AND ((bDraft=0 AND bPrePost=0) OR (bPrePost=1 AND bDraft=0 AND dEntryDate < '".gmdate('Y-m-d H:i:s',gmtime())."')) ORDER BY dEntryDate DESC;";
                    $sql_view = "SELECT * FROM blog WHERE MONTH(dEntryDate)=".$month." AND YEAR(dEntryDate)=".$year." AND ((bDraft=0 AND bPrePost=0) OR (bPrePost=1 AND bDraft=0 AND dEntryDate < '".gmdate('Y-m-d H:i:s',gmtime())."')) ORDER BY dEntryDate DESC;";
                 }
              } else { //Show search results
                 if ($_GET["blogidlist"]!="") {
                    $blogidlist = $_GET["blogidlist"];
                    if (strpos($_SERVER["PHP_SELF"], "admin.php")==true){
                       $sql_list = "SELECT * FROM blog WHERE nIdCode IN (".$blogidlist.") ORDER BY dEntryDate DESC;";
                       $sql_view = "SELECT * FROM blog WHERE nIdCode IN (".$blogidlist.") ORDER BY dEntryDate DESC;";
                    } else {
                       $sql_list = "SELECT * FROM blog WHERE nIdCode IN (".$blogidlist.") AND ((bDraft=0 AND bPrePost=0) OR (bPrePost=1 AND bDraft=0 AND dEntryDate < '".gmdate('Y-m-d H:i:s',gmtime())."')) ORDER BY dEntryDate DESC;";
                       $sql_view = "SELECT * FROM blog WHERE nIdCode IN (".$blogidlist.") AND ((bDraft=0 AND bPrePost=0) OR (bPrePost=1 AND bDraft=0 AND dEntryDate < '".gmdate('Y-m-d H:i:s',gmtime())."')) ORDER BY dEntryDate DESC;";
                    }
                 } else {  //Show blog id results
                    if ($_GET["blogid"]!=""){
                       $blogid = $_GET["blogid"];
                       if (strpos($_SERVER["PHP_SELF"],"admin.php")==true){
                          $sql_list = "SELECT * FROM blog ORDER BY dEntryDate DESC LIMIT ".$_SESSION["showblognum"].";";
                          $sql_view = "SELECT * FROM blog WHERE nIdCode=".$blogid.";";
                       } else {
                          $sql_list = "SELECT * FROM blog WHERE ((bDraft=0 AND bPrePost=0) OR (bPrePost=1 AND bDraft=0 AND dEntryDate < '".gmdate('Y-m-d H:i:s',gmtime())."')) ORDER BY dEntryDate DESC LIMIT ".$_SESSION["showblognum"].";";
                          $sql_view = "SELECT * FROM blog WHERE ((bDraft=0 AND bPrePost=0) OR (bPrePost=1 AND bDraft=0 AND dEntryDate < '".gmdate('Y-m-d H:i:s',gmtime())."')) AND nIdCode=".$blogid." ORDER BY dEntryDate DESC LIMIT ".$_SESSION["showblognum"].";";
                       }
                    } else {  //Show normal view
                       if (strpos($_SERVER["PHP_SELF"],"admin.php")==true){
                          $sql_list = "SELECT * FROM blog ORDER BY dEntryDate DESC LIMIT ".$_SESSION["showblognum"].";";
                          $sql_view = "SELECT * FROM blog ORDER BY dEntryDate DESC LIMIT ".$_SESSION["showblognum"].";";
                       } else {
                          $sql_list = "SELECT * FROM blog WHERE ((bDraft=0 AND bPrePost=0) OR (bPrePost=1 AND bDraft=0 AND dEntryDate < '".gmdate('Y-m-d H:i:s',gmtime())."')) ORDER BY dEntryDate DESC LIMIT ".$_SESSION["showblognum"].";";
                          $sql_view = "SELECT * FROM blog WHERE ((bDraft=0 AND bPrePost=0) OR (bPrePost=1 AND bDraft=0 AND dEntryDate < '".gmdate('Y-m-d H:i:s',gmtime())."')) ORDER BY dEntryDate DESC LIMIT ".$_SESSION["showblognum"].";";
                       }  // End normal view if
                    } // End blogid if else
                 } // End search if else
               } //End month if else
             } // End day view if else
	   } // End category view if else

	// Get data from the database (store in arrays)
	$list_result = mysql_query($sql_list,$con);
	$view_result = mysql_query($sql_view,$con);

	// Build List Array
	if ($list_result!=false) {
		$i=0;
		while ($list_row =@ mysql_fetch_array($list_result)){
			$i++;
			$list_rows[$i] = $list_row;
		}
	} else {
		$problem = "1";
	}

	// Build View Array
	if ($view_result!=false) {
		$i=0;
		while ($view_row =@ mysql_fetch_array($view_result)){
			$i++;
			$view_rows[$i] = $view_row;
		}
	} else {
		$problem = "2";
	}

	// increment view counter for blogs being shown
	if ($view_rows[1]["nIdCode"]!="" && $_SESSION["userid"]==""){
	   for ($i=1;$i<=count($view_rows);$i++){
	       $blog_array[$i] = $view_rows[$i]["nIdCode"];
           }
	   $blogids = implode(",",$blog_array);
	   $sql = "UPDATE blog SET nViews=nViews+1 WHERE nIdCode IN (".$blogids.")";
	   $result = mysql_query($sql,$con);
	   if ($result==false){
	      print "<li>Problem with SQL<br>[".$sql."]</li>\n";
           }
       }
}


// Function    : db_hitcount
// Description : Returns the total number of views of all blogs
//                (currently un-used)
// Arguments   : None
// Returns     : Result of calculation
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function db_hitcount(){
	$con = db_connect();
	$sql = "SELECT SUM(nViews) AS nTotal FROM blog";
	$result = mysql_query($sql,$con);
	if ($result!=false){
		$row = mysql_fetch_array($result);
		$total = $row["nTotal"];
	} else {
		$total = 0;
	}
	return $total;
}

?>