<?php
/*
#===========================================================================
#= Script : Blog
#= File   : html.php
#= Version: 1.55a
#= Author : Jonathan Beckett
#= Email  : jonbeckett@pluggedout.com
#= Support: http://www.pluggedout.com/development/forums/viewforum.php?f=5
#= Modifications: SoulSniper, Craig Roberts-Thompson, Kevin A. Sesock, others
#===========================================================================
#= Copyright (c) 2003 Jonathan Beckett
#= You are free to use and modify this script as long as this header
#= section stays intact. This file is part of BLOG.
#=
#= This program is free software; you can redistribute it and/or modify
#= it under the terms of the GNU General Public License as published by
#= the Free Software Foundation; either version 2 of the License, or
#= (at your option) any later version.
#=
#= This program is distributed in the hope that it will be useful,
#= but WITHOUT ANY WARRANTY; without even the implied warranty of
#= MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#= GNU General Public License for more details.
#=
#= You should have received a copy of the GNU General Public License
#= along with BLOG files; if not, write to the Free Software
#= Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#===========================================================================
*/

// Function    : html_gap
// Description : Returns the html to represent a 5 pixel vertical gap on the page
// Arguments   : None
// Returns     : html data
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function html_gap(){
	$html = "<table border='0' cellspacing='0' cellpadding='0'><tr><td><img src='images/pix5.gif' width='5' height='5'></td></tr></table>\n";
	return $html;
}


// Function    : html_pageheader
// Description : Returns the html to represent an html page header (everything as far as body)
// Arguments   : $title - Page Title
// Returns     : html data
// Author      : Jonathan Beckett
// Last Change : 2004-05-19
function html_pageheader() {
	$html = "<html>\n"
		."<head>\n"
		."<title>".stripslashes($_SESSION['blog_title'])."</title>\n"
		."<link rel='stylesheet' href='style.css'>\n";
        $html .= "</head>\n";
	return $html;
}


// Function    : html_pagefooter
// Description : Returns the html to represent the end of the html page
// Arguments   : None
// Returns     : html data
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function html_pagefooter(){
	$html = "</body>\n"
		."</html>\n";
	return $html;
}


// Function    : html_pagebody
// Description : Returns the html to represent the body tag of the html pages
// Arguments   : None
// Returns     : html data
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function html_pagebody() {
	$html = "<body>\n";
	return $html;
}


// Function    : html_pagestart
// Description : Returns the html to insert at the start of every page (typically for a banner)
// Arguments   : None
// Returns     : html data
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function html_pagestart(){
 	$html = "<table width='100%' border='0' cellspacing='0' cellpadding='2'>\n"
		."  <tr><td bgcolor='#eeeeee'><span class='large'>&nbsp;".stripslashes($_SESSION["blog_title"])."</span></td></tr>\n"
		."  <tr><td bgcolor='#eeeeee'><span class='small'>&nbsp;&nbsp;<b>".stripslashes($_SESSION["blog_subtext"])."</b></span></td></tr>\n"
	        ."  <tr><td bgcolor='#ffffff' background='images/shadow.gif'><img src='images/pix1.gif' height='1' width='1'></td></tr>\n"
		."</table>\n";
	return $html;
}


// Function    : html_pageend
// Description : Returns the html to insert at the end of every page
//               (typically for terms or a disclaimer)
// Arguments   : None
// Returns     : html data
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function html_pageend($content){
 $html = "<br><br><a href=\"admin.php\"><span class='small'><center>".$content."</center></a>";
	return $html;
}


// Function    : html_calendar
// Description : Returns the html to represent the calendar.
// Arguments   : $month - Month of the year (01 to 12)
//               $year  - Year (yyyy)
// Returns     : html data
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function html_calendar($month,$year) {

	global $months;
	global $days;

	global $month;
	global $year;
	global $day;

	// CRTMOD - calendar
	// New lines
	global $maxMonth;
	global $maxYear;
	global $minMonth;
	global $minYear;

	define ('ADAY', (60*60*24));

	// make arrays of values representing the first of the month
	$datearray = getdate(mktime(0,0,0,$month,1,$year));
	$start = mktime(0,0,0,$month,1,$year);

	$firstdayarray = getdate($start);

	// pre-populate an array with the last blogs for the month being shown
	// (add them to the array on the index of the day of the month)
	$con = db_connect();
	
        if (strpos($_SERVER["PHP_SELF"], "admin.php")==true) {
           $sql = "SELECT *,DAYOFMONTH(dEntryDate) AS day,MONTH(dEntryDate) AS month,YEAR(dEntryDate) AS year FROM blog WHERE MONTH(dEntryDate)=".sql_quote($month)." AND YEAR(dEntryDate)=".sql_quote($year)." ORDER BY dEntryDate;";
        } else {
           $sql = "SELECT *,DAYOFMONTH(dEntryDate) AS day,MONTH(dEntryDate) AS month,YEAR(dEntryDate) AS year FROM blog WHERE MONTH(dEntryDate)=".sql_quote($month)." AND YEAR(dEntryDate)=".sql_quote($year)." AND ((bDraft=0 AND bPrePost=0) OR (bPrePost=1 AND bDraft=0 AND dEntryDate < '".gmdate('Y-m-d H:i:s',gmtime())."')) ORDER BY dEntryDate;";
        }
        

	//$sql = "SELECT *,DAYOFMONTH(dEntryDate) AS day,MONTH(dEntryDate) AS month,YEAR(dEntryDate) AS year FROM blog WHERE MONTH(dEntryDate)=".sql_quote($month)." AND YEAR(dEntryDate)=".sql_quote($year)." ORDER BY nIdCode;";
	$result = mysql_query($sql,$con);
	if ($result!=false) {
		while ($row = @ mysql_fetch_array($result)){
			$aBlogs[$row["day"]]=$row;
		}
	} else {
		print "<li>Problem with SQL<br>[".$sql."]";
	}

	// work out the URLs for previous and next buttons
	// default
	$prev_month = $month - 1;
	$prev_year = $year;
	$next_month = $month + 1;
	$next_year = $year;

	// handle exceptions
	// end of year
	if ($month==12) {
		$prev_month = $month - 1;
		$prev_year = $year;
		$next_month = 1;
		$next_year = $year + 1;
	}
	// start of year
	if ($month==1) {
		$prev_month = 12;
		$prev_year = $year - 1;
		$next_month = $month + 1;
		$next_year = $year;
	}
	$url_next = $_SERVER["PHP_SELF"]."?month=".$next_month."&year=".$next_year;
	$url_prev = $_SERVER["PHP_SELF"]."?month=".$prev_month."&year=".$prev_year;

        // CRTMOD - calendar
	// New lines
	// See if we need a 'next' link
	if ($year==$maxYear && $month==$maxMonth) {
	    $nextLink="&raquo;";
	} else {
	    $nextLink="<a class='link' href='".form_url($url_next)."'>&raquo;</a>";
	}
	// See if we need a 'prev' link
	if ($year==$minYear && $month==$minMonth) {
	    $prevLink="&laquo;";
	} else {
	    $prevLink="<a class='link' href='".form_url($url_prev)."'>&laquo;</a>";
	}


	// Create the start of the Calendar Table
	$html = "<table width='100%' border='0' cellpadding='1' cellspacing='1' bgcolor='#bbbbbb'>\n";

	// Create the row with the previous button, month name and next button
	$html .= "<tr><td colspan='7' bgcolor='#dddddd'>\n"
		."  <table width='100%' border='0' cellspacing='0' cellpadding='0'><tr>\n"
		."    <td align='center'><span class='normal'>".$prevLink."</span></td>\n"
		."    <td align='center'><span class='normal'><a class='link' href='".form_url($_SERVER["PHP_SELF"]."?year=".$year."&month=".$month)."'>".$datearray["month"]." ".$year."</a></span></td>\n"
		."    <td align='center'><span class='normal'>".$nextLink."</span></td>\n"
		."  </tr></table>\n"
		."</td></tr>\n";

	// Create the row with Day Headings
	$html .= "<tr>\n";
	foreach($days as $day)
	{
		$html .= "  <td align='center' width='20' bgcolor='#dddddd'><span class='small'>".$day."</span></td>\n";
	}
	$html .= "</tr>\n";

	// Create the rows of days
	for( $count=0;$count<(6*7);$count++)
	{
		$dayarray = getdate($start);
		if((($count) % 7) == 0) {
			if($dayarray['mon'] != $datearray['mon']) break;
			$html .= "</tr>\n<tr>\n";
		}

		if($count < $firstdayarray['wday'] || $dayarray['mon'] != $month) {
			$html .= "<td bgcolor='#ffffff'><span class='small'>&nbsp;</span></td>\n";
		} else {
			// if there are entries for the day make it a link and change the color
			$d = $dayarray["mday"];
			if ($aBlogs[$d]["cBody"]!="") {
				$date_url = form_url($_SERVER["PHP_SELF"]."?year=".$dayarray["year"]."&month=".$dayarray["mon"]."&day=".$dayarray["mday"]);
				$html .= "<td align='center' bgcolor='#dddddd'><span class='small'><a class='link' href='".$date_url."'>".$dayarray[mday]."</a></span></td>\n";
			} else {
				$html .= "<td align='center' bgcolor='#eeeeee'><span class='small'>".$dayarray[mday]."</span></td>\n";
			}
			$start += ADAY;
			// check that day has moved on
			$testday = getdate($start);
			if ($testday["yday"]==$dayarray["yday"]){
				$start += (ADAY/2);
			}
		}
	}

	// end the calendar table
	$html .= "</tr>\n</table>\n";

	return $html;
}


// Function    : html_bloglist
// Description : Returns the html to represent a list of blog entries.
// Arguments   : $list_rows - array of associative arrays containing database rows from the db
//               $blogid    - the selected blogid (if used)
// Returns     : html data
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function html_bloglist($list_rows,$blogid){
        global $view_rows;
	$html = "<table width='100%' border='0' bgcolor='#cccccc' cellspacing='1' cellpadding='1'>\n"
		."  <tr><td bgcolor='#dddddd' align='center'><span class='small'><b>Blogs</b></span></td></tr>\n";

	if ($list_rows[1]["nIdCode"]!=""){
	   for ($i=1;$i<=count($list_rows);$i++){
                // put the admin html in if required
		if ($_SESSION["userid"]!=""){
                   $html_admin = "&nbsp;[<a href='".form_url("admin.php?action=edit_blog&blogid=".$list_rows[$i]["nIdCode"])."'>edit</a>]&nbsp;[<a href='".form_url("blog_exec.php?action=remove_blog&blogid=".$list_rows[$i]["nIdCode"])."'>Remove</a>]";
                } else {
                   $html_admin = "";
                }
                $html .= "<tr><td bgcolor='#ffffff'>\n";
                $html .= "<table border='0' cellspacing='1' width='100%'><tr><td><table width='100%' cellspacing='0'><tr><td bgcolor='#dddddd'><span class='list_title'><a class='link' href='#".$list_rows[$i]["nIdCode"]."'> ".stripslashes($list_rows[$i]["cTitle"]);
                if ($list_rows[$i]["bDraft"]) {
                   $html .= "&nbsp;-&nbsp;<em>Draft</em></a></span></td></tr><tr><td bgcolor='#eeeeee'><span class='list_date'>Written on ".$list_rows[$i]["dEntryDate"]."<br>".$list_rows[$i]["nViews"]." views, ".$list_rows[$i]["nComments"]." comments".$html_admin."</span></td></tr></table></td></tr></table>";
                } else {
                   if ($list_rows[$i]["bPrePost"] && (strpos($_SERVER["PHP_SELF"],"admin.php")==true)) {
                      $html .= "&nbsp;-&nbsp;<em>Pre-Posted</em></a></span></td></tr><tr><td bgcolor='#eeeeee'><span class='list_date'>Written on ".$list_rows[$i]["dEntryDate"]."<br>".$list_rows[$i]["nViews"]." views, ".$list_rows[$i]["nComments"]." comments".$html_admin."</span></td></tr></table></td></tr></table>";
                   } else {
                     $html .= "</a></span></td></tr><tr><td bgcolor='#eeeeee'><span class='list_date'>Written on ".$list_rows[$i]["dEntryDate"]."<br>".$list_rows[$i]["nViews"]." views, ".$list_rows[$i]["nComments"]." comments".$html_admin."</span></td></tr></table></td></tr></table>";
                   }
                }
                $html .= "</td></tr>\n";
           }
	} else {
		// no blogs to list
		$html .= "<tr><td bgcolor='#ffffff' align='center'><span class='small'>No Blogs to List</span></td></tr>\n";
   }
	$html .= "</table>\n";
	return $html;
}


// Function    : html_showtime
// Description : Returns the html to show the clock
// Arguments   : None
// Returns     : html data
// Author      : SoulSniper
// Last Change : 2004-05-20
function html_showtime(){
   $html = "<table width='100%' border='0' bgcolor='#cccccc' cellspacing='1' cellpadding='1'>\n"
   ."  <tr><td bgcolor='#dddddd' align='center'><span class='small'><b>Time</b></span></td></tr>\n"
   ."<tr><td bgcolor='#ffffff' align='center'><span class='small'>\n"
   ."<DIV id=Clock style=\"FONT-FAMILY: Verdana; FONT-SIZE: 10pt\"></DIV></span></td></tr>\n"
   ."</table>\n";
   return $html;
}

//Handle searching a blog
//returns blogids to index page (database.php is modified to accept them)
//by Aerik Sylvan, June 11 2004, modifications (for presentation and correct html by Kevin A. Sesock)
function html_search(){
   $html .= "<table width='100%' border='0' bgcolor='#cccccc' cellspacing='1' cellpadding='1'>\n";
   $html .= "<tr><td colspan='2' bgcolor='#dddddd' align='center'><span class='small'><strong>Search:</strong></span></td></tr>\n";
   $html .= "<form action='".form_url("blog_exec.php?action=search'")." method='post'>\n";
   $html .= "<tr><td bgcolor='#ffffff' align='center'><span class='small'>Search Text:</span></td>\n";
   $html .= "<td bgcolor='#ffffff' align='center'><input type='text' size ='20' name='searchword'></td></tr>\n";
   $html .= "<tr><td colspan='2' bgcolor='#ffffff' align='center'><input type='button' value='Search' onClick='this.form.submit()'>\n";
   $html .= "<input type='button' value='Reset' onClick=\"window.location='index.php'\"></td></tr></form></table>\n";
   return $html;
}


// Function    : html_showlimit
// Description : Returns the html to show a form allowing you to limit the number of posts
// Arguments   : None
// Returns     : html data
// Author      : SoulSniper
// Last Change : 2004-05-20
function html_showlimit(){
	$html = "<table width='100%' border='0' bgcolor='#cccccc' cellspacing='1' cellpadding='1'>\n"
		."   <tr><td bgcolor='#dddddd' align='center'><span class='small'><b>Limit to:</b></span></td></tr>\n"
		."	 <tr><td bgcolor='#ffffff' align='center'><span class='small'>\n"
		."   <FORM action=index.php method=GET>\n"
		."   <INPUT style=\"PADDING-LEFT: 4px; FONT-SIZE: 11px; COLOR: black; FONT-FAMILY: Verdana, Arial; BACKGROUND-COLOR: white\" maxLength=10 size=5 name=limit>   posts"
		."   <br><a href=\"index.php\">Reset</a></form></td></tr></table>\n";
        return $html;
}


// Function    : html_blogview
// Description : Returns the html to represent the blog bodies being shown
// Arguments   : $view_rows         - array of associative arrays containing blogs from the db
//               $view_comment_rows - array of array of associative arrays containing comments
//                                    on each of the blogs in the view_rows array
// Returns     : html data
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function html_blogview($view_rows,$view_comment_rows,$limit){

	// pull in globals
	global $viewmode;
	global $viewcomments;
	global $limit;
	global $swearfilter_blog;
	global $addcomments;
	include_once("./lib/smiley.php");

	// start the table containing the blog view(s)
	$html = "<table width='100%' border='0' bgcolor='#bbbbbb' cellspacing='1' cellpadding='1'>\n";
	// SoulSniper Addon: This is to use the limit function
	if ($limit == 0) {
	$view_max = count($view_rows);
	} else {
		if ($limit > count($view_rows)) {
		$view_max = count($view_rows);
		} else {
		$view_max = $limit;
		}
	}
	if ($view_rows[1]["nIdCode"]!=""){
		for ($i=1;$i<=$view_max;$i++) {
                        //This is for category views.
                        if ($view_rows[$i]["nCategory"]!=0) {
                           $con = db_connect();
                           $sql_cat = "SELECT * FROM blog_category WHERE nCatIDCode=".$view_rows[$i]["nCategory"].";";
                           $catresult = mysql_query($sql_cat, $con);
                           if ($catresult){
                              $catrow = mysql_fetch_array($catresult);
                           }
                        }
			// get date info out of the date field
			$view_year = substr($view_rows[$i]["dEntryDate"],0,4);
			$view_month = substr($view_rows[$i]["dEntryDate"],5,2);
			$view_day = substr($view_rows[$i]["dEntryDate"],8,2);
			$view_time = substr($view_rows[$i]["dEntryDate"],11,5);
			$view_datearray = getdate(mktime(0,0,0,$view_month,$view_day,$view_year));
			$view_monthname = $view_datearray["month"];
			// create the date and title table row
			$html .= "<tr>\n"
				."<td bgcolor='#dddddd' rowspan='2'><span class='large'>&nbsp;".$view_day."&nbsp;".$view_monthname.",&nbsp;".$view_time."&nbsp;</span></td>\n"
				."<td bgcolor='#dddddd' width='100%' align='center'><span class='normal'><b><a name='".$view_rows[$i]["nIdCode"]."'>".stripslashes($view_rows[$i]["cTitle"])."</a></b></span></td>\n"
				."</tr>\n";
                        // CRTMOD - no comments
			// Changed line
			if (!$_SESSION["addcomments"]){
			// if ($viewmode=="single"){
				$comments = ".";
			} else {
				$comments = "<a href='#' class='link' onclick=\"window.open('".form_url("comment_view.php?blogid=".$view_rows[$i]["nIdCode"]."&i=".$view_rows[$i]["nIdCode"])."','Comments','resizable=no,menubar=no,scrollbars=yes,toolbar=no,fullscreen=no,width=500,height=500')\">".$view_rows[$i]["nComments"]." comments</a>";
			}
			$html .= "  <tr><td colspan='2' bgcolor='#eeeeee' align='center'><span class='small'>".$comments."</span></td></tr>\n";
			// create the bodytext table row
			//Check that nCategory != 0. If it doesn't, then show the image, if it does, show no image.
                        if ($view_rows[$i]["nCategory"]!=0 && !($catrow["bNoImg"])){
                           if ($_SESSION["swearfilter_blog"]){
                              $html .= "  <tr><td colspan='2' bgcolor='#ffffff'><table border='0' width='100%' cellpadding='5'><tr><td><p class='blog_title'>".stripslashes($view_rows[$i]["cTitle"])."</p><span class='blog_body'><img src='".$catrow['cImgPath']."' alt='".$catrow['cCategory']." Blog Category' align='right'>".clean_text(CodeParse(QuoteParse(SwearFilter(parsesmilies(stripslashes($view_rows[$i]["cBody"]))))))."</span></td></tr></table></td></tr>\n";
                           } else {
                              $html .= "  <tr><td colspan='2' bgcolor='#ffffff'><table border='0' width='100%' cellpadding='5'><tr><td><p class='blog_title'>".stripslashes($view_rows[$i]["cTitle"])."</p><span class='blog_body'><img src='".$catrow['cImgPath']."' alt='".$catrow['cCategory']." Blog Category' align='right'>".clean_text(CodeParse(QuoteParse(parsesmilies(stripslashes($view_rows[$i]["cBody"])))))."</span></td></tr></table></td></tr>\n";
                           }
                        } else {
                           if ($_SESSION["swearfilter_blog"]){
                              $html .= "  <tr><td colspan='2' bgcolor='#ffffff'><table border='0' width='100%' cellpadding='5'><tr><td><p class='blog_title'>".stripslashes($view_rows[$i]["cTitle"])."</p><span class='blog_body'>".clean_text(CodeParse(QuoteParse(SwearFilter(parsesmilies(stripslashes($view_rows[$i]["cBody"]))))))."</span></td></tr></table></td></tr>\n";
                           } else {
                              $html .= "  <tr><td colspan='2' bgcolor='#ffffff'><table border='0' width='100%' cellpadding='5'><tr><td><p class='blog_title'>".stripslashes($view_rows[$i]["cTitle"])."</p><span class='blog_body'>".clean_text(CodeParse(QuoteParse(parsesmilies(stripslashes($view_rows[$i]["cBody"])))))."</span></td></tr></table></td></tr>\n";
                           }
                        }
			if (!$_SESSION["viewcomments"]){
                           // Do nothing
			} else {
			   // in multiple mode - therefore show link to view the comments in a seperate page...
                        }
		}
	} else {
		// there are no blogs to show
		$html .= "  <tr><td colspan='2' bgcolor='#ffffff'><span class='normal'>There are no blogs to show in this view. Use the navigation, calendar, and archive controls on the left to check for other blogs.</span></td></tr>\n";
	}
	// end the table containing the blogs
	$html .="</table>\n";
	return $html;
}


// Function    : html_commentsview
// Description : Returns the html to represent the pop-up comments list used in multiple mode
// Arguments   : $i - index of a blog in the view array of arrays
// Returns     : html data
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function html_commentsview($i){
        global $html;
	global $swearfilter_comments;
	global $view_rows;
	global $viewcomments;
        $con = db_connect();
	//global $view_comment_rows;
	include_once("./lib/smiley.php");
	// start the comments table
	$html .= "<table width='100%' border='0' cellspacing='1' cellpadding='2'>\n";
        if ($_SESSION["viewcomments"]) {
           $sql = "SELECT * FROM blog_comments WHERE nBlogId=".$i." ORDER BY nIdCode DESC";
	   $result = mysql_query($sql,$con);
           if ($result!=false){
              while ($comment_rows = mysql_fetch_array($result)){
                // put the admin html in if required
                // Comment editing/deleting modification courtesy of Ryan Thian (ryan@bloggingdoctor.com) GPL'ed code (BlogMod .24)
                $html .=$comment_rows[$j]["nBlodId"];
		if ($_SESSION["userid"]!=""){
		   $html_admin = "&nbsp;&nbsp;&nbsp;[<a class='link' href='".form_url("comment_view.php?action=edit_blog_comment&commentidc=".$comment_rows["nIdCode"]."&i=".$i)."'>Edit</a>]&nbsp;[<a class='link' href='".form_url("blog_exec.php?action=remove_blog_comment&commentidc=".$comment_rows["nIdCode"])."&blogid=".$i."'>Remove</a>]&nbsp;&nbsp;&nbsp;IP Address: ".$comment_rows["cIPAddr"];
                } else {
			$html_admin = "";
		}
		if ($comment_rows["cURL"]!="") {
			$url_html = "[<a href='".$comment_rows["cURL"]."' target='_blank'>Web</a>]";
		} else {
			$url_html = "";
		}
		if (is_email($comment_rows["cEMail"])) {
			$email = "[<a href='mailto:".$comment_rows["cEMail"]."'>E-Mail</a>]";
		} else {
			$email = "";
		}
		// create comment header row
		$html .= "<tr><td bgcolor='#dddddd'><span class='small'>".clean_text(stripslashes($comment_rows["cUsername"]))." wrote...".$email."&nbsp;".$url_html."&nbsp".$html_admin."</span></td></tr>\n";
		// create comment bodytext row
                if ($swearfilter_comments){
                $html .= "<tr><td bgcolor='$bgcolor'><span class='comment_body'>".clean_text(parsesmilies(SwearFilter(stripslashes($comment_rows["cComment"]))))."</span></td></tr>\n";
                } else {
                $html .= "<tr><td bgcolor='$bgcolor'><span class='comment_body'>".clean_text(parsesmilies(stripslashes($comment_rows["cComment"])))."</span></td></tr>\n";
                }
             }
           }
        }
	// end the comments table
	$html .= "</table>\n";
	// comment entry form
	$html .= "<table width='100%' border='0' cellpadding='5' cellspacing='0'><tr><td>\n"
		."<form method='POST' action='".form_url("blog_exec.php?action=add_comment")."'>\n"
		."  <input type='hidden' name='blogid' value='".$i."'>\n"
		."  <table border='1' cellspacing='1' cellpadding='2' bgcolor='#dddddd' align='center'>\n"
		."    <tr><td colspan='2' bgcolor='#cccccc' align='center'><span class='small'><b>Add Comment Form</b></span></td></tr>\n"
		."    <tr><td bgcolor='#dddddd'><span class='small'>Name</span></td><td bgcolor='#eeeeee'><input type='text' name='username' size='70' class='text'></td></tr>\n"
		."    <tr><td bgcolor='#dddddd'><span class='small'>E-Mail</span></td><td bgcolor='#eeeeee'><input type='text' name='email' size='70' class='text'></td></tr>\n"
		."    <tr><td bgcolor='#dddddd'><span class='small'>URL</span></td><td bgcolor='#eeeeee'><input type='text' name='url' size='70' class='text'></td></tr>\n"
		."    <tr><td bgcolor='#dddddd'><span class='small'>Comment</span></td><td bgcolor='#eeeeee'><textarea name='comment' cols='70' rows='3' class='text'></textarea></td></tr>\n"
		."    <tr><td bgcolor='#dddddd' colspan='2' align='right'><input type='submit' value='Add Comment' class='button'></td></tr>\n"
		."  </table>\n"
		."</form>\n"
		."</td></tr></table>\n";
	return $html;
}

// Function    : html_tagline
// Description : Returns the html to create a box for a random, daily tagline
// Arguments   : None
// Returns     : html data
// Author      : Kevin A. Sesock
// Last Change : 2004-06-10
function html_tagline(){
    $con = db_connect();
    $html = "<table width='100%' border='0' bgcolor='#cccccc' cellspacing='1' cellpadding='1'>\n"
           ."  <tr><td bgcolor='#dddddd' align='center'><span class='small'><b>Fortune Cookie:</b></span></td></tr>\n"
           ."  <tr><td bgcolor='#ffffff' align='center'><span class='small'>"
           ."  <table width='100%' border='0' cellspacing='1' cellpadding='2'>\n";
    do {
    $sql = "SELECT * FROM blog_quotes ORDER BY RAND() LIMIT 1;";
    $result = mysql_query($sql, $con);
    if ($result!=false)
       $quote_row = mysql_fetch_array($result);
    } while ($quote_row['bUsableQuote']==1);
    $html .= "  <tr><td bgcolor='#eeeeee' align='center'><span class='small'>";
    $html .= stripslashes(htmlspecialchars($quote_row['cQuote'], ENT_QUOTES))."</span></td></tr>\n";
    $html .= "</table></td></tr></table>\n";
    return $html;
}

// Function    : html_command
// Description : Returns the html to represent the control panel for admin view
// Arguments   : None
// Returns     : html data
// Author      : Kevin A. Sesock
// Last Change : 2004-06-28
function html_command(){
    $html = "<table width='100%' border='0' bgcolor='#cccccc' cellspacing='1' cellpadding='1'>\n"
                ."  <tr><td bgcolor='#dddddd' colspan=2 align='center'><span class='small'><b>Command Center</b></span></td></tr>\n"
                ."  <tr><td bgcolor='#dddddd' colspan=2 align='center'><span class='small'>Logged in as ".$_SESSION["userid"]."</span></td></tr>\n"
		        ."  <tr><td bgcolor='#eeeeee' align='left'><span class='small'><a href='".form_url("admin.php?action=add_blog")."'>Add Entry</a></span></td>\n"
		        ."  <td bgcolor='#eeeeee' align='left'><span class='small'><a href='".form_url("index.php")."'>Standard View</a></span></td></tr>\n"
		        ."  <tr><td bgcolor='#eeeeee' align='left'><span class='small'><a href='".form_url("admin.php?action=cat_listview")."'>Modify Categories</a></span></td>\n"
		        ."  <td bgcolor='#eeeeee' align='left'><span class='small'><a href='".form_url("admin.php?action=tag_listview")."'>Modify Taglines</a></span></td></tr>\n"
		        ."  <tr><td bgcolor='#eeeeee' align='left'><span class='small'><a href='".form_url("admin.php?action=link_listview")."'>Modify Links</a></span></td>\n"
		        ."  <td bgcolor='#eeeeee' align='left'><span class='small'><a href='".form_url("admin.php?action=prof_listview")."'>Modify Profile</a></span></td></tr>\n"
		        ."  <tr><td bgcolor='#eeeeee' align='left'><span class='small'><a href='".form_url("admin.php?action=options")."'>Options</a></span></td>\n"
		        ."  <td bgcolor='#eeeeee' align='left'><span class='small'><a href='".form_url("blog_exec.php?action=logout")."'>Logout</a></span></td></tr>\n"
		."</table>\n";
    return $html;
}
?>