<?php
/*
#===========================================================================
#= Script : Blog
#= File   : html_user.php
#= Version: 1.55b RC2
#= Author : Jonathan Beckett
#= Email  : jonbeckett@pluggedout.com
#= Support: http://www.pluggedout.com/development/forums/viewforum.php?f=5
#= Edits: Soulsniper, Craig Roberts-Thompson, Kevin A. Sesock
#===========================================================================
#= Copyright (c) 2003 Jonathan Beckett
#= You are free to use and modify this script as long as this header
#= section stays intact. This file is part of BLOG.
#=
#= This program is free software; you can redistribute it and/or modify
#= it under the terms of the GNU General Public License as published by
#= the Free Software Foundation; either version 2 of the License, or
#= (at your option) any later version.
#=
#= This program is distributed in the hope that it will be useful,
#= but WITHOUT ANY WARRANTY; without even the implied warranty of
#= MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#= GNU General Public License for more details.
#=
#= You should have received a copy of the GNU General Public License
#= along with BLOG files; if not, write to the Free Software
#= Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#===========================================================================
*/

// Function    : html_myprofile
// Description : Returns the html to represent a table of information about the blog owner
// Arguments   : None, pulls data from db
// Returns     : html data
// Author      : Jonathan Beckett / Kevin A. Sesock
// Last Change : 2004-07-07
function html_myprofile(){
	$title = "My Profile";
        $sql="SELECT * FROM blog_profile ORDER BY nProfileIDCode ASC";
        $con=db_connect();
        $result = mysql_query($sql, $con);
        if ($result) {
           $i=0;
           while ($p_row= @ mysql_fetch_array($result)) {
                 $i++;
                 $p[$i] = $p_row;
           }
        }
	// start the container table
	$html = "<table width='100%' border='0' bgcolor='#cccccc' cellspacing='1' cellpadding='1'>\n"
		."  <tr><td bgcolor='#dddddd' align='center'><span class='small'><b>".$title."</b></span></td></tr>\n"
		."  <tr><td bgcolor='#ffffff' align='center'><span class='small'>";
	// put some content in the table
	$html .= "<table width='100%' border='0' cellspacing='1' cellpadding='2'>\n";
	for ($i=1;$i<=count($p);$i++){
		$html.="<tr>"
			."  <td bgcolor='#dddddd'><span class='small'>".stripslashes($p[$i]["cProfileTitle"])."</span></td>"
			."  <td bgcolor='#eeeeee'><span class='small'>".stripslashes($p[$i]["cProfileText"])."</span></td>"
			."</tr>\n";
	}
	$html .= "</table>\n";
	// end the container table
	$html .= "</td></tr></table>\n";
	return $html;
}



// Function    : html_mylinks
// Description : Returns the html to represent a table of favourite links
// Arguments   : None, pulls data from db
// Returns     : html data
// Author      : Jonathan Beckett/ Kevin A. Sesock
// Last Change : 2004-07-07
function html_mylinks(){
	$title = "Links";
        $sql="SELECT * FROM blog_links ORDER BY cTitle ASC";
        $con=db_connect();
        $result = mysql_query($sql, $con);
        if ($result) {
           $i=0;
           while ($link = @ mysql_fetch_array($result)) {
                 $i++;
                 $links[$i] = $link;
           }
        }
	// start the container table
	$html = "<table width='100%' border='0' bgcolor='#cccccc' cellspacing='1' cellpadding='1'>\n"
		."  <tr><td bgcolor='#dddddd' align='center'><span class='small'><b>".$title."</b></span></td></tr>\n"
		."  <tr><td bgcolor='#ffffff' align='center'><span class='small'>"
		."  <table width='100%' border='0' cellspacing='1' cellpadding='2'>\n";
	// loop through and output the links. Use dLastUpdate to determine if it's been updated recently.
	for ($i=1;$i<=count($links);$i++){
		$html .= "<tr><td bgcolor='#dddddd' align='center'><span class='small'>";
                if ($_SESSION["use_weblogsxml"]){
                   if ((gmtime() - strtotime($links[$i]["dLastUpdate"])) <= ($_SESSION["HourUpdatePersist"]*3600)){
                      $html .="<strong><u><a href='".stripslashes($links[$i]["cURL"])."' target='_blank' title='The link ".stripslashes(htmlspecialchars($links[$i]["cTitle"], ENT_QUOTES))." has been updated within the last ".$_SESSION["HourUpdatePersist"]." Hours'>".stripslashes($links[$i]["cTitle"])."</a><u></strong></u></td></tr>\n";
                   } else {
                      $html .="<a href='".stripslashes($links[$i]["cURL"])."' target='_blank'>".stripslashes($links[$i]["cTitle"])."</a></span></td></tr>\n";
                   }
                } else {
                   $html .="<a href='".stripslashes($links[$i]["cURL"])."' target='_blank'>".stripslashes($links[$i]["cTitle"])."</a></span></td></tr>\n";
                }
	}

	// end the container table
	$html .= "</table></td></tr></table>\n";
	return $html;
	// start the container table
	$html = "<table width='100%' border='0' bgcolor='#cccccc' cellspacing='1' cellpadding='1'>\n"
		."  <tr><td bgcolor='#dddddd' align='center'><span class='small'><b>".$title."</b></span></td></tr>\n"
		."  <tr><td bgcolor='#ffffff' align='center'><span class='small'>"
		."  <table width='100%' border='0' cellspacing='1' cellpadding='2'>\n";

	// loop through and output the links
	for ($i=1;$i<=count($blogs);$i++){
		$html .= "<tr><td bgcolor='#dddddd' align='center'><span class='small'><a href='".$blogs[$i]["u"]."' target='_blank'>".$blogs[$i]["t"]."</a></span></td></tr>\n";
	}
	// end the container table
	$html .= "</table></td></tr></table>\n";
	return $html;
}

// Function    : html_mysong
// Description : Returns the html to represent the current played song in winamp
// Arguments   : None
// Returns     : html data
// Author      : SoulSniper
// Last Change : 2004-05-17
function html_mysong(){

	$title = "Listening to:";
	$filename = "lib/song.txt";
	$file = fopen($filename, "r");
	$contents = fread($file, filesize($filename));
	fclose($file);
	$songname = $contents;
	$html = "<table width='100%' border='0' bgcolor='#cccccc' cellspacing='1' cellpadding='1'>\n"
		."  <tr><td bgcolor='#dddddd' align='center'><span class='small'><b>".$title."</b></span></td></tr>\n"
		."  <tr><td bgcolor='#ffffff' align='center'><span class='small'>"
		."  <table width='100%' border='0' cellspacing='1' cellpadding='2'>\n"
		."  <tr><td bgcolor='#eeeeee' align='center'><span class='small'>".stripslashes($songname)."<br><a href='http://www.winamp.com'><img src='images/winamp.gif' border='0'></a></span></td></tr>\n";
	$html .= "</table></td></tr></table>\n";
	return $html;
}

// Function    : html_mypic
// Description : Returns the html to show the user's avatar
// Arguments   : None
// Returns     : html data / image
// Author      : SoulSniper/ Kevin A. Sesock
// Last Change : 2004-07-08
function html_mypic(){

	$title = "Avatar";
	$html = "<table width='100%' border='0' bgcolor='#cccccc' cellspacing='1' cellpadding='1'>\n"
		."  <tr><td bgcolor='#dddddd' align='center'><span class='small'><b>".$title."</b></span></td></tr>\n"
		."  <tr><td bgcolor='#ffffff' align='center'><span class='small'>"
		."  <table width='100%' border='0' cellspacing='1' cellpadding='2'>\n"
		."  <tr><td bgcolor='#eeeeee' align='center'><span class='small'><a href=mailto:".stripslashes($_SESSION["login_email"])."><img src='".stripslashes($_SESSION['avatar_path'])."'></a></span></td></tr>\n";
	$html .= "</table></td></tr></table>\n";
	return $html;
}

// Function    : html_showxml
// Description : Shows an image of XML and a link to the RSS feed of this blog.
// Arguments   : $URL_Prefix
// Returns     : image / rss link
// Author      : SoulSniper
// Last Change : 2004-05-17
function html_showxml(){

	$title = "RSS Feed";
	$html = "<table width='100%' border='0' bgcolor='#cccccc' cellspacing='1' cellpadding='1'>\n"
		."  <tr><td bgcolor='#dddddd' align='center'><span class='small'><b>".$title."</b></span></td></tr>\n"
		."  <tr><td bgcolor='#ffffff' align='center'><span class='small'>"
		."  <table width='100%' border='0' cellspacing='1' cellpadding='2'>\n"
		."  <tr><td bgcolor='#eeeeee' align='center'><span class='small'><a href='".$_SESSION["blog_url"]."rss.xml'><img src='images/xml.gif' border='0'></span></td></tr>\n";
	$html .= "</table></td></tr></table>\n";
	return $html;
}

// CRTMOD - posts archive
// New lines
// Function    : html_archive
// Description : Returns the html to represent a list of months with posts
// Arguments   : None
// Returns     : html data
// Author      : Craig Roberts-Thomson
// Last Change : 2004-05-19
function html_archive() {
    global $months; // Array of month names from misc.php
    $html = '';
    $con = db_connect();
    $sql = "SELECT COUNT(*) AS posts, YEAR(dEntryDate) AS year, MONTH(dEntryDate) AS month ";
    if (strpos($_SERVER["PHP_SELF"],"admin.php")==true){
       $sql.= "FROM blog ";
    } else {
       $sql.= "FROM blog WHERE bDraft=0 ";
    }
    $sql.= "GROUP BY YEAR(dEntryDate), MONTH(dEntryDate)";
    $result = mysql_query($sql,$con);
    if ( $result ) {
        $numRows = mysql_num_rows($result);
        $tableArray = array();
        $html .= "<table width='100%' border='0' bgcolor='#dddddd' cellspacing='1' cellpadding='1' class='small'>\n";
        $html .= "<tr><td align='center' colspan=2><b>Blog Archive</b></td>\n";
        // We need to first get our table cells into an array, as we want
        // the listing to be by columns, e.g.:
        // +---------------+---+-+--------------+---+
        // | 2004 January  | 4 | | 2004 April   | 2 |
        // | 2004 February | 9 | | 2004 May     | 1 |
        // | 2004 March    | 6 | |              |   |
        // +---------------+---+-+--------------+---+
        // and we won't have April until after we do March. So get the entire
        // results and format the cells, but leave putting them into the table
        // until after we have them all.
        while ( $row = @ mysql_fetch_array($result) ) {
            $year   = $row['year'];
            $month  = $row['month'];
            $monthN = $months[$month-1];
            $count  = $row['posts'];
            $tableArray[] = "<td bgcolor='#ffffff' align='left' width='50%'>"
                . "<a class='link' href='".form_url($_SERVER["PHP_SELF"]."?year=".$year."&month=".$month)."'>"
                . $year." ".$monthN."</a> (".$count.")</span></td>\n";
        }
        // Now form the table. We have 2 columns, so there will be ceil(x/2) rows
        $tableRows = ceil($numRows/2);
        for ($i=0; $i<$tableRows; $i++) {
            $html .= "<tr>\n";
            $html .= $tableArray[$i];
            //$html .= "<td bgcolor='#ffffff'></td>";
            if (isset($tableArray[$i+$tableRows])) $html.=$tableArray[$i+$tableRows];
            else                                   $html.="<td bgcolor='#ffffff'></td>\n";
            $html .= "</tr>\n";
        }
        $html .= "</table>\n";
    } else {
        print "<li>Problem with SQL<br>[".$sql."]";
    }
    return $html;
}

// Function    : html_categories
// Description : Returns the html to represent a listbox for categories
// Arguments   : None
// Returns     : html data
// Author      : Kevin A. Sesock
// Last Change : 2004-06-12
function html_categories(){
    $con = db_connect();
    if (strpos($_SERVER["PHP_SELF"],"admin.php")==true){
       $sql_count = "SELECT blog_category.cCategory, blog_category.nCatIDCode As category_num, COUNT(blog.nCategory) AS count FROM blog_category LEFT OUTER JOIN blog ON blog_category.nCatIDCode=blog.nCategory GROUP BY blog_category.cCategory;";
    } else {
       $sql_count = "SELECT blog_category.cCategory, blog_category.nCatIDCode As category_num, COUNT(blog.nCategory) AS count FROM blog_category LEFT OUTER JOIN blog ON blog_category.nCatIDCode=blog.nCategory WHERE blog.bDraft=0 GROUP BY blog_category.cCategory;";
    }
    $result_count = mysql_query($sql_count,$con);
    if ( $result_count ) {
        $numRows = mysql_num_rows($result_count);
        $tableArray = array();
        $html .= "<table width='100%' border='0' bgcolor='#dddddd' cellspacing='1' cellpadding='1' class='small'>\n";
        $html .= "<tr><td align='center' colspan=2><b>Categories</b></td>\n";
        $row = 1;
        while ($row_count= @ mysql_fetch_array($result_count)) {
          if ($row_count['count']!=0){
             if($row) $html .= "<tr>";
             $row = ($row == 1) ? 0 : 1;  //oscillate between 1 and 0 for each column to place the <tr> properly
             $html .= "<td bgcolor='#ffffff' align='left' width='50%'><span><a class='link' href='".form_url($_SERVER["PHP_SELF"]."?category=".$row_count['category_num'])."'>";
             $html .=$row_count['cCategory']."</a> (".$row_count['count'].")</span></td>\n";
          }
        }
        $html .= "</table>\n";
    } else {
        print "<li>Problem with SQL<br>[".$sql."]";
    }
    return $html;
}

?>