<?php
/*
#===========================================================================
#= Script : Blog
#= File   : misc.php
#= Version: 1.55b RC2
#= Author : Jonathan Beckett
#= Email  : jonbeckett@pluggedout.com
#= Support: http://www.pluggedout.com/development/forums/viewforum.php?f=5
#= Edits: Kevin A. Sesock
#===========================================================================
#= Copyright (c) 2003 Jonathan Beckett
#= You are free to use and modify this script as long as this header
#= section stays intact. This file is part of BLOG.
#=
#= This program is free software; you can redistribute it and/or modify
#= it under the terms of the GNU General Public License as published by
#= the Free Software Foundation; either version 2 of the License, or
#= (at your option) any later version.
#=
#= This program is distributed in the hope that it will be useful,
#= but WITHOUT ANY WARRANTY; without even the implied warranty of
#= MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#= GNU General Public License for more details.
#=
#= You should have received a copy of the GNU General Public License
#= along with BLOG files; if not, write to the Free Software
#= Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#===========================================================================
*/

// fixed constants
$months = Array("January","February","March","April","May","June","July","August","September","October","November","December");
$days = Array("Sun","Mon","Tue","Wed","Thu","Fri","Sat");


// Function    : is_email
// Description : Checks if an email address looks like a valid email address
// Arguments   : $email - the email address to check
// Returns     : true/false
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function is_email($email) {
	$validEmailExpr = "^[0-9a-z]([-_.]?[0-9a-z])*@[0-9a-z]([-.]?[0-9a-z])*\\.[a-z]{2,3}$";
	if (eregi($validEmailExpr,$email)) {
		return true;
	} else {
		return false;
	}
}
// Function    : gmtime
// Description : Gets current time and applies timezone (based in session var) to it.
// Arguments   : None
// Returns     : Returns current local time in Unix timestamp format
// Author      : Kevin A. Sesock
// Last Change : 2003-06-30
function gmtime() {
  if (!isset($_SESSION["timezone"])) {
     loadconfig();
     $local_time = time() + ($_SESSION["timezone"] * 3600);
     if ($_SESSION["dst_on"]) $local_time += 3600;
  } else {
     $local_time = time() + ($_SESSION["timezone"] * 3600);
     if ($_SESSION["dst_on"]) $local_time += 3600;
  }
  return $local_time;
}

// Function    : is_alphanumeric
// Description : Checks if a value is alphanumeric or not
// Arguments   : $input - the value to check
// Returns     : true/false
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function is_alphanumeric($input) {
	if ( preg_match("/[^a-zA-Z0-9]/",$input) ) {
		return true;
	} else {
		return false;
	}
}


// Function    : get_date_part
// Description : Returns part of an SQL standard date (yyyy-mm-dd)
// Arguments   : $sqldate - the date to grab bits from
//               $part    - the part of the day to grab
// Returns     : a substring of the data passed to it
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function get_date_part($sqldate,$part) {
	// expects date in format yyyy-mm-dd hh:nn:ss
	switch ($part)
	{
		case "day":
			$result = substr($sqldate,8,2);
			break;
		case "month":
			$result = substr($sqldate,5,2);
			break;
		case "year":
			$result = substr($sqldate,0,4);
			break;
                case "hour":
                        $result = substr($sqldate,11,2);
                        break;
                case "minute":
                        $result = substr($sqldate,13,2);
                        break;
                case "second":
                        $result = substr($sqldate,15,2);
                        break;
	}
	return $result;
}


// Function    : clean_text
// Description : Swaps carriage returns for html breaks (<br>) in supplied data
// Arguments   : $input - data to perform operation on
// Returns     : transformed data
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function clean_text($input){
	$result = ereg_replace("\n","<br>",$input);
	return $result;
}


// Function    : ProcessRSS
// Description : Generates a file called RSS.XML which has RSS content in
// Arguments   : Uses superglobals
// Returns     : Nothing (but a file is created)
// Author      : SoulSniper / Jonathan Beckett / Kevin A. Sesock
// Last Change : 2004-07-08
function ProcessRSS(){
$con = db_connect();
$sql = "SELECT * FROM blog WHERE (bDraft=0 AND bPrePost=0) OR (bPrePost=1 AND bDraft=0 AND dEntryDate < '".gmdate('Y-m-d H:i:s',gmtime())."') ORDER BY dEntryDate DESC;";
$result = mysql_query($sql, $con);
if ($result!=false) {
   $i=0;
   while ($rss_row =@ mysql_fetch_array($result)){
     $i++;
     $rss_rows[$i] = $rss_row;
   }
}

// XML Header Information
$output .= "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
$output .= "<!-- RSS generated by ".stripslashes(xmlentities($_SESSION['blog_title']))." -->\n";
$output .= "<rss version=\"2.0\" xmlns:blogChannel=\"http://backend.userland.com/blogChannelModule\">\n";
$output .= "<channel>\n";
$output .= "<title>".stripslashes(xmlentities($_SESSION['blog_title']))."</title>\n";
$output .= "<link>".stripslashes($_SESSION['blog_url'])."</link>\n";
$output .= "<description>".stripslashes(xmlentities($_SESSION['blog_subtext']))."</description>\n";
$output .= "<copyright>".stripslashes(xmlentities($_SESSION['copyright']))."</copyright>\n";
$output .= "<language>en-GB</language>\n";
$output .= "<webMaster>".stripslashes($_SESSION['login_email'])."</webMaster>\n";
$output .= "<blogChannel:".stripslashes($_SESSION['rss_feedname']).">".stripslashes($_SESSION['blog_url'])."rss.xml</blogChannel:".$_SESSION['rss_feedname'].">\n";
$buildDate = gmdate("D, d M Y H:i:s ", Time()) . "GMT";
$output .= "<lastBuildDate>".$buildDate."</lastBuildDate>\n";


for ($i=1;$i<=count($rss_rows);$i++){
   $output .= "  <item>\n";
   $output .= "    <title>".stripslashes(xmlentities($rss_rows[$i]["cTitle"]))."</title>\n";
   $output .= "    <link>".stripslashes($_SESSION['blog_url'])."index.php?blogid=".$rss_rows[$i]["nIdCode"]."</link>\n";
   $output .= "    <author>".stripslashes($_SESSION['login_email'])." (".stripslashes($_SESSION['author_name']).")</author>\n";
   $output .= "    <description>".stripslashes(xmlentities($rss_rows[$i]["cBody"]))."</description>\n";

   //Wed, 02 Oct 2002 13:00:00 GMT 
   $date = strtotime($rss_rows[$i]["dEntryDate"]);
   $rfc_date = gmdate("D, d M Y H:i:s ", $date) . "GMT"; 
   $output .= "    <pubDate>".$rfc_date."</pubDate>\n"; 
   $output .= "  </item>\n"; 
} 

$output .= "</channel>\n"; 
$output .= "</rss>\n"; 

$handle = fopen("rss.xml","w"); 
fwrite($handle,$output); 
fclose($handle); 

}

// Function    : CodeParse
// Description : Searches for [CODE] and [/CODE] and replaces them
// Arguments   : $input - The text to work on
// Returns     : The replaced text
// Author      : SoulSniper
// Last Change : 2004-15-20
function CodeParse($input) {
 error_reporting(E_ALL);
    return preg_replace_callback('/\[CODE\](.*?)\[\/CODE\]/s',
     '__EscapeCode__', $input);
}
function __EscapeCode__($m) {
    return '</span><table width="90%" cellspacing="1" cellpadding="3" border="0" align="center"><tr><td><span class="small"><b>Code:</b></span></td></tr><tr><td class="code">'
    . htmlspecialchars($m[1])
    . '</td></tr></table><span class="blog_body">';
}

// Function    : QuoteParse
// Description : Searches for [QUOTE] and [/QUOTE] and replaces them
// Arguments   : $input - The text to work on
// Returns     : The replaced text
// Author      : SoulSniper
// Last Change : 2004-15-19

function QuoteParse($input){

$before = array("[QUOTE]", "[/QUOTE]"); 
$after  = array('</span><table width="90%" cellspacing="1" cellpadding="3" border="0" align="center"><tr><td><span class="small"><b>Quote:</b></span></td></tr><tr><td class="quote"><!--QUOTE-->','<!--QUOTE--></td></tr></table><span class="blog_body">'); 
$return = str_replace($before, $after, $input);

		$return = str_replace("  ", "&nbsp; ", $return);
		// now Replace 2 spaces with " &nbsp;" to catch odd #s of spaces.
		$return = str_replace("  ", " &nbsp;", $return);

		// Replace tabs with "&nbsp; &nbsp;" so tabbed code indents sorta right without making huge long lines.
		$return = str_replace("\t", "&nbsp; &nbsp;", $return);

		// now Replace space occurring at the beginning of a line
		$return = preg_replace("/^ {1}/m", '&nbsp;', $return);

return $return;
}

// Function    : SwearFilter
// Description : Replaces naughty words ;)
// Arguments   : $input - The text to work on
// Returns     : The replaced text
// Author      : SoulSniper
// Last Change : 2004-15-20

function SwearFilter($input){

$before = array('fuck','shit', 'piss', 'cunt');
$after  = array('f**k','s**t', 'p**s', 'c**t'); 
$return = str_replace($before, $after, $input);

return $return;
}

// CRTMOD - fn validate_datetime
// New lines
// Function    : validate_datetime
// Description : Verifies that the datetime is valid
// Arguments   : $dt - datetime to check
// Returns     : true/false
// Author      : Craig Roberts-Thomson
// Last Change : 2004-05-13
function validate_datetime($dt) {
    // any day between 01 and 31
    $RE_DATE_DAY     = '(0[1-9]|[12][0-9]|3[01])';
    // any month between 01 and 12, jan and dec, january and december
    $RE_DATE_MONTH   = '(0[1-9]|1[0-2]';
    $RE_DATE_MONTH  .= '|jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec';
    $RE_DATE_MONTH  .= '|january|february|march|april|may|june|july|august|september|october|november|december)';
    // any year between 1900 and 2009, and 00 and 99
    $RE_DATE_YEAR    = '(200[0-9]|19[0-9][0-9]|[0-9][0-9])';
    // accept either "/" or "-"
    $RE_DATE_SEPARATOR = '[\/-]';
    // hour between 01 ans 24
    $RE_TIME_HOUR      = '([01][0-9]|2[0-3])';
    // min between 00 and 59
    $RE_TIME_MINUTE    = '([0-5][0-9])';
    // sec between 00 and 59
    $RE_TIME_SECOND    = '([0-5][0-9])';
    // accept any casing combination of am|pm
    $RE_TIME_AMPM      = '([aApP][Mm])';
    // separate hours and minutes with the ":" char
    $RE_TIME_SEPARATOR = '\:';

    $RE_DATE     = $RE_DATE_YEAR.$RE_DATE_SEPARATOR.$RE_DATE_MONTH.$RE_DATE_SEPARATOR.$RE_DATE_DAY;
    $RE_TIME     = $RE_TIME_HOUR.$RE_TIME_SEPARATOR.$RE_TIME_MINUTE.'(?:'.$RE_TIME_SEPARATOR.$RE_TIME_SECOND.')(?:'.$RE_TIME_AMPM.')?';
    $RE_DATETIME = '^'.$RE_DATE.' '.$RE_TIME.'$';
    $RegExp = "#".$RE_DATETIME."#i";

    if ( !preg_match($RegExp, $dt, $reg)  ) return false;
    $year = $reg[1];
    $month = strtoupper($reg[2]);
    $day = $reg[3];
    $hour = $reg[4];
    $min = $reg[5];
    $mer = isset($reg[6])?strtoupper($reg[6]):'';

    // Now we have all the elements, make sure that they make sense
    // Year Checks
    // First add on century for 2 digit year
    // We assume >09 is 1900s as 2009 is the max year we accept
    if ( strlen($year) == 2 ) $year += $year<9?2000:1900;
    // Is it a leap year
    $leap = $year%4?false:($year%100?true:($year%400?false:true));

    // Month checks
    $daysMonth = array(
        1=>31, 2=>28, 3=>31, 4=>30,   5=>31,  6=>30,
        7=>31, 8=>31, 9=>30, 10=>31, 11=>30, 12=>31);
    $daysMonth['JAN'] = $daysMonth['JANUARY'] = 31;
    $daysMonth['FEB'] = $daysMonth['FEBRUARY'] = 28;
    $daysMonth['MAR'] = $daysMonth['MARCH'] = 31;
    $daysMonth['APR'] = $daysMonth['APRIL'] = 30;
    $daysMonth['MAY'] = $daysMonth['MAY'] = 31;
    $daysMonth['JUN'] = $daysMonth['JUNE'] = 30;
    $daysMonth['JUL'] = $daysMonth['JULY'] = 31;
    $daysMonth['AUG'] = $daysMonth['AUGUST'] = 31;
    $daysMonth['SEP'] = $daysMonth['SEPTEMBER'] = 30;
    $daysMonth['OCT'] = $daysMonth['OCTOBER'] = 31;
    $daysMonth['NOV'] = $daysMonth['NOVEMBER'] = 30;
    $daysMonth['DEC'] = $daysMonth['DECEMBER'] = 31;
    $m = (int) $month;
    if ($leap) $daysMonth['2']=$daysMonth['FEB']=$daysMonth['FEBRUARY']=29;
    $dm = $m ? $daysMonth[$m] : $daysMonth[$month];

    // Day checks
    if ($day>$dm) return false;

    // Hour checks
    if ( $hour>12 && $mer=="AM" ) return false;
    if ( $hour==0 && $mer=="PM" ) return false;

    return true;
}

function xmlentities($string, $quote_style=ENT_COMPAT){
   $trans = get_html_translation_table(HTML_ENTITIES, $quote_style);
   foreach ($trans as $key => $value)
       $trans[$key] = '&#'.ord($key).';';

   return strtr($string, $trans);
}

?>