<?php
/*
#===========================================================================
#= Script : Blog
#= File   : ping.php
#= Version: 1.55b RC2
#= Author : Christian Schmidt
#= Email  : kevin@sesock.com
#= Support: http://www.pluggedout.com/development/forums/viewforum.php?f=5
#= Edits: Kevin A. Sesock
#===========================================================================
#= Copyright (c) 2003 Jonathan Beckett
#= You are free to use and modify this script as long as this header
#= section stays intact. This file is part of BLOG.
#=
#= This program is free software; you can redistribute it and/or modify
#= it under the terms of the GNU General Public License as published by
#= the Free Software Foundation; either version 2 of the License, or
#= (at your option) any later version.
#=
#= This program is distributed in the hope that it will be useful,
#= but WITHOUT ANY WARRANTY; without even the implied warranty of
#= MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#= GNU General Public License for more details.
#=
#= You should have received a copy of the GNU General Public License
#= along with BLOG files; if not, write to the Free Software
#= Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#=
#= Notice! This code is offered public domain (C) by Christian Schmidt.
#===========================================================================
*/

// Code for notifying Weblogs.com and others about updates using the 
// weblogUpdates.ping syntax - by Christian Schmidt
// The code may be freely used, copied, modified, distributed etc.


function weblogUpdates_ping($host, $port, $path, $method, $name, $url, $debug = false) {
	$postdata = '<?xml version="1.0" encoding="iso-8859-1"?>
	   <methodCall>
	     <methodName>' . htmlspecialchars($method) . '</methodName>
	     <params>
	       <param><value><string>' . htmlspecialchars($name) . '</string></value></param>
	       <param><value><string>' . htmlspecialchars($url) . '</string></value></param>
	     </params>
 	   </methodCall>';
	$timeout = 20;
	$fp = fsockopen($host, $port, $errno, $errstr, $timeout);
	if (!$fp) {
		return array(-1, "Could not connect to $host:$port");
	}
	socket_set_timeout($fp, $timeout);
	$request = "POST $path HTTP/1.0\r\n" .
		"Host: $host\r\n" .
		"Content-Type: text/xml\r\n" .
		"User-Agent: Aggemam XML-RPC client\r\n" .
		"Content-Length: " . strlen($postdata) . "\r\n" .
		"\r\n" .
		$postdata;
	fputs($fp, $request);
	if ($debug) {
		print "<div style='color: blue; white-space: pre'>";
		print htmlspecialchars($request);
		print "</div>";
	}
	$response = '';
	while (!feof($fp)) {
		$response .= fgets($fp, 1024);
		$status = socket_get_status($fp);
		if ($status['timed_out']) {
			fclose($fp);
			return array(-2, "Request timed out");
		}
	}
	fclose($fp);
	if ($debug) {
		print "<div style='color: green; white-space: pre'>";
		print htmlspecialchars($response);
		print "</div>";
	}
	if (preg_match('|<methodResponse>\s*<params>\s*<param>\s*<value>\s*<struct>\s*' .
		'<member>\s*<name>flerror</name>\s*<value>\s*<boolean>([^<])</boolean>\s*</value>\s*</member>\s*' .
		'<member>\s*<name>message</name>\s*<value>(\s*<string>)?([^<]*)(</string>\s*)?</value>\s*</member>\s*' .
		'</struct>\s*</value>\s*</param>\s*</params>\s*</methodResponse>' .
		'|s', $response, $reg)) {
		return array($reg[1], $reg[3]);
	} else {
		return array(-3, "Malformed reply:\n" . $response);
	}
}

?>