<?

$config['version'] = '1.8.5';

/**
* Create new Smarty object 
* @return double Smarty to newly created Smarty object
*
*/
function new_smarty(){
    global $config;
    switch ($config['tpl_cache_level']){
    case '2':
        $t = new Smarty();
        $t->force_compile = 0;
        break;
    case '1': 
        require_once($config['root_dir'].'/smarty/SmartySingleDir.class.php');
        $t = new SmartySingleDir();
        $t->force_compile = 0;
        break;
    case '0': default:
        require_once($config['root_dir'].'/smarty/SmartyNoWrite.class.php');
        $t = new SmartyNoWrite();
        $t->force_compile = 1;
        $t->compile_check = 1;
        break;
    }
    $t->template_dir = "$config[root_dir]/templates";
    $t->compile_dir  = "$config[root_dir]/templates_c";

    ///
    $t->assign('config', $config);
    return $t;
}

/**
* Check email using regexes
* @param string email
* @return bool true if email valid, false if not
*/

function check_email($email) {
    #characters allowed on name: 0-9a-Z-._ on host: 0-9a-Z-. on between: @
    if (!preg_match('/^[0-9a-zA-Z\.\-\_]+\@[0-9a-zA-Z\.\-]+$/', $email))
        return false;

    #must start or end with alpha or num
    if ( preg_match('/^[^0-9a-zA-Z]|[^0-9a-zA-Z]$/', $email))
        return false;

    #name must end with alpha or num
    if (!preg_match('/([0-9a-zA-Z_]{1})\@./',$email) )                    
        return false;

    #host must start with alpha or num
    if (!preg_match('/.\@([0-9a-zA-Z_]{1})/',$email) )                    
        return false;

    #pair .- or -. or -- or .. not allowed
    if ( preg_match('/.\.\-.|.\-\..|.\.\..|.\-\-./',$email) )
        return false;

    #pair ._ or -_ or _. or _- or __ not allowed
    if ( preg_match('/.\.\_.|.\-\_.|.\_\..|.\_\-.|.\_\_./',$email) )
        return false;

    #host must end with '.' plus 2-5 alpha for TopLevelDomain
    if (!preg_match('/\.([a-zA-Z]{2,5})$/',$email) )
        return false;

    return true;
}

/**
* Retrieve input vars, trim spaces and return as array
* @return array array of input vars (HTTP_POST_VARS or HTTP_GET_VARS)
*
*/
function get_input_vars(){
    global $HTTP_SERVER_VARS;
    $REQUEST_METHOD = $HTTP_SERVER_VARS['REQUEST_METHOD'];
    global $HTTP_POST_VARS;
    global $HTTP_GET_VARS;

    $vars = $REQUEST_METHOD == 'POST' ? $HTTP_POST_VARS : $HTTP_GET_VARS;
    foreach ($vars as $k=>$v){
        if (is_array($v)) continue;
        if (get_magic_quotes_gpc()) $v = stripslashes($v);
        $vars[$k] = trim($v);
    }

		$vars['page'] = $_GET['page'];
		if (substr($vars['page'], 0, 1) == '/')
		{
			$vars['page'] = substr($vars['page'], 1);
		}

    return $vars;
}

/**
* Display fatal error to user. 
* Should send mail and save log (not implemented yet)
* Exit current script
* return bool should never return
*/
function fatal_error($error){
    global $config, $db;
    global $in_fatal_error; //!
    $in_fatal_error++;
    if ($in_fatal_error > 2){
        die("<br><br><b>fatal_error called twice</b>");
    }
    $t = & new_smarty();    
    $t->assign('error', $error);
    $t->assign('admin_email', $config['admin_email']);
    $t->display("fatal_error.html");
    // log error
    $db->log_error($error);
    exit;
}

function set_date_from_smarty($prefix, &$vars){
    return $vars[$prefix] = sprintf('%04d-%02d-%02d', 
        $vars[$prefix.  'Year'],
        $vars[$prefix.  'Month'],
        $vars[$prefix.  'Day']
    );
}

function mail_signup_user($payment_id){
    global $t, $db, $config;
    if (!is_object($t))
        $t = & new_smarty();
    $p = $db->get_payment($payment_id);
    $u = $db->get_user($p['member_id']);
    $product = get_product($p['product_id']);
    ///////////////////////////////////
    $t->assign('login', $u['login']);
    $t->assign('pass',  $u['pass']);
    $t->assign('name_f', $u['name_f']);
    $t->assign('name_l', $u['name_l']);
    ///////////////////////////////////
    $t->assign('user', $u);
    $t->assign('payment', $p);
    $t->assign('product', $product->config);
    ///////////////////////////////////
    $mail = $t->fetch("signup_mail.txt");
    mail_customer($u['email'], $mail, "Signup Completed");
}

function mail_customer($email, $text, $subject=''){
    global $config;
    if (!strlen($email)) 
        return;
    if (preg_match('/^Subject: (.+?)[\n\r]+/im', $text, $args)){
        // found subject in body of message! then save it and remove from 
        // message
        $subject = $args[1];
        $text = preg_replace('/(^Subject: .+?[\n\r]+)/im', '', $text);
    }
    mail($email, $subject, $text, 
        "From: $config[admin_email]\r\n"
       ."X-Mailer: aMember (http://cgi-central.net/)" 
    );
}

// output html code and possible header, suitable for redirect
function html_redirect($url, $print_header=0, $title='', $text=''){
print <<<EOF
<html><head>
<title>$title</title>
<META HTTP-EQUIV="Refresh" CONTENT="0; URL=$url">
</head>
<body>
$text
<a href="$url">Continue</a>
</body>
EOF;
}

function read_file($filename){
	$fd = fopen($filename, "rb");
	$data = fread($fd, filesize($filename));
	fclose($fd);
	return $data;
}

function java_redirect($location)
{
	global $t;
	$t->assign('java_script', "<script>location='$location';</script>");
}

function check_username($username)
{
	$res = mysql_query("SELECT COUNT(*) FROM `hsl_host` WHERE `username`='".$username."'");
	$count = mysql_result($res, 0, 0);

	if ($count == 0)
	{
		return false;
	}
	
	return true;
}

function check_company_url($company_url)
{
	$res = mysql_query("SELECT COUNT(*) FROM `hsl_host` WHERE `company_url`='".$company_url."'");
	$count = mysql_result($res, 0, 0);

	if ($count == 0)
	{
		return false;
	}

	return true;
}

function check_exists_company_url($company_url, $username)
{
	$res = mysql_query("SELECT COUNT(*) FROM `hsl_host` WHERE `company_url`='".$company_url."' AND `username`<>'".$username."'");
	$count = mysql_result($res, 0, 0);

	if ($count == 0)
	{
		return false;
	}

	return true;
}

function check_pwd($username, $pwd)
{
	$res = mysql_query("SELECT COUNT(*) FROM `hsl_host` WHERE `username`='".$username."' AND `pwd`='".$pwd."'");
	$count = mysql_result($res, 0, 0);

	if ($count == 0)
	{
		return false;
	}

	return true;
}

function get_hid_by_username($username)
{
	return mysql_result(mysql_query("SELECT `hid` FROM `hsl_host` WHERE `username`='$username'"), 0, 0);
}

################### SERVICES ##################
function CreateServicesPair($values)
{
	global $t;
	$res_service = mysql_query("SELECT * FROM `hsl_service`");
	
	$services = array();
	while ($service = mysql_fetch_array($res_service))
	{
		$service['value'] = $values['service_'.$service['sid']];
		array_push($services, $service);
	}
	
	$services_pair = array();
	for ($i = 0; $i < (count($services)/2); $i++)
	{
		array_push($services_pair, array($services[$i*2], $services[$i*2+1]));
	}
	
#	print_r($services);
	$t->assign('services', $services);
	$t->assign('services_pair', $services_pair);
	return $services;
}

function send_email($to, $template, $subject, $hash, $direct = 0)
{
	global $config;

	if ($direct == 0)
	{
		$email_template = read_file($template);
	}
	else
	{
		$email_template = $template;
	}

	while ( list($key, $value) = each ($hash) )
	{
		$email_template = str_replace("[[$key]]", $value, $email_template);
	}

	$from = $config['smtp_user'];
	$message = $email_template;

	$headers = "";
	$headers .= "MIME-Version: 1.0\r\n";
	$headers .= "Content-type: text/plain\r\n";
	$headers .= "From: ".$from."\r\n";
	$headers .= "X-Priority: 1\r\n";
	$headers .= "X-MSMail-Priority: Normal\r\n";
	$headers .= "X-Mailer: PhpSender";
	mail($to, $subject, $message, $headers);

	/*
	$mail = new htmlMimeMail();
	$mail->setSMTPParams($config['smtp_host'], 25, "helo localhost", $config['smtp_auth'], $config['smtp_user'], $config['smtp_pass']);

	$mail->setText($email_template);
	$mail->setReturnPath($config['smtp_user']);
	$mail->setFrom($config['smtp_user']);
	$mail->setSubject($subject);
	$result = $mail->send(array($to), 'smtp');
	if (!$result) {
		print_r($mail->errors);
	}
	*/
}

function array_addslashes($arr)
{
	while ( list($index, $value) = each ($arr) ) {
		$arr[$index] = addslashes($value);
	}
	return $arr;
}

/*
function hmac ($key, $data)
{
   // RFC 2104 HMAC implementation for php.
   // Creates an md5 HMAC.
   // Eliminates the need to install mhash to compute a HMAC
   // Hacked by Lance Rushing

   $b = 64; // byte length for md5
   if (strlen($key) > $b) {
       $key = pack("H*",md5($key));
   }
   $key  = str_pad($key, $b, chr(0x00));
   $ipad = str_pad('', $b, chr(0x36));
   $opad = str_pad('', $b, chr(0x5c));
   $k_ipad = $key ^ $ipad ;
   $k_opad = $key ^ $opad;

   return md5($k_opad  . pack("H*",md5($k_ipad . $data)));
}
*/

srand((double) microtime() * 1000000); 

?>