DROP TABLE IF EXISTS `hsl_article`;
CREATE TABLE `hsl_article` (
  `aid` int(11) unsigned NOT NULL auto_increment,
  `directory` varchar(255) NOT NULL default '0',
  `title` varchar(255) NOT NULL default '',
  `short` text NOT NULL,
  `link` varchar(255) NOT NULL default '',
  `postdate` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`aid`)
) TYPE=MyISAM;



DROP TABLE IF EXISTS `hsl_automatic`;
CREATE TABLE `hsl_automatic` (
  `name` varchar(255) NOT NULL default '',
  `status` int(1) unsigned NOT NULL default '0'
) TYPE=MyISAM;

INSERT INTO `hsl_automatic` (`name`,`status`) VALUES ('plan','1');
INSERT INTO `hsl_automatic` (`name`,`status`) VALUES ('review','1');


DROP TABLE IF EXISTS `hsl_category`;
CREATE TABLE `hsl_category` (
  `uin` varchar(255) NOT NULL default '',
  `name` varchar(255) NOT NULL default '',
  UNIQUE KEY `uin_index` (`uin`)
) TYPE=MyISAM;

INSERT INTO `hsl_category` (`uin`,`name`) VALUES ('unix-linux','Unix / Linux');
INSERT INTO `hsl_category` (`uin`,`name`) VALUES ('budget','Budget');
INSERT INTO `hsl_category` (`uin`,`name`) VALUES ('windows','Windows');
INSERT INTO `hsl_category` (`uin`,`name`) VALUES ('asp-hosting','ASP Hosting');
INSERT INTO `hsl_category` (`uin`,`name`) VALUES ('php-hosting','PHP Hosting');
INSERT INTO `hsl_category` (`uin`,`name`) VALUES ('managed-servers','Managed Servers');
INSERT INTO `hsl_category` (`uin`,`name`) VALUES ('ecommerce','eCommerce');
INSERT INTO `hsl_category` (`uin`,`name`) VALUES ('reseller','Reseller');
INSERT INTO `hsl_category` (`uin`,`name`) VALUES ('dedicated-servers','Dedicated Servers');
INSERT INTO `hsl_category` (`uin`,`name`) VALUES ('colocation','Colocation');
INSERT INTO `hsl_category` (`uin`,`name`) VALUES ('coldfusion','ColdFusion');


DROP TABLE IF EXISTS `hsl_category_adv`;
CREATE TABLE `hsl_category_adv` (
  `category_adv_id` int(11) unsigned NOT NULL auto_increment,
  `short_text` varchar(255) NOT NULL default '',
  `full_text` text NOT NULL,
  `url` varchar(255) NOT NULL default '',
  `expiry_date` date NOT NULL default '0000-00-00',
  `category` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`category_adv_id`)
) TYPE=MyISAM;



DROP TABLE IF EXISTS `hsl_config`;
CREATE TABLE `hsl_config` (
  `name` varchar(255) NOT NULL default '',
  `value` varchar(255) NOT NULL default '',
  UNIQUE KEY `name` (`name`)
) TYPE=MyISAM;

INSERT INTO `hsl_config` (`name`,`value`) VALUES ('WebInterfacePassword','test');
INSERT INTO `hsl_config` (`name`,`value`) VALUES ('ReceiveAuthorize','1');
INSERT INTO `hsl_config` (`name`,`value`) VALUES ('AuthorizeLogin','ucc621');
INSERT INTO `hsl_config` (`name`,`value`) VALUES ('AuthorizeTransactionKey','t2uIUg5pF0siHGag');
INSERT INTO `hsl_config` (`name`,`value`) VALUES ('ReceiveIntGold','1');
INSERT INTO `hsl_config` (`name`,`value`) VALUES ('IntGoldAccount','206149');
INSERT INTO `hsl_config` (`name`,`value`) VALUES ('ReceiveStormPay','0');
INSERT INTO `hsl_config` (`name`,`value`) VALUES ('StormPayAccount','physician@bigmir.net');
INSERT INTO `hsl_config` (`name`,`value`) VALUES ('ReceivePayPal','0');
INSERT INTO `hsl_config` (`name`,`value`) VALUES ('PayPalAccount','marketing@lobux.com');
INSERT INTO `hsl_config` (`name`,`value`) VALUES ('TestMode','1');


DROP TABLE IF EXISTS `hsl_directory`;
CREATE TABLE `hsl_directory` (
  `uin` varchar(255) NOT NULL default '',
  `name` varchar(255) NOT NULL default '',
  UNIQUE KEY `uin_index` (`uin`)
) TYPE=MyISAM;

INSERT INTO `hsl_directory` (`uin`,`name`) VALUES ('test1','Articles 1');
INSERT INTO `hsl_directory` (`uin`,`name`) VALUES ('test2','Articles 2');
INSERT INTO `hsl_directory` (`uin`,`name`) VALUES ('test32','Articles 33');


DROP TABLE IF EXISTS `hsl_host`;
CREATE TABLE `hsl_host` (
  `hid` int(11) unsigned NOT NULL auto_increment,
  `username` varchar(255) NOT NULL default '',
  `pwd` varchar(255) NOT NULL default '',
  `email` varchar(255) NOT NULL default '',
  `name` varchar(255) NOT NULL default '',
  `address` varchar(255) NOT NULL default '',
  `city` varchar(255) NOT NULL default '',
  `state_province` varchar(255) NOT NULL default '',
  `country` varchar(255) NOT NULL default '',
  `zip_postal` varchar(255) NOT NULL default '',
  `phone` varchar(255) NOT NULL default '',
  `company_url` varchar(255) NOT NULL default '',
  `established` date NOT NULL default '0000-00-00',
  `registered` datetime NOT NULL default '0000-00-00 00:00:00',
  `account_type` smallint(1) unsigned NOT NULL default '0',
  `expired` date NOT NULL default '0000-00-00',
  `currencie` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`hid`),
  UNIQUE KEY `company_url` (`company_url`),
  UNIQUE KEY `username` (`username`)
) TYPE=MyISAM;

INSERT INTO `hsl_host` (`hid`,`username`,`pwd`,`email`,`name`,`address`,`city`,`state_province`,`country`,`zip_postal`,`phone`,`company_url`,`established`,`registered`,`account_type`,`expired`,`currencie`) VALUES ('1','test','123456','mezil@movi.com.ar','TEST','TEST 2011','BS AS','CAPITAL','Argentina','1254','11111111','www.test.com','1999-01-01','0000-00-00 00:00:00','0','0000-00-00','0');
INSERT INTO `hsl_host` (`hid`,`username`,`pwd`,`email`,`name`,`address`,`city`,`state_province`,`country`,`zip_postal`,`phone`,`company_url`,`established`,`registered`,`account_type`,`expired`,`currencie`) VALUES ('2','test2','test','test@test.com','Test','ertsertse','hljkhljkh','ljkhljhl','Albania','1233','123123123123','e-land.com.ua','1993-01-01','0000-00-00 00:00:00','0','0000-00-00','0');
INSERT INTO `hsl_host` (`hid`,`username`,`pwd`,`email`,`name`,`address`,`city`,`state_province`,`country`,`zip_postal`,`phone`,`company_url`,`established`,`registered`,`account_type`,`expired`,`currencie`) VALUES ('3','mezil','12345678','info@mezil.com','test1','test 5241','test','testa','Argentina','5241','52122555','www.test1.com','2005-02-01','0000-00-00 00:00:00','0','0000-00-00','0');


DROP TABLE IF EXISTS `hsl_invite`;
CREATE TABLE `hsl_invite` (
  `host` varchar(255) NOT NULL default '',
  UNIQUE KEY `host` (`host`)
) TYPE=MyISAM;



DROP TABLE IF EXISTS `hsl_order`;
CREATE TABLE `hsl_order` (
  `order_id` int(11) unsigned NOT NULL auto_increment,
  `username` varchar(255) NOT NULL default '',
  `price_id` int(11) NOT NULL default '0',
  `status` varchar(255) NOT NULL default '',
  `description` varchar(255) NOT NULL default '',
  `gateway` varchar(255) NOT NULL default '',
  `postdate` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`order_id`)
) TYPE=MyISAM;



DROP TABLE IF EXISTS `hsl_plan`;
CREATE TABLE `hsl_plan` (
  `pid` int(11) unsigned NOT NULL auto_increment,
  `hid` int(11) unsigned NOT NULL default '0',
  `name` varchar(255) NOT NULL default '',
  `monthly_price` float(5,2) unsigned NOT NULL default '0.00',
  `yearly_price` float(5,2) unsigned NOT NULL default '0.00',
  `webspace` int(10) unsigned NOT NULL default '0',
  `datatransfer` int(10) unsigned NOT NULL default '0',
  `os` int(1) unsigned NOT NULL default '0',
  `purchaseurl` varchar(255) NOT NULL default '',
  `service_videostreaming` int(1) unsigned NOT NULL default '0',
  `service_audiostreaming` int(1) unsigned NOT NULL default '0',
  `service_accountcontrolpanel` int(1) unsigned NOT NULL default '0',
  `service_shellaccess` int(1) unsigned NOT NULL default '0',
  `service_adultsitespermitted` int(1) unsigned NOT NULL default '0',
  `service_php` int(1) unsigned NOT NULL default '0',
  `service_cgipermitted` int(1) unsigned NOT NULL default '0',
  `service_unlimitedftp` int(1) unsigned NOT NULL default '0',
  `service_domainregistration` int(1) unsigned NOT NULL default '0',
  `service_asp` int(1) unsigned NOT NULL default '0',
  `service_perl` int(1) unsigned NOT NULL default '0',
  `service_jsp` int(1) unsigned NOT NULL default '0',
  `service_telephonesupport` int(1) unsigned NOT NULL default '0',
  `service_msfrontpage` int(1) unsigned NOT NULL default '0',
  `service_resellerplan` int(1) unsigned NOT NULL default '0',
  `service_webstatistics` int(1) unsigned NOT NULL default '0',
  `service_secureserver` int(1) unsigned NOT NULL default '0',
  `service_ssi` int(1) unsigned NOT NULL default '0',
  `service_msql` int(1) unsigned NOT NULL default '0',
  `service_mssql` int(1) unsigned NOT NULL default '0',
  `service_coldfusion` int(1) unsigned NOT NULL default '0',
  `service_uniqueipaddress` int(1) unsigned NOT NULL default '0',
  `status` int(1) unsigned NOT NULL default '0',
  `category` varchar(255) NOT NULL default '',
  `service_test` int(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`pid`),
  FULLTEXT KEY `name` (`name`)
) TYPE=MyISAM;

INSERT INTO `hsl_plan` (`pid`,`hid`,`name`,`monthly_price`,`yearly_price`,`webspace`,`datatransfer`,`os`,`purchaseurl`,`service_videostreaming`,`service_audiostreaming`,`service_accountcontrolpanel`,`service_shellaccess`,`service_adultsitespermitted`,`service_php`,`service_cgipermitted`,`service_unlimitedftp`,`service_domainregistration`,`service_asp`,`service_perl`,`service_jsp`,`service_telephonesupport`,`service_msfrontpage`,`service_resellerplan`,`service_webstatistics`,`service_secureserver`,`service_ssi`,`service_msql`,`service_mssql`,`service_coldfusion`,`service_uniqueipaddress`,`status`,`category`,`service_test`) VALUES ('1','1','Plan START','2.00','10.00','50','1000','0','http://www.test.com','1','0','1','0','1','0','1','0','1','0','1','1','0','0','1','1','0','0','1','1','1','0','1','unix-linux','0');
INSERT INTO `hsl_plan` (`pid`,`hid`,`name`,`monthly_price`,`yearly_price`,`webspace`,`datatransfer`,`os`,`purchaseurl`,`service_videostreaming`,`service_audiostreaming`,`service_accountcontrolpanel`,`service_shellaccess`,`service_adultsitespermitted`,`service_php`,`service_cgipermitted`,`service_unlimitedftp`,`service_domainregistration`,`service_asp`,`service_perl`,`service_jsp`,`service_telephonesupport`,`service_msfrontpage`,`service_resellerplan`,`service_webstatistics`,`service_secureserver`,`service_ssi`,`service_msql`,`service_mssql`,`service_coldfusion`,`service_uniqueipaddress`,`status`,`category`,`service_test`) VALUES ('2','1','Plan PLUS','5.00','25.00','100','2000','1','http://www.test.com','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','unix-linux','1');
INSERT INTO `hsl_plan` (`pid`,`hid`,`name`,`monthly_price`,`yearly_price`,`webspace`,`datatransfer`,`os`,`purchaseurl`,`service_videostreaming`,`service_audiostreaming`,`service_accountcontrolpanel`,`service_shellaccess`,`service_adultsitespermitted`,`service_php`,`service_cgipermitted`,`service_unlimitedftp`,`service_domainregistration`,`service_asp`,`service_perl`,`service_jsp`,`service_telephonesupport`,`service_msfrontpage`,`service_resellerplan`,`service_webstatistics`,`service_secureserver`,`service_ssi`,`service_msql`,`service_mssql`,`service_coldfusion`,`service_uniqueipaddress`,`status`,`category`,`service_test`) VALUES ('3','1','Plan ADVANCED','5.00','35.00','200','5000','1','http://www.test.com','1','1','1','1','1','1','0','1','0','1','1','1','1','1','1','1','1','1','1','1','1','0','1','windows','1');


DROP TABLE IF EXISTS `hsl_price`;
CREATE TABLE `hsl_price` (
  `price_id` int(11) unsigned NOT NULL auto_increment,
  `account_type` smallint(1) unsigned NOT NULL default '0',
  `account_name` varchar(255) NOT NULL default '',
  `period` int(2) unsigned NOT NULL default '0',
  `price` float(3,2) NOT NULL default '0.00',
  `enabled` smallint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`price_id`),
  UNIQUE KEY `account_type` (`account_type`,`period`)
) TYPE=MyISAM;

INSERT INTO `hsl_price` (`price_id`,`account_type`,`account_name`,`period`,`price`,`enabled`) VALUES ('1','1','Premium','1','5.00','1');
INSERT INTO `hsl_price` (`price_id`,`account_type`,`account_name`,`period`,`price`,`enabled`) VALUES ('2','1','Premium','3','15.00','1');
INSERT INTO `hsl_price` (`price_id`,`account_type`,`account_name`,`period`,`price`,`enabled`) VALUES ('3','1','Premium','12','30.00','1');
INSERT INTO `hsl_price` (`price_id`,`account_type`,`account_name`,`period`,`price`,`enabled`) VALUES ('4','2','Executive','1','10.00','1');
INSERT INTO `hsl_price` (`price_id`,`account_type`,`account_name`,`period`,`price`,`enabled`) VALUES ('5','2','Executive','3','20.00','1');
INSERT INTO `hsl_price` (`price_id`,`account_type`,`account_name`,`period`,`price`,`enabled`) VALUES ('6','2','Executive','12','30.00','1');


DROP TABLE IF EXISTS `hsl_review`;
CREATE TABLE `hsl_review` (
  `rid` int(11) unsigned NOT NULL auto_increment,
  `company` varchar(255) NOT NULL default '',
  `domain` varchar(255) NOT NULL default '',
  `name` varchar(255) NOT NULL default '',
  `email` varchar(255) NOT NULL default '',
  `speed` int(2) unsigned NOT NULL default '0',
  `reliability` int(2) unsigned NOT NULL default '0',
  `support` int(2) unsigned NOT NULL default '0',
  `price` int(2) unsigned NOT NULL default '0',
  `review` text NOT NULL,
  `postdate` date NOT NULL default '0000-00-00',
  `status` int(1) unsigned NOT NULL default '0',
  `ip` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`rid`)
) TYPE=MyISAM;

INSERT INTO `hsl_review` (`rid`,`company`,`domain`,`name`,`email`,`speed`,`reliability`,`support`,`price`,`review`,`postdate`,`status`,`ip`) VALUES ('1','TEST','http://www.','','','10','10','6','1','great service','2005-01-08','1','200.55.110.32');


DROP TABLE IF EXISTS `hsl_service`;
CREATE TABLE `hsl_service` (
  `sid` varchar(255) NOT NULL default '',
  `name` varchar(255) NOT NULL default '',
  UNIQUE KEY `sid` (`sid`)
) TYPE=MyISAM;

INSERT INTO `hsl_service` (`sid`,`name`) VALUES ('videostreaming','Video Streaming');
INSERT INTO `hsl_service` (`sid`,`name`) VALUES ('audiostreaming','Audio Streaming');
INSERT INTO `hsl_service` (`sid`,`name`) VALUES ('accountcontrolpanel','Control Panel');
INSERT INTO `hsl_service` (`sid`,`name`) VALUES ('shellaccess','Shell Access');
INSERT INTO `hsl_service` (`sid`,`name`) VALUES ('adultsitespermitted','Adult Sites Permitted');
INSERT INTO `hsl_service` (`sid`,`name`) VALUES ('php','PHP');
INSERT INTO `hsl_service` (`sid`,`name`) VALUES ('cgipermitted','CGI Permitted');
INSERT INTO `hsl_service` (`sid`,`name`) VALUES ('unlimitedftp','Unlimited FTP Access');
INSERT INTO `hsl_service` (`sid`,`name`) VALUES ('domainregistration','Domain Registration');
INSERT INTO `hsl_service` (`sid`,`name`) VALUES ('asp','Active Server Pages');
INSERT INTO `hsl_service` (`sid`,`name`) VALUES ('perl','Perl');
INSERT INTO `hsl_service` (`sid`,`name`) VALUES ('jsp','Java Server Pages');
INSERT INTO `hsl_service` (`sid`,`name`) VALUES ('telephonesupport','Telephone Support');
INSERT INTO `hsl_service` (`sid`,`name`) VALUES ('msfrontpage','MS FrontPage Support');
INSERT INTO `hsl_service` (`sid`,`name`) VALUES ('resellerplan','Reseller Plan(s) Available');
INSERT INTO `hsl_service` (`sid`,`name`) VALUES ('webstatistics','Web Usage Statistics');
INSERT INTO `hsl_service` (`sid`,`name`) VALUES ('secureserver','Secure Server Available');
INSERT INTO `hsl_service` (`sid`,`name`) VALUES ('ssi','Server Side Includes');
INSERT INTO `hsl_service` (`sid`,`name`) VALUES ('msql','MySQL');
INSERT INTO `hsl_service` (`sid`,`name`) VALUES ('mssql','Microsoft SQL');
INSERT INTO `hsl_service` (`sid`,`name`) VALUES ('coldfusion','ColdFusion');
INSERT INTO `hsl_service` (`sid`,`name`) VALUES ('test','Testing');
INSERT INTO `hsl_service` (`sid`,`name`) VALUES ('uniqueipaddress','Unique IP Address');


DROP TABLE IF EXISTS `hsl_special`;
CREATE TABLE `hsl_special` (
  `hid` int(11) unsigned NOT NULL default '0',
  `text` text NOT NULL,
  `expire` date NOT NULL default '0000-00-00',
  UNIQUE KEY `hid` (`hid`)
) TYPE=MyISAM;



