<?

function GetSearchSQL($vars, $type) # TYPE = 0 - NORMAL; TYPE = 1 - COUNT
{
	$where = array();

	$sql[0] = "SELECT p.*, h.name as company, h.company_url, IF(h.expired<NOW(),0,h.account_type) AS account_type1, SUM((r.speed+r.reliability+r.support+r.price)/40)/COUNT(*) AS rating FROM `hsl_plan` p LEFT JOIN `hsl_host` h ON p.hid=h.hid LEFT JOIN `hsl_review` r ON h.`name`=r.`company` WHERE p.status=1";
	$sql[1] = "SELECT COUNT(*) FROM `hsl_plan` p LEFT JOIN `hsl_host` h ON p.hid=h.hid WHERE p.status=1";

	$sql_addon[0] = " GROUP BY p.pid, r.company";
	$sql_addon[1] = "";

	if (isset($vars['name'])) {
		if (trim($vars['name']) != '')
		{
			array_push($where, " AND h.`name` LIKE '%".$vars['name']."%'");
		}
		unset ($vars['name']);
	}
	if (isset($vars['monthly_price'])) {
		array_push($where, str_replace("|", " AND p.`monthly_price`", $vars['monthly_price']));
		unset ($vars['monthly_price']);
	}
	if (isset($vars['webspace'])) {
		array_push($where, str_replace("|", " AND p.`webspace`", $vars['webspace']));
		unset ($vars['webspace']);
	}
	if (isset($vars['datatransfer'])) {
		array_push($where, str_replace("|", " AND p.`datatransfer`", $vars['datatransfer']));
		unset ($vars['datatransfer']);
	}
	if (isset($vars['os'])) {
		array_push($where, str_replace("|", " AND p.`os`", $vars['os']));
		unset ($vars['os']);
	}
	if (isset($vars['country'])) {
		if ($vars['country'] != '') {
			array_push($where, " AND h.`country`='".$vars['country']."'");
		}
		unset ($vars['country']);
	}
	if (isset($vars['category'])) {
		if ($vars['category'] != '')
		{
			array_push($where, " AND p.`category`='".$vars['category']."'");
		}
		unset ($vars['category']);
	}

	while (list($key, $value) = each($vars))
	{
		array_push($where, " AND p.`$key`='$value'");
	}

	if (join("", $where) == '') { return $sql[$type].$sql_addon[$type]; }
	return $sql[$type]." AND ".substr(trim(join(" ", $where)), 3).$sql_addon[$type];
}

function ParseRequest($url)
{
	$vars = array();
	$pairs = split("&", $url);
	while (list(,$pair)=each($pairs))
	{
		$tmp = split("=", $pair);
		if (count($tmp) > 2)
		{
			$vars[$tmp[0]] = join("=", array_splice($tmp, 1));
		}
		else
		{
			$vars[$tmp[0]] = $tmp[1];
		}
	}
	return $vars;
}

function CreateRequest($vars)
{
	$url = "";
	while( list($key,$value) = each($vars) )
	{
		$url .= "&$key=$value";
	}
	return substr($url, 1);
}

################## GENERATE SEARCH URI AND REDIRECT #################
if ($_SERVER['REQUEST_METHOD'] == 'POST')
{
	$uri = base64_encode(CreateRequest($_POST));
	java_redirect($config['base_url']."search/?uri=".$uri);
}

####################### OUTPUT SEARCH FORM ##########################
$t->assign('main_html', $request[0].'.html');

########################## SEARCH ITSELF ############################
$uri = split("\?", $_SERVER['REQUEST_URI']);
$vars = ParseRequest($uri[1]);
$t->assign('original_request', $uri[1]);

if (isset($vars['uri']))
{
	################ GENARAL TASKS #######################
	$t->assign('request', 'uri='.$vars['uri']);
	$uri = base64_decode(urldecode($vars['uri']));
	$search_vars = ParseRequest($uri);

	########## SETTING TOTAL RESULTS BY SEARCH ###########

	$total_results = mysql_result(_mysql_query(GetSearchSQL($search_vars, 1)), 0, 0);
	$t->assign('total_results', $total_results);

	############## CREATING LISTING BY PAGES #############
	if ($request[1] == '') { $request[1] = 1; }

	$pages = $total_results;
	if ((($pages/5) - intval($pages/5)) > 0) { $pages = intval($pages/5)+1; }
	else { $pages = intval($pages/5); }
	$pages_hash = array();
	if ($pages > 1)
	{
		for ($i = 1; $i <= $pages; $i++)
		{
			$page = array();
			$page['value'] = $i;
			if ($request[1] == $i)
			{
				$page['current'] = 1;
			}
			array_push($pages_hash, $page);
		}
		if ($request[1] == 1)
		{
			$t->assign('first_page', 1);
		}
		elseif ($request[1] == $pages)
		{
			$t->assign('last_page', 1);
		}
		$t->assign('prev_page', $request[1]-1);
		$t->assign('next_page', $request[1]+1);
		$t->assign('pages', $pages_hash);
	}

	############## SETTING ORDERING PARAMS ###############
	unset($vars['uri']);
	$params = array();
	while (list ($param,) = each($vars))
	{
		array_push($params, $param);
	}
	if (count($vars) == 0)
	{
		array_push($params, 'monthly_price', 'desc');
	}
	$t->assign($params[0], 1);
	$t->assign($params[1], 1);

	########### GENERATING SEARCH SQL FOR PLANS ##########
	$sql_search = GetSearchSQL($search_vars, 0);

	$sql_search .= " ORDER BY account_type1 DESC, `".$params[0]."` ".$params[1];
	$sql_search .= " LIMIT ".($request[1]*5-5).",5";

	$res_search = _mysql_query($sql_search);
	
	$num_current_result = mysql_num_rows($res_search);
	$t->assign('from', ($request[1]-1)*5+1);
	$t->assign('to', ($request[1]-1)*5+$num_current_result);

	$plans = array();
	while ($plan = mysql_fetch_array($res_search))
	{
		$plan['rating'] = round($plan['rating'] * 10);

		### creating LOGO
		if (!file_exists("logos/".$plan['hid']."_logo.gif")) { $plan['image'] = "default"; }
		else { $plan['image'] = $plan['hid']."_logo"; }
	
		### Data Transfer
		if ($plan['datatransfer'] != 999999999) { $plan['datatransfer'] = $plan['datatransfer'] / 1000; }
	
		array_push($plans, $plan);
	}

	$t->assign('plans', $plans);
	$t->assign('main_html', $request[0].'_result.html');
}

?>