<?php

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * Type:     function
 * Name:     math
 * Purpose:  handle math computations in template
 * -------------------------------------------------------------
 */
function smarty_function_math($params, &$smarty)
{
    // be sure equation parameter is present
    if (empty($params["equation"])) {
        $smarty->trigger_error("math: missing equation parameter");
        return;
    }

    $equation = $params["equation"];

    // make sure parenthesis are balanced
    if (substr_count($equation,"(") != substr_count($equation,")")) {
        $smarty->trigger_error("math: unbalanced parenthesis");
        return;
    }

    // match all vars in equation, make sure all are passed
    preg_match_all("![a-zA-Z][a-zA-Z0-9]*!",$equation, $match);
    $allowed_funcs = array('int','abs','ceil','cos','exp','floor','log','log10',
                           'max','min','pi','pow','rand','round','sin','sqrt','srand','tan');

    foreach($match[0] as $curr_var) {
        if (!in_array($curr_var,array_keys($params)) && !in_array($curr_var, $allowed_funcs)) {
            $smarty->trigger_error("math: parameter $curr_var not passed as argument");
            return;
        }
    }

    foreach($params as $key => $val) {
        if ($key != "equation" && $key != "format" && $key != "assign") {
            // make sure value is not empty
            if (strlen($val)==0) {
                $smarty->trigger_error("math: parameter $key is empty");
                return;
            }
            if (!is_numeric($val)) {
                $smarty->trigger_error("math: parameter $key: is not numeric");
                return;
            }
            $equation = preg_replace("/\b$key\b/",$val, $equation);
        }
    }

    eval("\$smarty_math_result = ".$equation.";");

    if (empty($params["format"])) {
        if (empty($params["assign"])) {
            echo $smarty_math_result;
        } else {
            $smarty->assign($params["assign"],$smarty_math_result);
        }
    } else {
        if (empty($params["assign"])){
            printf($params["format"],$smarty_math_result);
        } else {
            $smarty->assign($assign,sprintf($params["format"],$smarty_math_result));
        }
    }
}

/* vim: set expandtab: */

?>
