<?

/************************************************************************/
/* FlatNuke - Flat Text Based Content Management System                 */
/* ============================================                         */
/*                                                                      */
/* Copyright (c) 2003-2005 by Simone Vellei                             */
/* http://flatnuke.sourceforge.net                                      */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

/**
 * File delle funzioni di sistema
 *
 * Questo file contiene le procedure di sistema necessarie al funzionamento di FlatNuke.
 *
 * @package Funzioni_di_sistema
 * Prova {@tutorial Funzioni_di_sistema/docapi.pkg}
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 * @version 2.5.7
 * @copyright Copyright (c) 2003-2005
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License
 */


/**
 * Contiene funzioni condivise tra il forum e il core di FlatNuke
 */
include_once("shared.php");


/**
 * Incrementa il contatore delle visite di una news
 *
 * Incrementa di una unita' il contatore delle visite di una news.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 *
 * @param string $news Nome assoluto del file della news da elaborare
 */
function add_read($news){


	$news=getparam($news,PAR_NULL,SAN_FLAT);
	$lockfile="news/$news.xml";

	if(!file_exists($lockfile)) {
		OpenTable();
		print("<div align='center'><b>"._NORESULT."</b></div>");
		CloseTable();
		return;
	}

	$sem=lock($lockfile);
	$string=get_file($lockfile);
	$reads = get_xml_element("fn:reads",$string);
	$reads+=1;

	$string = ereg_replace("<fn:reads>.*</fn:reads>","<fn:reads>$reads</fn:reads>",$string);

	$fp=fopen($lockfile,"w");
	// accesso esclusivo alla risorsa
	fwrite($fp,"$string");
	fclose($fp);

	unlock($sem);
}


/**
 * Visualizza il dettaglio di una news
 *
 * Stampa a video il dettaglio di una news compreso di titolo, intestazione,
 * corpo e commenti.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 *
 * @param string $news Nome assoluto del file della news da visualizzare
 */
function read_news($news){
	global $theme;
	global $theme,$mesi,$giorni;
	global $fuso_orario;

	$news=getparam($news, PAR_NULL, SAN_FLAT);
	$myforum=getparam("myforum", PAR_COOKIE, SAN_FLAT);

	/*if(isset($_COOKIE['myforum']))
		$myforum=$_COOKIE['myforum'];
	else
		$myforum="";*/

	// check if the news really exists
	if(!file_exists("news/$news.xml")) {
		OpenTable();
		print("<div align='center'><b>"._NORESULT."</b></div>");
		CloseTable();
		return;
	}

	add_read($news);

	$fd=get_file("news/$news.xml");
	$title=get_xml_element("fn:title",$fd);
	$avatar=get_xml_element("fn:avatar",$fd);
	$header=get_xml_element("fn:header",$fd);
	$body=get_xml_element("fn:body",$fd);
	$comments=get_xml_element("fn:comments",$fd);
	$comment=get_xml_array("fn:comment",$comments);

	OpenTableTitle("<img src=\"themes/$theme/images/read.png\" alt=\"Read\">&nbsp;".$title);

	echo "<a href=\"index.php?mod=none_Search&amp;where=news&amp;find=$avatar\"><img src=\"images/news/$avatar\" align=\"right\" border=\"0\" alt=\"$avatar\"></a>";
	print stripslashes($header)."<br><br>".stripslashes($body);

	print "<br><br><div align='center'><hr size='1'>";
	echo _POSTATO.$giorni[date("w",$news+(3600*$fuso_orario))].date(" d ",$news+(3600*$fuso_orario));
	$tmp=date("m",$news+(3600*$fuso_orario));
	if ($tmp<10)
		$tmp=str_replace("0","",$tmp);
	print $mesi[$tmp-1];
	echo date(" Y - ",$news+(3600*$fuso_orario)).date("H:",$news+(3600*$fuso_orario)).date("i",$news+(3600*$fuso_orario))."</div><br>";

	OpenTable();
	echo "<b>"._COMMENTI."</b> | <a href=\"index.php?mod=comment&amp;id=$news\">"._ADDCOMM."</a> | <a href=\"print.php?news=$news\" target=\"new\">"._STAMPA."</a>";
	CloseTable();

	for($j=0;$j<count($comment);$j++){
		print "<br>";
		OpenTable();
		$user=get_xml_element("fn:by",$comment[$j]);
		// inserisco l'avatar nei commenti
		if(file_exists("forum/users/$user.php")){
			$fd=file("forum/users/$user.php");
			$img=str_replace("\n","",str_replace("#","",$fd[7]));
			if($img!=""){
				if(!stristr($img,"http://"))
					echo "<img src=\"forum/".$img."\" alt=\"avatar\" border='0' align='left'  hspace=\"10\" vspace=\"10\" style=\"max-width:100px\">";
				else
					echo "<img src=\"".$img."\" alt=\"avatar\" border='0' align='left'  hspace=\"10\" vspace=\"10\" style=\"max-width:100px\">";
			}
		}
		// autore del commento
		print "<b>"._DA."</b> $user  ";
		// data di inserzione del commento
		$date_comment = get_xml_element("fn:date",$comment[$j]);
		if(is_numeric($date_comment)){
			print "<b>"._DATA.":</b> ";
			echo $giorni[date("w",$date_comment+(3600*$fuso_orario))].date(" d ",$date_comment+(3600*$fuso_orario));
			$tmp_c = date("m",$date_comment+(3600*$fuso_orario));
			if ($tmp_c<10)
				$tmp_c = str_replace("0","",$tmp_c);
			print $mesi[$tmp_c-1];
			$date_comment = date(" Y - ",$date_comment+(3600*$fuso_orario)).date("H:",$date_comment+(3600*$fuso_orario)).date("i",$date_comment+(3600*$fuso_orario));
		}
		else $date_comment = "/";
		print "$date_comment<br><br>";
		// contenuto del commento
		print stripslashes(get_xml_element("fn:post",$comment[$j]));
		CloseTable();
	}
	echo "<br><br><hr noshade='noshade' size='1'>";

	// ricerca della notizia precedente e di quella successiva
	$array_news = array();
	$handle = opendir("news");
	while ($file = readdir($handle)) {
		if (!( $file=="." OR $file==".." )) {
			array_push($array_news, $file);
		}
	}
	closedir($handle);
	if(count($array_news)>0)
		sort($array_news);
	while ($cur_news = current($array_news)) {
		if ($cur_news == "$news.xml") {
			$current = current($array_news);
			$key = key($array_news);
			if($key-1 < 0)
				$prev = _NOPREVNEWS;
			else $prev = "<a href='index.php?mod=read&amp;id=".str_replace(".xml","",$array_news[$key-1])."'>&lt;&lt; "._PREVNEWS."</a>";
			if($key+1 > count($array_news)-1)
				$next = _NONEXTNEWS;
			else $next = "<a href='index.php?mod=read&amp;id=".str_replace(".xml","",$array_news[$key+1])."'>"._NEXTNEWS." &gt;&gt;</a>";
			echo "<div align='center'>$prev | $next</div>";
		}
		next($array_news);
	}

	// elenco notizie con stesso argomento di quella visualizzata
	echo "<hr noshade='noshade' size='1'><p align='center'><b>"._RELATEDNEWS."</b></p>";
	argument_search("news", $avatar);

	CloseTableTitle();
}


/**
 * Ricerca una determinata stringa all'interno delle news o dei topics del forum
 *
 * Esegue una ricerca di una stringa all'interno dei files presenti nella directory
 * delle news o dei topics del forum, stampandone un elenco
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @since 2.5.7
 *
 * @param string $where Sezione di ricerca, 'news' oppure 'forum'
 * @param string $find Stringa da ricercare
 */
function argument_search($where, $find) {
	global $theme;

	$where=getparam($where,PAR_NULL, SAN_FLAT);
	$find=getparam($find,PAR_NULL, SAN_FLAT);

	if($where=="")
		$find="";
	$haveresult = 0;
	if((trim($find)!="") and file_exists($where)) {
		$addr=getparam("REMOTE_ADDR",PAR_SERVER,SAN_FLAT);
		//if(isset($_COOKIE['myforum'])) $myforum = $_COOKIE['myforum'];
			//else $myforum = "";
		$myforum=getparam("myforum",PAR_COOKIE,SAN_FLAT);
		//fnlog("Search", $addr."||".$myforum."||Search done in $where about \"$find\"."); // too verbose, produces too big logs
		#$modlist = "";
		$modlist = array();
		$handle = opendir($where);
		while ($file = readdir($handle)) {
			if (!( $file=="." OR $file==".." )) {
				#$modlist .= "$file ";
				array_push($modlist, $file);
			}
		}
		closedir($handle);
		#$modlist = explode(" ", $modlist);
		if(count($modlist)>0)
			rsort($modlist);
		#for ($i=0; $i < sizeof($modlist)-1; $i++) {
		for ($i=0; $i < count($modlist); $i++) {
			$string = get_file($where.'/'.$modlist[$i]);
			$found = 0;
			if(stristr($string, $find)) {
				$found = 1;
				$haveresult = 1;
			}
			if($found==1) {
				if($where=="news") {
					$title = get_xml_element("fn:title", $string);
					if($title=="")
						$title = _LEGGITUTTO;
					$reads = get_xml_element("fn:reads", $string);
					$id = str_replace(".xml", "", $modlist[$i]);
					echo "<img src='themes/$theme/images/read.png' alt='Read'>&nbsp;<a href='index.php?mod=read&amp;id=$id'>$title</a> ";
					echo "(".date("d/m/Y - H:i", $id).") "._LETTO."$reads "._VOLTE."<br>";
				}
				if($where=="forum/topics") {
					$title = get_xml_element("ff:topic", $string);
					if($title=="")
						$title = _LEGGITUTTO;
					$id = str_replace(".xml", "", $modlist[$i]);
					echo "<img src='themes/$theme/images/read.png' alt='Read'>&nbsp;<a href='forum/index.php?op=topic&quale=$id'>$title</a> ";
					echo "(".date("d/m/Y - H:i", $id).")<br>";
				}
			}
		}
		if($haveresult==0) {
			echo _NORESULT."<br><a href=\"javascript:history.back();\">&lt;&lt; "._INDIETRO."</a>";
		}
	}
	else {
		?><div align="center">
		<form action="index.php" method="GET">
		<input type="hidden" name="mod" value="none_Search">
		<?=_CERCASTR?><br><br>
		<input type="radio" name="where" value="news">News
		<input type="radio" name="where" value="forum/topics">Forum<br>
		<input type="text" name="find" size="14"><br><br>
		<input type="submit" value="<?=_CERCA?>">
		</form>
		</div><?
	}
}


/**
 * Conta i commenti associati ad una news
 *
 * Calcola il numero di commenti inseriti per una news e lo restituisce.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 *
 * @param string $news Nome assoluto del file della news da elaborare
 * @return number Numero dei commenti
 */
function count_comment($news){

	$news=getparam($news,PAR_NULL,SAN_FLAT);
	$com=0;
	$fd=file("news/$news.xml");
	for($j=1; $j<count($fd);$j++){
		if(stristr($fd[$j],"<fn:comment>"))
			$com+=1;
	}
	return $com;
}


/**
 * Permette di scaricare un file dalla sezione "Download"
 *
 * Permette di scaricare un file dalle sezione "Download" gestendone
 * il conteggio dei downloads.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 *
 * @param string $file Nome assoluto del file da scaricare
 */
function go_download($mysect, $file){

	$mysect=getparam($mysect,PAR_NULL,SAN_FLAT);
	$file=getparam($file,PAR_NULL,SAN_FLAT);
	// evita di accedere a directory esterne
	if(stristr($file,".."))
		die(_NONPUOI);
	if(!file_exists("sections/$mysect/$file")) {
		OpenTable();
		print("<div align='center'><b>"._NORESULT."</b></div>");
		CloseTable();
		return;
	}

	// se il file non esiste lo crea
	if(!file_exists("misc/download.xml")){
		$fp=fopen("misc/download.xml","w");
  		fwrite($fp,"<?xml version='1.0'?>\n
		<!DOCTYPE fd:news SYSTEM \"http://flatnuke.sourceforge.net/dtd/download.dtd\">\n
		<fd:download xmlns:fn=\"http://flatnuke.sourceforge.net/download\">\n
		</fd:download>");
		fclose($fp);
	}

	$str=get_file("misc/download.xml");
	$strtmp=$str;

	if(stristr($strtmp,$file)){
		$count=ereg_replace(".*$file\">","",$strtmp);
		$count=ereg_replace("</fd:entry>.*","",$count);
		$newcount=$count+1;
		$str=ereg_replace("$file\">$count","$file\">$newcount",$str);
	}
	else {
		$str=str_replace("</fd:download>","\t<fd:entry file=\"$file\">1</fd:entry></fd:download>",$str);
	}

	$fp=fopen("misc/download.xml","w");
  	fwrite($fp,$str);
	fclose($fp);

	//incrementa download
    Header("Location: sections/$mysect/$file");
}


/**
 * Visualizza tutte le classi di download
 *
 * Visualizza tutte le classi di download filtrate secondo il parametro $filter
 * presenti nella directory <i>/sections/Download/</i>, stampandone l'eventuale
 * descrizione.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 *
 * @param string $filter Filtro per le classi di download
 */
function view_download($mysect, $filter){

	$mysect=getparam($mysect,PAR_NULL,SAN_FLAT);
	$filter=getparam($filter,PAR_NULL,SAN_FLAT);

	$wdown="sections/$mysect";
	#$modlist="";
	$modlist = array();

	OpenTableTitle("Download $filter");
	$handle = opendir("sections/$mysect");
	while ($file = readdir($handle)) {
		if (!($file == "." or $file == "..") and (!ereg("^\.", $file) and($file != "CVS") and is_dir("sections/$mysect/$file"))) {
			if(($filter=="") or stristr($file,$filter))
				#$modlist.= "$file ";
				array_push($modlist, $file);
		}
	}

	closedir($handle);
	#$modlist = explode(" ", $modlist);
	if(count($modlist)>0)
		sort($modlist);

	if(file_exists("misc/download.xml"))
		$xmldownload=get_file("misc/download.xml");
	else
		$xmldownload="";

	echo "<br><ul>";
	#for ($i=1; $i < sizeof($modlist); $i++) {
	for ($i=0; $i < count($modlist); $i++) {
		echo "<li><b>".$modlist[$i]."</b>";
		$descr="sections/$mysect/".$modlist[$i]."/description.php";
		if(file_exists($descr)){
			echo " - ";
			include($descr);
		}
		#$modlist_down="";
		$modlist_down = array();
		$handle_down = opendir("sections/$mysect/".$modlist[$i]);
		while ($file = readdir($handle_down)) {
			if (!($file == "." or $file == "..") and (!ereg("^\.", $file) and($file != "CVS") and ($file != "description.php"))) {
				#$modlist_down.= "$file ";
				array_push($modlist_down, $file);
			}
		}
		closedir($handle_down);
		#$modlist_down = explode(" ", $modlist_down);
		if(count($modlist_down)>0)
			sort($modlist_down);
		#for ($j=1; $j < sizeof($modlist_down); $j++) {
		for ($j=0; $j < count($modlist_down); $j++) {
			echo "<br>- <a href=\"index.php?mod=$mysect&amp;file=".$modlist[$i]."/".$modlist_down[$j]."&amp;mode=go\">".
			$modlist_down[$j]."</a> ";
			$fsize=filesize("$wdown/".$modlist[$i]."/".$modlist_down[$j]);
			$suff="bytes";
			if($fsize>1024){
				$fsize=round($fsize/1024,2);
				$suff="Kb";
			}
			if($fsize>1024){
				$fsize=round($fsize/1024,2);
				$suff="Mb";
			}
			$filetodown=$modlist[$i]."/".$modlist_down[$j];
			if(stristr($xmldownload,$filetodown)){
				$strtmp=$xmldownload;
				$count=ereg_replace(".*$filetodown\">","",$strtmp);
				$count=ereg_replace("</fd:entry>.*","",$count);
			}
			else {
				$count=0;
			}
			echo " ($fsize $suff | $count Download)";
		}
		echo "<br><br>";
	}
	echo "</ul>";
	CloseTableTitle();
}


/**
 * Visualizza una sezione
 *
 * Visualizza il contenuto della sezione passata come parametro.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 *
 * @param string $section Nome assoluto della sezione da visualizzare
 */
function view_section($section){
	global $theme;

	$section=getparam($section,PAR_NULL,SAN_FLAT);
	$file=getparam("file", PAR_GET, SAN_FLAT);
	$mode=getparam("mode", PAR_GET, SAN_FLAT);

	/*if(isset($_GET['file']))
		$file=$_GET['file'];
	else
		$file="";*/

	#previene il fatto di poter andare a vedere su ogni dir
	if(stristr($section,".."))
		die(_NONPUOI);
	if(stristr($file,".."))
		die(_NONPUOI);

	// delete null byte, it could disclose subdirectories
	$section=str_replace(chr(00),"",$section);

	// check if section really exists
	if(!file_exists("sections/$section")) {
		OpenTable();
		print("<div align='center'><b>"._SECTNOTEXIST."</b></div>");
		CloseTable();
		return;
	}

	// CONTROLLO PERMESSI -->
	// se ho una protezione a livello
	// controllo altrimenti no!
	$sectlevel=getsectlevel($section);
	if($sectlevel!=-1){
		// se non sono loggato  inutile che controllo
		// se ho il livello giusto!!!
		// sembra strano ma lo faccio per performances
		$myforum=getparam("myforum",PAR_COOKIE, SAN_FLAT);
		if($myforum){
			if(getlevel($myforum,"home") < $sectlevel){
				OpenTable();
				print("<div align='center'><b>"._NOLEVELSECT."</b></div>");
				CloseTable();
				return;
			}
		}
		else {
			OpenTable();
			print("<div align='center'><b>"._NOLEVELSECT."</b></div>");
			CloseTable();
			return;
		}
	}
	// <-- FINE CONTROLLO PERMESSI

	// CODICE RELATIVO ALLA VISIONE DELLA SEZIONE DOWNLOAD -->
	if(eregi('^[0-9_ || none_]{0,5}download',$section) and 
		!file_exists('sections/'.$section.'/section.php')) {
		/*if(isset($_GET['mode']))
			$mode=$_GET['mode'];
		else
			$mode="";*/
		if($mode=="go"){
			go_download($section, $file);
		}
		else
			view_download($section, $file);
		return;
	}
	// <-- FINE DOWNLOAD

	if($file!="")
		$sect=$section."/$file";
	else
		$sect=$section;

	$tit="";
	# procedura per barra di navigazione
	$albero=explode("/",$sect);
	for($i=0;$i<sizeof($albero);$i++){
		$mypath="";
		for($j=0;$j<=$i;$j++){
			if($i>0 and ($j!=$i)){
				$mypath.=$albero[$j]."/";
			}
			else {
				$mypath.=$albero[$j];
			}
		}
		$tmp=str_replace("none_","",$albero[$i]);
		$tmp=eregi_replace("^[0-9][0-9]_","",$tmp);
		if($i!=(sizeof($albero)-1)){
			$tit.= "<a href=\"index.php?mod=$mypath\">".str_replace("_"," ",$tmp)."</a>/";
		}
		else{
			$tit.= str_replace("_"," ",$tmp);
			$tit=ereg_replace("\.[a-z0-9]{1,4}$","",$tit); // elimina l'estensione dal nome del file
		}
	}

	OpenTableTitle("<img src=\"themes/$theme/images/section.png\" alt=\"Section\">&nbsp;".stripslashes($tit));

	if($file==""){
		// una sezione pu anche essere vuota!
		if(file_exists('sections/'.$section.'/section.php')){
			include('sections/'.$section.'/section.php');
			echo "<br>";
		}
		/* Gestisce la galleria con gallery */
		if(file_exists("sections/$section/gallery")) {
			echo "<br>";
			include("gallery/gallery.php");
			$pag = getparam("pag",PAR_GET,SAN_FLAT);
			if($pag != "") {
				$galleryparms = "&amp;pag=".$pag;
			} else {
				$galleryparms = "";
			}
		} else $galleryparms = "";
		// stampa
		echo "<div align=\"right\"><a href=\"print.php?mod=$section$galleryparms\" target=\"new\"><img src=\"themes/$theme/images/print.png\" border=\"0\" alt=\"print\"></a></div>";
	}

	else{
		include(stripslashes('sections/'.$section.'/'.$file));
		echo "<div align=\"right\"><a href=\"print.php?mod=$section&amp;file=$file\"><img src=\"themes/$theme/images/print.png\" border=\"0\" alt=\"print\"></a></div>";
	}

	#$modlist="";
	$modlist = array();
	$handle=opendir('sections/'.$section);
	while ($file = readdir($handle)) {
		if(!stristr($file,"none_")){
			//controlla che sia una directory
			if ( (!ereg("[.]",$file)) and is_dir("sections/".$section."/".$file)) {
				#$modlist .= "$file ";
				array_push($modlist, $file);
			}
		}
	}
	closedir($handle);
	#$modlist = explode(" ", $modlist);
	if(count($modlist)>0) {
		sort($modlist);

	#if(sizeof($modlist)>1){
		echo "<br><br>";
		OpenTable();
		#for ($i=1; $i < sizeof($modlist); $i++) {
		for ($i=0; $i < sizeof($modlist); $i++) {
			if(stristr($modlist[$i],"_")){
				$tmp=eregi_replace("^[0-9][0-9]_","",$modlist[$i]);
				$tmp=str_replace("_"," ",$tmp);
			}
			# per compatibilit con le vecchie versioni...
			else
				$tmp=$modlist[$i];
			echo "<img src=\"themes/$theme/images/subsection.png\" alt=\"Subsection\">&nbsp;<a href=\"index.php?mod=$section/$modlist[$i]\">$tmp</a><br>";
		}
		CloseTable();
	}

	$file = getparam("file",PAR_GET,SAN_FLAT);
	$file = stripslashes($file);
	/*if(isset($_GET['file']))
		$file = $_GET['file'];
	else
		$file = "";*/

	$myforum=getparam("myforum",PAR_COOKIE, SAN_FLAT);

	if($file==""){
		// controllo se sono un amministratore
		if(is_writable("sections/".$section."/section.php") and (getlevel($myforum,"home")==10) and versecid($myforum))
			print "<hr><form action=\"index.php\" method=\"GET\">
		<input type=\"hidden\" name=\"mod\" value=\"modcont\">
		<input type=\"hidden\" name=\"from\" value=\"".getparam("REQUEST_URI", PAR_SERVER, SAN_FLAT)."\">
		<input type=\"hidden\" name=\"file\" value=\"sections/".$section."/section.php\">
		<input type=\"submit\" value=\""._MODIFICA."\"></form>";
	}
	else{
		if(is_writable("sections/".$section."/".$file) and (getlevel($myforum,"home")==10) and versecid($myforum))
			print "<hr><form action=\"index.php\" method=\"GET\">
		<input type=\"hidden\" name=\"mod\" value=\"modcont\">
		<input type=\"hidden\" name=\"from\" value=\"".getparam("REQUEST_URI",PAR_SERVER,SAN_FLAT)."\">
		<input type=\"hidden\" name=\"file\" value=\"sections/$section/".$file."\">
		<input type=\"submit\" value=\""._MODIFICA."\"></form>";
	}

	if((getlevel($myforum,"home")==10) and versecid($myforum)){
		$level=getsectlevel($section);
		print("<form action='verify.php' method='post'>");
		print("<input type='hidden' name='mod' value='modlevel'>");
		print("<input type='hidden' name='section' value='".$section."'>");
		print("<b>"._LEVEL."</b>: ");
		if(!is_writeable("sections/$section")) {
			print("<select name=\"level\" disabled></select> "._FIG_ALERTNOTWR);
		} else {
			print("<select name=\"level\">");
			print("<option value=\"-1\">---</option>");
			for($i=0;$i<11;$i++){
				if($level==$i)
					print("<option value=\"$i\" selected >$i</option>");
				else
					print("<option value=\"$i\" >$i</option>");
			}
			print("</select>");
			print("&nbsp;<input type='submit' value='OK'>");
			print("</form>");
		}
	}

	CloseTableTitle();
}


/**
 * Crea il menu principale
 *
 * Crea un blocco contenente il menu principale elencando tutte le directories
 * che in <i>/sections/</i> non iniziano con "none_":
 *  - prima vengono, in ordine alfabetico, le directories che iniziano
 *    con un carattere (es: Prova);
 *  - di seguito, in ordine crescente, quelle che iniziano con una coppia
 *    di numeri (es: 03_Prova).
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 */
function create_menu(){
	global $theme;
	#$modlist ="";
	$modlist = array();

	$handle=opendir('sections');
	while ($file = readdir($handle)) {
		if (!( $file=="." or $file==".." ) and (!ereg("^\.",$file) and ($file!="CVS") )) {
			#$modlist .= "$file ";
			array_push($modlist, $file);
		}
	}
	closedir($handle);
	#$modlist = explode(" ", $modlist);
	if(count($modlist)>0)
		sort($modlist);

	$title="Menu";

	// backward theme compatibility
	if(function_exists("OpenBlock")){
		OpenBlock("themes/$theme/images/menu.png",$title);
	}
	else {
		OpenTableTitle("<img src=\"themes/$theme/images/menu.png\" alt=\"Menu\">&nbsp;Menu");
	}

	echo "&#187;&nbsp;<a href=\"index.php\">Home</a><br>";
	#for ($item_num=1; $item_num < sizeof($modlist); $item_num++) {
	for ($item_num=0; $item_num < count($modlist); $item_num++) {
		if(!stristr($modlist[$item_num],"none_")){
			if(stristr($modlist[$item_num],"_")){
				$tmp=eregi_replace("^[0-9][0-9]_","",$modlist[$item_num]);
				$tmp=str_replace("_"," ",$tmp);
			}
			else
				$tmp=$modlist[$item_num];
		echo "&#187;&nbsp;<a href=\"index.php?mod=$modlist[$item_num]\">$tmp</a><br>";
		}
	}

	// backward theme compatibility
	if(function_exists("CloseBlock"))
		CloseBlock();
	else
		CloseTableTitle();
	echo "<br>";
}


/**
 * Visualizza i blocchi laterali
 *
 * Visualizza il contenuto dei blocchi laterali presenti nelle directories
 * <i>/blocks/dx/</i> oppure <i>/blocks/sx/</i> a seconda del parametro passato;
 * non vengono stampati i blocchi che iniziano per "none_".
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 *
 * @param string $edge Lato dei blocchi da stampare
 */
function create_blocks($edge){
	global $theme;
	$edge=getparam($edge,PAR_NULL,SAN_FLAT);
	#$modlist ="";
	$modlist = array();

	$handle=opendir('blocks/'.$edge);
	while ($file = readdir($handle)) {
		if (!is_dir("blocks/$edge/$file") and (!ereg("^\.",$file)) and !stristr($file,"none_")) {
			#$modlist .= "$file ";
			array_push($modlist, $file);
		}
	}
	closedir($handle);

	#$modlist = explode(" ", $modlist);
	if(count($modlist)>0)
		sort($modlist);
	#for ($item_num=1; $item_num < sizeof($modlist); $item_num++) {
	for ($item_num=0; $item_num < count($modlist); $item_num++) {
		$tmp=eregi_replace("^[0-9][0-9]_","",$modlist[$item_num]);
		$title=str_replace("_"," ",str_replace(".php","",$tmp));
		// backward theme compatibility
		if(function_exists("OpenBlock")){
			OpenBlock("themes/$theme/images/block.png",$title);
		}
		else {
			OpenTableTitle("<img src=\"themes/$theme/images/menu.png\" alt=\"$title\">&nbsp;$title");
		}
		include ("blocks/$edge/$modlist[$item_num]");
		if(function_exists("CloseBlock"))
			CloseBlock();
		else
			CloseTableTitle();
		echo "<br>";
	}
}


/**
 * Visualizza in homepage il motd e le news
 *
 * Visualizza in homepage il file <i>/misc/motd.php</i> contenente il messaggio di
 * benvenuto, ed un numero di news (a partire dalla piu' recente) secondo quanto
 * indicato in fase di configurazione.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 */
function create_news(){
	global $newspp,$theme;
	#$modlist="";
	$modlist = array();

	OpenTable();
	echo "<img src=\"themes/$theme/images/motd.png\" align=\"left\" hspace=\"10\" vspace=\"10\" alt=\"Motd\">";
	include ("misc/motd.php");
	CloseTable();

	$handle=opendir('news');
	while ($file = readdir($handle)) {
		if (!( $file=="." or $file==".." ) and (!ereg("^\.",$file)and ($file!="CVS"))) {
			#$modlist .= "$file ";
			array_push($modlist, $file);
		}
	}
	closedir($handle);
	#$modlist = explode(" ", $modlist);
	if(count($modlist)>0)
		rsort($modlist);

	#for ($i=0; $i < sizeof($modlist)-1; $i++) {
	for ($i=0; $i < count($modlist); $i++) {
		if ($i>=$newspp)
			break;
		$string=get_file("news/$modlist[$i]");
		print "<br>";
		$title=ereg_replace(".*<fn:title>","",$string);
		$title=ereg_replace("</fn:title>.*","",$title);
		$header=ereg_replace(".*<fn:header>","",$string);
		$header=ereg_replace("</fn:header>.*","",$header);
		$avatar=ereg_replace(".*<fn:avatar>","",$string);
		$avatar=ereg_replace("</fn:avatar>.*","",$avatar);
		$ntitle="<img src=\"themes/$theme/images/news.png\" alt=\"News\">&nbsp;$title";
		//grendizer: prima l'avatar, poi l'header
		OpenTableTitle($ntitle);
		echo "<a href=\"index.php?mod=none_Search&amp;where=news&amp;find=$avatar\"><img src=\"images/news/$avatar\" border=\"0\" alt=\"$avatar\" align=\"right\"></a><br>";
		echo stripslashes($header);
		CloseTableTitle2(str_replace(".xml","",$modlist[$i]));
	}
}


/**
 * Visualizza una textarea per inserire una news
 *
 * Permette di inserire direttamente online una nuova notizia,
 * tramite una comoda textarea.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 */
function insert_news(){
	OpenTableTitle(_ADDNEWS);
	echo "<form action=\"verify.php\" method=\"POST\" name=\"insnews\">
	<input type=\"hidden\" name=\"mod\" value=\"news\">
	<b>"._TITNOTIZIA."</b><br>
	<input type=\"text\" name=\"title\"><br><br>
	<b>"._ARGOMENTO."</b><br>
	<img name=\"avatar\" src=\"images/nonews.png\" border=\"0\" alt=\"Argomento\">
	<br>
	<select name=\"icon\" onChange='document.insnews.avatar.src=\"images/news/\"+this.options[this.selectedIndex].value'>";

	#$modlist = "";
	$modlist = array();
	$handle=opendir('images/news');
	while ($file = readdir($handle)) {
		if (!( $file=="." or $file==".." ) and (!ereg("^\.",$file)and ($file!="CVS")) ) {
			#$modlist .= "$file ";
			array_push($modlist, $file);
		}
	}
	closedir($handle);
	#$modlist = explode(" ", $modlist);
	if(count($modlist)>0)
		sort($modlist);
	#for ($i=1; $i < sizeof($modlist); $i++) {
	for ($i=0; $i < count($modlist); $i++) {
		echo "<option value=\"$modlist[$i]\">".	str_replace("_"," ", ereg_replace("\..*","",$modlist[$i]))."</option>\n";
	}

	echo "</select><br><br>";
	// bbcodes panel
	bbcodes_js();
	bbcodes_panel("head", "home", "formatting"); echo "<br>";
	bbcodes_panel("head", "home", "emoticons"); echo "<br>";
	echo "<b>"._INTMESSAGGIO."</b><br>";
	echo "<textarea cols=\"50\" rows=\"7\" name=\"head\"></textarea><br><br>";
	// bbcodes panel
	bbcodes_panel("body", "home", "formatting"); echo "<br>";
	bbcodes_panel("body", "home", "emoticons"); echo "<br>";
	echo "<b>"._CORPOMESSAGGIO."</b><br>";
	echo "<textarea cols=\"50\" rows=\"10\" name=\"body\"></textarea><br><br>
	<input type=\"submit\" value=\""._INSNOTIZIA."\">
	</form>";
	echo "
	<script type=\"text/javascript\">
		function preview(){
			document.prev.title.value=document.insnews.title.value;
			document.prev.icon.value=document.insnews.icon.value;
			document.prev.head.value=document.insnews.head.value;
			document.prev.body.value=document.insnews.body.value;
		}
	</script>";
	echo "<form name=\"prev\" action=\"verify.php\"  method=\"POST\">
	<input type=\"hidden\" name=\"mod\" value=\"prev\">
	<input type=\"hidden\" name=\"title\">
	<input type=\"hidden\" name=\"icon\">
	<input type=\"hidden\" name=\"head\">
	<input type=\"hidden\" name=\"body\">
	<input type=\"submit\" value=\""._ANTEPRIMA."\" onMouseOver='preview();'>
	</form>";
	CloseTableTitle();
}


/**
 * Visualizza una textarea per commentare una news
 *
 * Permette di inserire un commento alla notizia passata come parametro,
 * tramite una comoda textarea.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 *
 * @param string $news Nome assoluto del file della news da modificare
 */
function insert_comment($news){
	global $sitename,$guestcomment;

	$news=getparam($news,PAR_NULL,SAN_FLAT);
	$myforum=getparam("myforum",PAR_COOKIE,SAN_FLAT);

	/*if(isset($_COOKIE['myforum']))
		$myforum=$_COOKIE['myforum'];
	else
		$myforum="";*/

	#$modlist="";
	$modlist = array();
	// cerca se la news passata esiste veramente
	$handle = opendir('news');
	while ($file = readdir($handle)) {
		if (!($file == "." or $file == "..")) {
			#$modlist.= "$file ";
			array_push($modlist, $file);
		}
	}
	closedir($handle);
	// se non c' muore con dolore!
	#if(!strstr($modlist,$news)) {
	if(!in_array($news.".xml", $modlist)) {
		OpenTable();
		print("<div align='center'><b>"._NORESULT."</b></div>");
		CloseTable();
		return;
		//die(_NONPUOI);
	}

	//  se si tenta di fare il furbo passando come
	// argomento guestcomment=1 non lo permette!
	$req=getparam("REQUEST_URI", PAR_SERVER, SAN_FLAT);
	if(strstr($req,"guestcomment="))
		$guestcomment=0;

	OpenTableTitle(_ADDCOMM);

	if(($myforum!="") or ($guestcomment==1)){
		/*if($myforum=="")
			$comfrom=_SCON;
		elseif(versecid($myforum))
			$comfrom=$myforum;
		else {
			CloseTableTitle();
		return;
		}*/
		echo "<form action=\"verify.php\" method=\"POST\">
		<input type=\"hidden\" name=\"mod\" value=\"comment\">
		<input type=\"hidden\" name=\"id\" value=\"$news\">";
		//<input type=\"hidden\" name=\"name\" value=\"$comfrom\"><br>";
		// bbcodes panel
		bbcodes_js();
		bbcodes_panel("body", "home", "formatting"); echo "<br>";
		bbcodes_panel("body", "home", "emoticons"); echo "<br>";
		echo "<textarea cols=\"50\" rows=\"7\" name=\"body\"></textarea><br><br>
		<input type=\"submit\" value=\""._FINVIA."\">
		</form><br>";
		read_news($news);
	}
	else{
		print _DEVIREG." <b>".$sitename."</b> "._DEVIREG2;
	}
	CloseTableTitle();
}


/**
 * Visualizza una textarea per la modifica di un file
 *
 * Permette di modificare direttamente online il file passato come parametro,
 * tramite una comoda textarea che ne visualizza il contenuto.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 *
 * @param string $filename Nome del file da modificare
 */
function edit_content($filename){

	$filename=getparam($filename,PAR_NULL,SAN_FLAT);
	$from=getparam("from",PAR_GET,SAN_FLAT);
	$from=stripslashes($from);

	if(stristr($filename,"..") or !file_exists($filename)) {
		OpenTable();
		print("<div align='center'><b>"._NORESULT."</b></div>");
		CloseTable();
		return;
		//die(_NONPUOI);
	}

	/*$from=$_GET['from'];
	if(isset($_GET['from']))
		$from=$_GET['from'];
	else
		$from="";*/

	OpenTableTitle(_MODIFICA." ".$filename);
	echo "<form action=\"verify.php\" method=\"POST\">
	<input type=\"hidden\" name=\"mod\" value=\"modcont\">
	<input type=\"hidden\" name=\"from\" value=\"".$from."\">
	<textarea cols=\"80\" rows=\"30\" name=\"body\">";
	/*$fd=file($filename);
	$i=0;
	while($fd[$i]!=""){
		echo $fd[$i++];
	}*/
	echo htmlspecialchars(file_get_contents($filename));
	echo "</textarea><br><br>
	<input type=\"hidden\" name=\"file\" value=\"".$filename."\">
	<input type=\"submit\" value=\""._MODIFICA."\" >
	</form>";
	CloseTableTitle();
}


/**
 * Effettua il parsing di un feed RSS esterno
 *
 * Legge il file di un feed RSS esterno al sito e ne genera una stampa
 * leggibile e ordinata con le notizie segnalate, completa di link
 * per raggiungerle sul sito di origine.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 *
 * @param string $url Indirizzo del feed RSS
 * @return null|string Nulla se non trova il file, oppure il contenuto del feed RSS
 */
function parse_RSS($url){

	$url=getparam($url,PAR_NULL,SAN_FLAT);

	if ($url != "") {
		if (!ereg("http://",$url)) {
			$url = "http://$url";
		}
		$rdf = parse_url($url);
		$fp = fsockopen($rdf['host'], 80, $errno, $errstr, 15);
		if (!$fp) {
			print(_NORSS);
			return;
		}
		if ($fp) {
			@fputs($fp, "GET " . $rdf['path'] . "?" . $rdf['query'] . " HTTP/1.0\r\n");
			@fputs($fp, "HOST: " . $rdf['host'] . "\r\n\r\n");
			$string = "";
			while(!feof($fp)) {
				$pagetext = fgets($fp,228);
				$string .= chop($pagetext);
			}
			fputs($fp,"Connection: close\r\n\r\n");
			fclose($fp);
			$items = explode("</item>",$string);

			$content = "";
			for ($i=0;$i<sizeof($items)-1;$i++) {
				$link = ereg_replace(".*<link>","",$items[$i]);
				$link = ereg_replace("</link>.*","",$link);
				$title2 = ereg_replace(".*<title>","",$items[$i]);
				$title2 = ereg_replace("</title>.*","",$title2);
				// some feeds are exposed with CDATA format
				$title2 = str_replace("<![CDATA[","",$title2);
				$title2 = str_replace("]]>","",trim($title2));
				if ($items[$i] == "" AND $cont != 1) {
					$content = "";
				} else {
					if (strcmp($link,$title2) AND $items[$i] != "") {
						$cont = 1;
						$content .= "<strong><big>&middot;</big></strong>&nbsp;<a href=\"$link\" target=\"new\">$title2</a><br>\n";
					}
				}
			}
		}
	}
	return $content;
}


/**
 * Genera il feed RSS
 *
 * Genera il file <i>/misc/backend.xml</i> che contiene le news presenti in
 * homepage; il file XML e' strutturato per essere letto con un normale aggregator
 * RSS, ed e' compatibile con le {@link http://feedvalidator.org/docs/rss2.html specifiche RSS 2.0}.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 * @author Marco Segato <segatom@users.sourceforge.net> | 20050206: RSS 2.0 support
 */
function generate_RSS() {
	global $sitename, $newspp, $admin_mail;

	$url = "http://".getparam("HTTP_HOST", PAR_SERVER, SAN_FLAT).getparam("PHP_SELF", PAR_SERVER, SAN_FLAT);
	$url = str_replace(basename($url),"",$url);

	// tag apertura del feed
	$body = "<?xml version=\"1.0\" encoding=\""._CHARSET."\"?>\n<rss version=\"2.0\">\n\t<channel>\n";
	// informazioni generali sul feed
	$body .= "\t\t<title>$sitename</title>\n\t\t<link>$url</link>\n\t\t<description><![CDATA[\"$sitename\" HEADLINES]]></description>\n";
	$body .= "\t\t<managingEditor>$admin_mail</managingEditor>\n\t\t<generator>FlatNuke RSS Generator - http://www.flatnuke.org</generator>\n";
	$body .= "\t\t<lastBuildDate>".date("D, d M Y H:i:s",time())." GMT</lastBuildDate>\n";
	// carico array con le news ordinate per data
	$handle = opendir('news');
	#$modlist = "";
	$modlist = array();
	while ($file = readdir($handle)) {
        if (!( $file=="." or $file=="..") and (!ereg("^\.",$file) and ($file!="CVS"))) {
			#$modlist .= "$file ";
			array_push($modlist, $file);
		}
	}
	closedir($handle);
	#$modlist = explode(" ", $modlist);
	if(count($modlist)>0)
		rsort($modlist);
	// creazione tag per ognuna delle news
	#for ($i=0; $i < sizeof($modlist)-1; $i++) {
	for ($i=0; $i < count($modlist); $i++) {
		if ($i>=$newspp)
			break;
		$string = get_file("news/$modlist[$i]");
		$mytitle = get_xml_element("fn:title",$string);
		$mydesc = str_replace("<br>","<br />",get_xml_element("fn:header",$string));
		$id = str_replace(".xml","",$modlist[$i]);
		$body .= "\t\t<item>\n";
		$body .= "\t\t\t<title>$mytitle</title>\n";
		$body .= "\t\t\t<link>$url/index.php?mod=read&amp;id=$id</link>\n\t\t\t<description><![CDATA[$mydesc]]></description>\n";
		$body .= "\t\t\t<pubDate>".date("D, d M Y H:i:s",$id)." GMT</pubDate>\n";
		$body .= "\t\t</item>\n";
	}
	// tag chiusura del feed
	$body.="\t</channel>\n</rss>";
	// scrittura del feed
	$fp=fopen("misc/backend.xml","w");
	// questa write non sembra aver bisogno di un accesso esclusivo
	fwrite($fp,"$body");
	fclose($fp);
}


/**
 * Restituisce il livello di una sezione
 *
 * Restituisce il livello della sezione passata come parametro, leggendolo dal
 * file <i>/section/nomesezione/level.php</i>:
 *  - -1 se non esiste il file level.php, la sezione sara' visibile da tutti;
 *  - 0 per una sezione visibile solo da utenti registrati;
 *  - da 1 a 9 per una sezione visibile solo da utenti di livello intermedio;
 *  - 10 per una sezione visibile solo da utenti amministratore.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 *
 * @param string $section Nome della sezione
 * @return int -1 se la sezione non ha livello, oppure un numero di livello da 0 a 10
 */
function getsectlevel($section){
	$section=getparam($section,PAR_NULL,SAN_FLAT);
	if(!file_exists("sections/$section/level.php"))
		return(-1);
	$fp=file("sections/$section/level.php");
	return((int)str_replace("\n","",$fp[0]));
}


/**
 * Funzione alternativa a html_entity_decode()
 *
 * Rimpiazza la funzione nativa di PHP html_entity_decode() per gli utenti
 * che utilizzano una versione di PHP piu' vecchia della 4.3.0.
 *
 * @author Documentazione ufficiale PHP - {@link http://it.php.net/manual/en/function.html-entity-decode.php}
 *
 * @param string $string
 * @return string Una stringa che preserva i caratteri speciali HTML
 */
function unhtmlentities($string) {
  	/*$trans_tbl = get_html_translation_table(HTML_ENTITIES);
	$trans_tbl = array_flip($trans_tbl);
        return strtr($string, $trans_tbl);*/
}


/**
 * Genera un log di attivita'
 *
 * Aggiunge al file <i>/misc/log/log.php</i> una riga che contiene
 * la data e l'ora di produzione della segnalazione di log, la zona
 * di origine e una descrizione dell'attivita' effettuata.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 * @since 2.5.4
 *
 * @param string $zone Nome della sezione cui si riferisce il log
 * @param string $txt Testo del log da salvare
 */
function fnlog($zone, $txt){
	$zone=getparam($zone,PAR_NULL,SAN_FLAT);
	$txt=getparam($txt,PAR_NULL,SAN_FLAT);
	if($zone == "Forum") {
		$pref="../";
		$flog = $pref."misc/log";
	}
	else {
		$pref ="";
		$flog = "misc/log";
	}

	if(!is_dir($flog))
		mkdir($flog, 0777);

	//log rotate every 1NB
	if(file_exists("$flog/log.php") AND (filesize("$flog/log.php") >= 1048576)) {
		rename("$flog/log.php",$pref."misc/log/log-".time().".php");
		$fp=fopen("$flog/log.php","a");
		fwrite($fp, "<?exit(1);?>\n");
		fclose($fp);
	}

	if(!file_exists("$flog/log.php")) {
		$fp=fopen("$flog/log.php","a");
		fwrite($fp, "<?exit(1);?>\n");
		fclose($fp);
	}

	$fp=fopen("$flog/log.php","a");
	$string =  date ("d/m/Y H:i:s");
	$string = $string." $zone: $txt\n";
	fwrite($fp,$string);
	fclose($fp);
}


/**
 * Mostra le informazioni sul copyright di un modulo
 *
 * Crea un link da cui e' possibile visualizzare una finestra popup
 * con informazioni dettagliate sul copyright del modulo corrente.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 * @since 2.5.4
 *
 * @param string $modulo Nome del modulo installato
 * @param string $versione Versione del modulo installato
 * @param string $autore Nome dell'autore del modulo
 * @param string $email E-mail dell'autore del modulo
 * @param string $homepage Homepage dell'autore del modulo
 * @param string $licenza Licenza di rilascio del modulo
 */
function module_copyright($modulo, $versione, $autore, $email, $homepage, $licenza) {
	$modulo=getparam($modulo,PAR_NULL,SAN_FLAT);
	$versione=getparam($versione,PAR_NULL,SAN_FLAT);
	$autore=getparam($autore,PAR_NULL,SAN_FLAT);
	$email=getparam($email,PAR_NULL,SAN_FLAT);
	$homepage=getparam($homepage,PAR_NULL,SAN_FLAT);
	$licenza=getparam($licenza,PAR_NULL,SAN_FLAT);

	echo "<script language=\"JavaScript\" type=\"text/JavaScript\">
	var dom = (document.getElementById) ? true : false;
	var ns5 = ((navigator.userAgent.indexOf(\"Gecko\")>-1) && dom) ? true: false;
	var ie5 = ((navigator.userAgent.indexOf(\"MSIE\")>-1) && dom) ? true : false;
	var ns4 = (document.layers && !dom) ? true : false;
	var ie4 = (document.all && !dom) ? true : false;
	var nodyn = (!ns5 && !ns4 && !ie4 && !ie5) ? true : false;

	window.onload=function(){
		tooltip = (ns4)? document.fncopyright.document: (ie4)? document.all['fncopyright']: (ie5||ns5)? document.getElementById('fncopyright'): null;
		tipcss = (ns4)? document.fncopyright: tooltip.style;
		if(dom && ns5) {
			tipcss.position = 'fixed';
		}
		else {
			tipcss.position = 'absolute';
		}
	}

	function copyshow(){
		tooltip = (ns4)? document.fncopyright.document: (ie4)? document.all['fncopyright']: (ie5||ns5)? document.getElementById('fncopyright'): null;
		tipcss = (ns4)? document.fncopyright: tooltip.style;
		if(tipcss.visibility==\"visible\")
			tipcss.visibility=\"hidden\";
		else
			tipcss.visibility=\"visible\";
	}
	</script>";

	echo "<br><div align=\"right\"><a href=\"javascript:;\" onClick=\"copyshow();\">Copyright &copy; <b>$modulo</b></a></div><br>";
	echo "<div id='fncopyright' style=\"top: 15px; left: 15px; display: block; visibility: hidden; background-color: #FFFBA6; border: 1px solid; padding: 5px;\">";
	echo "<p align='center'><b>Copyright informations</b></p>Module developed for the <b><a href='http://flatnuke.sf.net'>flatnuke</a></b> CMS<br><br><b>Module name</b>: $modulo<br><b>Version</b>: $versione<br><b>License</b>: $licenza<br><b>Author</b>: $autore<br><b>E-mail</b>: <a href='mailto:$email'>$email</a><br><b>Home page</b>: <a href='$homepage' target='_blank' title='$homepage'>$homepage</a> <br><p align='center'><b><a href='javascript:;' onClick=\"copyshow();\">Close</a></b></p></div>";
}


/**
 * Gestione tag per codice html
 *
 * Rimpiazza i pseudo-tag ([b], [i], ecc) con i tag html)
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 * @author Marco Segato <segatom@users.sourceforge.net> | 20050916: Unificato la funzione per l'uso nel sito e nel forum
 * @since 2.5.7
 *
 * @param string $string Stringa da verificare
 * @param string $where Riferimento alla root per l'esecuzione del codice: 'home' per le news, 'forum' per il forum
 * @return string Codice HTML
 */
function tag2html($string, $where) {
	// verifico provenienza della chiamata e adatto i richiami alle directories
	/*$string=getparam($string,PAR_NULL,SAN_FLAT);
	$where=getparam($where,PAR_NULL,SAN_FLAT);*/

	switch($where) {
		case "home":
			$prepath = "forum/";
		break;
		case "forum":
			$prepath = "";
		break;
	}
	// solo l'amministratore pu usare codice HTML
	$myforum=getparam("myforum", PAR_COOKIE, SAN_FLAT);
	/*if(isset($_COOKIE['myforum'])) $myforum = $_COOKIE['myforum'];
		else $myforum = "";*/
	if(getlevel($myforum,$where) < 10) {
		$string = str_replace("<", "&lt;", $string);
		$string = str_replace(">", "&gt;", $string);
	}
	$string = str_replace("|", "", $string);
	// emoticons
	$string = str_replace("[:)]", "<img src='".$prepath."emoticon/01.png' alt=':)'>", $string);
	$string = str_replace("[:(]", "<img src='".$prepath."emoticon/02.png' alt=':('>", $string);
	$string = str_replace("[:o]", "<img src='".$prepath."emoticon/03.png' alt=':o'>", $string);
	$string = str_replace("[:p]", "<img src='".$prepath."emoticon/04.png' alt=':p'>", $string);
	$string = str_replace("[:D]", "<img src='".$prepath."emoticon/05.png' alt=':D'>", $string);
	$string = str_replace("[:!]", "<img src='".$prepath."emoticon/06.png' alt=':!'>", $string);
	$string = str_replace("[:O]", "<img src='".$prepath."emoticon/07.png' alt=':O'>", $string);
	$string = str_replace("[8)]", "<img src='".$prepath."emoticon/08.png' alt='8)'>", $string);
	$string = str_replace("[;)]", "<img src='".$prepath."emoticon/09.png' alt=';)'>", $string);
	// formattazione testo
	$string = str_replace("\n", "<br>", $string);
	$string = str_replace("\r", "", $string);
	$string = str_replace("[b]", "<b>", $string);
	$string = str_replace("[/b]", "</b>", $string);
	$string = str_replace("[i]", "<i>", $string);
	$string = str_replace("[/i]", "</i>", $string);
	$string = str_replace("[quote]", "<blockquote><hr noshade><i>", $string);
	$string = str_replace("[/quote]", "</i><hr noshade></blockquote>", $string);
	$string = str_replace("[code]", "<blockquote><pre>", $string);
	$string = str_replace("[/code]", "</pre></blockquote>", $string);
	// solo l'amministratore pu inserire immagini
	switch($where) {
		case "home":
			if((getlevel($myforum,$where)==10) AND versecid($myforum)) {
				$string = str_replace("[img]", "<br><img src=\"", $string);
				$string = str_replace("[/img]", "\" alt=\"uploaded_image\"><br>", $string);
			}
		break;
		case "forum":
			if((getlevel($myforum,$where)==10) AND versecid2($myforum)) {
				$string = str_replace("[img]", "<br><img src=\"", $string);
				$string = str_replace("[/img]", "\" alt=\"uploaded_image\"><br>", $string);
			}
		break;
	}

	//$string = str_replace("[wk]", "<a href=\"http://en.wikipedia.org/wiki/

	// colori del testo
	$string = str_replace("[red]", "<font color='#ff0000'>", $string);
	$string = str_replace("[green]", "<font color='#00ff00'>", $string);
	$string = str_replace("[blue]", "<font color='#0000ff'>", $string);
	$string = str_replace("[pink]", "<font color='#ff00ff'>", $string);
	$string = str_replace("[yellow]", "<font color='#ffff00'>", $string);
	$string = str_replace("[cyan]", "<font color='#00ffff'>", $string);
	$string = str_replace("[/red]", "</font>", $string);
	$string = str_replace("[/blue]", "</font>", $string);
	$string = str_replace("[/green]", "</font>", $string);
	$string = str_replace("[/pink]", "</font>", $string);
	$string = str_replace("[/yellow]", "</font>", $string);
	$string = str_replace("[/cyan]", "</font>", $string);

	// WIKIPEDIA
	$items = explode("[/wp]",$string);
	for ($i = 0; $i < count($items); $i++) {
		$wp="";
		if(stristr($items[$i],"[wp")){
			$wp_lang = ereg_replace(".*\[wp lang=","",$items[$i]);
			$wp_lang = ereg_replace("\].*","",$wp_lang);
			$wp = ereg_replace(".*\[wp.*\]", "", $items[$i]);
			$wp = ereg_replace("\[/wp\].*", "", $wp);
			if ($wp != "") {
				$nuovowp="<a style=\"text-decoration: none; border-bottom: 1px dashed; color: blue;\" target=\"new\" href=\"http://$wp_lang.wikipedia.org/wiki/$wp\">$wp</a>";
			$string=str_replace("[wp lang=$wp_lang]".$wp."[/wp]", $nuovowp, $string);
			}
		}
	}

	$items = "";
	// URLs
	$items = explode("[/url]",$string);
	for ($i = 0; $i < count($items); $i++) {
		$url="";
		if(stristr($items[$i],"[url]")){
			$url = ereg_replace(".*\[url\]", "", $items[$i]);
			$url = ereg_replace("\[/url\].*", "", $url);
			if ($url != "") {
				if (stristr($url, "http://") == FALSE) {
					$nuovourl="<a target=\"new\" href=\"http://$url\">$url</a>";
				} else {
					$nuovourl="<a target=\"new\" href=\"$url\">$url</a>";
				}
			$string=str_replace("[url]".$url."[/url]", $nuovourl, $string);
			}
		}
	}

	return ($string);
}


/**
 * Dichiara una funzione JS per il pannello dei pulsanti BBCODES
 *
 * Dichiara una funzione JS che viene utilizzata dal pannello dei
 * pulsanti BBCODES per inserire il testo corretto nell'area di testo
 * indicata come terzo parametro.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 * @author Marco Segato <segatom@users.sourceforge.net> | 20050906: added parameter 'area' in JS function
 * @author Bjrn Splinter <insites@gmail.com> | 20050912: removed additional chars inserted before and after tag1/tag2 in 'if(document.selection) {}
 * @since 2.5.7
 *
 */
function bbcodes_js() {
	echo "<script type='text/javascript'>
		function insertTags(tag1, tag2, area) {
			var txta = document.getElementsByName(area)[0];
			txta.focus();
			if (document.selection) {
				var sel  = document.selection.createRange();
				sel.text = tag2
					? tag1 + sel.text + tag2
					: tag1;
			}
			else if (txta.selectionStart != undefined) {
				var before = txta.value.substring(0, txta.selectionStart);
				var sel    = txta.value.substring(txta.selectionStart, txta.selectionEnd);
				var after  = txta.value.substring(txta.selectionEnd, txta.textLength);
				txta.value = tag2
					? before + tag1 + sel + tag2 + after
					: before + \"\" + tag1 + \"\" + after;
			}
		}
	</script>";
}


/**
 * Crea il pannello dei pulsanti BBCODES
 *
 * Crea il pannello dei pulsanti BBCODES per inserire il testo corretto
 * nell'area di testo indicata come parametro.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 * @author Marco Segato <segatom@users.sourceforge.net> | 20050906: added parameter 'area' in JS function
 * @author Bjrn Splinter <insites@gmail.com> | 20050912: added variable 'prepath', changed some '' to "" to prevent IE script errors
 * @since 2.5.7
 *
 * @param string $area Area di testo in cui inserire i BBCODES
 * @param string $where Riferimento alla root per l'esecuzione del codice: 'home' per le news, 'forum' per il forum
 * @param string $what 'formatting' per creare il pannello con i tasti di formattazione testo, 'emoticons' per le emoticons
 */
function bbcodes_panel($area, $where, $what) {
	$area=getparam($area,PAR_NULL,SAN_FLAT);
	$where=getparam($where,PAR_NULL,SAN_FLAT);
	$what=getparam($what,PAR_NULL,SAN_FLAT);

	$myforum=getparam("myforum", PAR_COOKIE, SAN_FLAT);
	// verifico provenienza della chiamata e adatto i richiami alle directories
	switch($where) {
		case "home":
			$prepath = "forum/";
		break;
		case "forum":
			$prepath = "";
		break;
	}
	// stampo la parte di pannello selezionata
	switch($what) {
		case "formatting":
		?><img OnClick="javascript:insertTags('[b]', '[/b]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/bold.png" border="0" alt="bold" title="bold" style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[i]', '[/i]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/italic.png" border="0" alt="italic" title="italic" style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[quote]', '[/quote]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/quote.png" border="0" alt="quote" title="quote" style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[code]', '[/code]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()"src="<?=$prepath?>emoticon/code.png" border="0" alt="code" title="code" style="cursor: pointer;"/>
		<? // solo l'amministratore pu inserire immagini
		/*if(isset($_COOKIE['myforum'])) $myforum = $_COOKIE['myforum'];
			else $myforum = "";*/
		switch($where) {
			case "home":
				if((getlevel($myforum,$where)==10) AND versecid($myforum)) {
					?><img OnClick="javascript:insertTags('[img]', '[/img]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/image.png" border="0" alt="image" title="image" style="cursor: pointer;"/><?
				}
			break;
			case "forum":
				if((getlevel($myforum,$where)==10) AND versecid2($myforum)) {
					?><img OnClick="javascript:insertTags('[img]', '[/img]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/image.png" border="0" alt="image" title="image" style="cursor: pointer;"/><?
				}
			break;
		}
		?>
		<img OnClick="javascript:insertTags('[red]', '[/red]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/red.png" border="0" alt="red" title="red" style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[green]', '[/green]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/green.png" border="0" alt="green" title="green" style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[blue]', '[/blue]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/blue.png" border="0" alt="blue" title="blue" style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[pink]', '[/pink]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/pink.png" border="0" alt="pink" title="pink" style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[yellow]', '[/yellow]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()"  src="<?=$prepath?>emoticon/yellow.png" border="0" alt="yellow" title="yellow" style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[cyan]', '[/cyan]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/cyan.png" border="0" alt="cyan" title="cyan" style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[url]', '[/url]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/url.png" border="0" alt="url" title="url" style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[wp lang=en]', '[/wp]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/wikipedia.png" border="0" alt="wikipedia" title="wikipedia" style="cursor: pointer;"/>
			<?
		break;
		case "emoticons":
		?><img OnClick="javascript:insertTags('[:)]', '', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/01.png" border="0" alt="Happy" style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[:(]', '', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/02.png" border="0" alt="Triste"  style="cursor: pointer;"/>
		<img  OnClick="javascript:insertTags('[:o]', '', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/03.png" border="0" alt="sorpresa"  style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[:p]', '', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/04.png" border="0" alt="linguaccia"  style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[:D]', '', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/05.png" border="0" alt="risata" style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[:!]', '', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/06.png" border="0" alt="indifferente"  style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[:O]', '', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/07.png" border="0" alt="sbalordito"  style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[8)]', '', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/08.png" border="0" alt="fighetto"  style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[;)]', '', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/09.png" border="0" alt="occhiolino" style="cursor: pointer;"/>

			<?
		break;
	}
}
?>
