<?php
/*
   +----------------------------------------------------------------------+
   | Barman - A PHP-Powered Bartender's administration tool               |
   +----------------------------------------------------------------------+
   | Copyright (c) 2004 Sergio Cayuqueo                                   |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2 of the GPL license,         |
   | that is bundled with this package in the file LICENSE.		  |
   +----------------------------------------------------------------------+
   | Authors: Sergio Cayuqueo <linuxv@users.sourceforge.net>           	  |
   +----------------------------------------------------------------------+
*/

$windows = array();
function delete_event($window, $event)
{
      $window->hide();
      return true;
}

function close_window($widget)
{
      $window = $widget->get_toplevel();
      $window->hide();
}

/*
 Called when clist column is clicked. It sets sorting by the clicked column.
*/
function clist_click_column($clist, $column) {
    $clist->set_sort_column($column);
    $clist->sort();
}



/*
 Function displaying the result of query.
*/
function drinks_list($query="SELECT * FROM  drinks") {
    global $windows;

    //if the query_window is opened, let's close it
    if (isset($windows['query_window'])) {
        close_window($windows['query_window']);
    }

    $window = &new GtkWindow;
    $windows['query_window'] = $window;
    $window->set_name('query_window');
    $window->connect('delete-event', 'delete_event');
    $window->set_policy(false, true,false);
    $window->set_title('Query result');
    $window->set_uposition(220,85);

    $box1 = &new GtkVBox();
    $window->add($box1);

    //frame displaying entered sql query
    $frame = &new GtkFrame('MySQL Query');

   $box1->pack_start($frame,false);
   $label = &new GtkLabel($query);
   $frame->add($label);

   //frame displaying clist with the query result
   $frame = &new GtkFrame('MySQL Query Result');
   $box1->pack_start($frame,true);

   //we'll display the result with scrollbars
   $scrolled_win = &new GtkScrolledWindow();
   $scrolled_win->set_border_width(5);
   $scrolled_win->set_policy(GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
   $frame->add($scrolled_win);

   /*here we deal with the result. If mysql_query called with the
     query entered in main window, return a result we can display clist
   */
   if ($result = mysql_query($query)) {
       /*
          at first, keys array contains the names of columns
       */
       if ($data = mysql_fetch_array($result)) {
            $i=0;
            $keys = array();
            while (list($key,$val) = each($data)) {
                  if ($i%2) $keys[]=$key;
                  $i++;
            }
       }

       /*
          now we can prepare the clist, keys are the titles of columns and
          the number of columns is equal to the number of keys
       */
       $clist = &new GtkCList(count($keys), $keys);
       $clist->connect('click_column', 'clist_click_column');

       //we sets the auto_resize for each column
       for ($i=0;$i<count($keys);$i++)
            $clist->set_column_auto_resize($i, true);
       $scrolled_win->add($clist);

       /*
          now the data from result
          we get the data from each row to row_data array and then we
          append this array to the clist as a new row
       */
       do {
            for($i=0; $i < count($data)/2; $i++) {
             $row_data[$i] = $data[$i];
             }
             $clist->append($row_data);
       }while ($data = mysql_fetch_array($result));


    }

    $button = &new GtkButton(gettext('Close'));
    $button->connect('clicked', 'close_window');
    $box1->pack_start($button,false);
    $button->set_flags(GTK_CAN_DEFAULT);
    $button->grab_default();
    $window->show_all();
}

?>
