<?php
/*
   +----------------------------------------------------------------------+
   | Barman - A PHP-Powered Bartender's administration tool               |
   +----------------------------------------------------------------------+
   | Copyright (c) 2004 Sergio Cayuqueo                                   |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2 of the GPL license,         |
   | that is bundled with this package in the file LICENSE.		  |
   +----------------------------------------------------------------------+
   | Authors: Sergio Cayuqueo <linuxv@users.sourceforge.net>           	  |
   +----------------------------------------------------------------------+
*/
// Load Gettext module, and functions
include($basepath."/"."gettext.php");
// Inicialize the glade interface
$gui['interface'] = new GladeXML($basepath . '/Barman.glade');
$main  = $gui['interface']->get_widget('main');
$main->connect_object('destroy', array( 'gtk' ,'main_quit'));   
// Load list of internal functions
include($basepath."/"."funcs.php");
// Drinks List
include($basepath."/"."dlist.php");
// Dialogs boxes
$preferences_dialog   = $gui['interface']->get_widget('preferences_dialog');
$about_dialog         = $gui['interface']->get_widget('about_dialog');
// Set version number to display on about dialog box
$about_version  = $gui['interface']->get_widget('about_label_version_number');
$about_version->set_text($version);

/******* Menu *******/
// Menu File->List
$dlist = $gui['interface']->get_widget('drinkslist');
$dlist->connect_object('activate','drinks_list');
// Menu File->Close
$close = $gui['interface']->get_widget('close');
$close->connect_object('activate', array( 'gtk' ,'main_quit'));
// Menu Tools->Preferences
$preferences = $gui['interface']->get_widget('preferences');
$preferences_accept = $gui['interface']->get_widget('preferences_accept');
$preferences_cancel = $gui['interface']->get_widget('preferences_cancel');
$preferences->connect_object('activate',array($preferences_dialog,'show'));
$preferences->connect_object('destroy', array($preferences_dialog,'hide'));   
$preferences_cancel->connect_object('clicked', array($preferences_dialog,'hide'));
$preferences_accept->connect_object('clicked','save_config_data');
$preferences_accept->connect_object('clicked',array($preferences_dialog,'hide'));
// Menu Help->About
$about = $gui['interface']->get_widget('about');
$about->connect_object('activate',array($about_dialog,'show'));
// Menu Help->About->Close
$about_close = $gui['interface']->get_widget('about_close');
$about_close->connect_object('clicked',array($about_dialog,'hide'));
// Load configuration values
load_config_data();
$connect = mysql_pconnect("localhost","cd4046","") or die("can't
connect to server");
mysql_db_query("barman",$connect);

gtk::main();
?>
