<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* API Server
* @package TenderSystem
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// set the header information
header("Content-type: text/xml");
// set application executable file location
$cfg['file'] = getcwd().'/include/';
$cfg['directory'] = getcwd();
// set that no errors are echo'd as that messes up xml
ini_set("display_errors", "0");
// load settings
require($cfg['file'].'modules/settings/config.inc.php');
// determine if php must be logged in log location
if ($cfg['log']['php']) {
	// set location
	$php_log = $cfg['file'].$cfg['log']['php'];
	// set log to true and set location
	ini_set("log_errors", "1");
	ini_set("error_log", $php_log);
}
// load required files
require($cfg['file'].'modules/generic/class/security.class.php');
require($cfg['file'].'modules/generic/class/error.class.php');
require($cfg['file'].'modules/session/class/session.class.php');
require($cfg['file'].'modules/user/class/user.class.php');
require($cfg['file'].'modules/organisation/class/organisation.class.php');
require($cfg['file'].'modules/branch/class/branch.class.php');
require($cfg['file'].'modules/generic/class/xml.class.php');
require($cfg['file'].'modules/external/class/adodb/adodb.inc.php');
require($cfg['file'].'modules/log/class/log.class.php');
require($cfg['file'].'modules/generic/class/database.class.php');

// instantiate object
$new_security = new security;
// get parameters
$params = $new_security->sanitise_post($_POST);
if($params == FALSE) {
	// The Curl Data has been corrupted
	$error[] = "342";
	$new_error = new error;
	// proses the reponse error and display
	$new_error->response_xml($error,"",$cfg);
}
// set authentication
$authenticated = FALSE;
// validate incoming ip addresses
if ($cfg['security']['call']) {
	// determine if GUI username and password present
	if ($cfg['api']['authenticate'] && $params['gui_username'] && $params['gui_password']) {
		// loop through every api username and password
		$loop_size = sizeof($cfg['api']['username']);
		for ($i = 0; $i < $loop_size; $i++) {
			if ($params['gui_username'] == $cfg['api']['username'][$i] && $params['gui_password'] == $cfg['api']['password'][$i]) {
				$authenticated = TRUE;
				continue;
			}
		}
	} else {
		$server_ip = $_SERVER['REMOTE_ADDR'];
		// determine if remote IP is a valid incoming ip
		$authenticated = $new_security->validate_ip($server_ip,$cfg);
	}
	// show error message if not authenticated
	if (!$authenticated) {
		$new_error = new error;
		// proses the reponse error and display
		$new_error->response_xml($new_security->error,"",$cfg);
		// ensure that nothing else processed
		die();
	}
}
// determine if debugging
if ($params['debug']) {
	// set
	$cfg['debug'] = TRUE;
}
// log incoming request
$new_log = new log;
$cfg['debug'] = $new_log->log_request('curl',$params,$cfg);
// the modules and functions
require($cfg['file'].'modules/generic/generic.php');
// display xml
echo $xml;
?>