<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* API module server
* @package TenderSystem
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
if (eregi("include.php",$_SERVER['PHP_SELF'])) {
    die("You can't access this file directly...");
}

// set application executable file location
$cfg['file'] = getcwd().'/application/include/';
$cfg['directory'] = getcwd().'/application';
// set that no errors are echo'd as that messes up the xml
ini_set("display_errors", "0");
// load required files
require($cfg['file'].'modules/settings/config.inc.php');
// determine if php must be logged in log location
if ($cfg['log']['php']) {
	// set location
	$php_log = $cfg['file'].$cfg['log']['php'];
	// set log to true and set location
	ini_set("log_errors", "1");
	ini_set("error_log", $php_log);
}
require_once($cfg['file'].'modules/generic/class/security.class.php');
require_once($cfg['file'].'modules/generic/class/error.class.php');
require_once($cfg['file'].'modules/session/class/session.class.php');
require_once($cfg['file'].'modules/user/class/user.class.php');
require_once($cfg['file'].'modules/organisation/class/organisation.class.php');
require_once($cfg['file'].'modules/branch/class/branch.class.php');
require_once($cfg['file'].'modules/generic/class/xml.class.php');
require_once($cfg['file'].'modules/external/class/adodb/adodb.inc.php');
require_once($cfg['file'].'modules/log/class/log.class.php');
require_once($cfg['file'].'modules/generic/class/database.class.php');
// instantiate object
$new_security = new security;
// determine if debugging
if (isset($params['debug'])) {
	// set
	$cfg['debug'] = TRUE;
}
// log incoming request
$new_log = new log;
$cfg['debug'] = $new_log->log_request('module',$params,$cfg);
// the modules and functions
require($cfg['file'].'modules/generic/generic.php');
?>