<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Process daily cron
* @package TenderSystem
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// if incoming from gui ensure that is is an administrator
if ($user) {
	// Security - ensure that somebody is not trying to fake $user if global variables are on
	// not required if global varibales are off or API is hosted on a non-public server
	if (eregi("cron_daily.php",$_SERVER['PHP_SELF'])) {
	    die ("You can't access this file directly...");
	}
	// instantiate the xml object
	$new_xml = new xml;
	// set the required type and permission required
	$required[0]['classification'] = "3";
	$required[0]['permission'] = "all";
	// Security - determine if user authorised to perform transaction
	$authorised = $new_security->permission_authentication($required,$user,$cfg);
	// unauthorised user
	if (!$authorised) {
		// instantiate the error class
		$new_error = new error;
		// proses the reponse error
		$xml = $new_error->response_xml($new_security->error,$user,$cfg);
	}
} else {
	// get the time with the local duration already added
	function ts_time($cfg) {
		return time() + $cfg['local']['duration'];
	}
	// set application executable file location
	$cfg['file'] = getcwd()."/";
	// load settings
	require($cfg['file'].'modules/settings/config.inc.php');
	// determine if php must be logged in log location
	if ($cfg['log']['php']) {
		// set location
		$php_log = $cfg['file'].$cfg['log']['php'];
		// set log to true and set location
		ini_set("log_errors", "1");
		ini_set("error_log", $php_log);
	}
	// load required files
	require($cfg['file'].'modules/generic/class/security.class.php');
	require($cfg['file'].'modules/generic/class/error.class.php');
	require($cfg['file'].'modules/external/class/adodb/adodb.inc.php');
	require($cfg['file'].'modules/log/class/log.class.php');
	require($cfg['file'].'modules/generic/class/database.class.php');
	require($cfg['file'].'modules/user/class/user.class.php');
	require($cfg['file'].'modules/organisation/class/organisation.class.php');
	require($cfg['file'].'modules/branch/class/branch.class.php');
	// set incoming ip
	$log['ip'] = $_SERVER['REMOTE_ADDR'];
	// ensure that only requested from authorised ip
	if ($cfg['security']['call']) {
		if ($log['ip']) {
			foreach ($cfg['security']['ip'] as $key => $value) {
				if ($value == $log['ip']) {
					// correct incoming IP
					$authorised = TRUE;
				}				
			}
		} else {
			// executed by CGI
			$authorised = TRUE;
		}
		if (!isset($authorised)) {
			$error_text = "Unauthorised daily cron request from :".$log['ip'];
			$new_error = new error;
			$new_error->log("POP","critical",$error_text,$cfg);
			// response
			die("Error: 40");
		}
	}
	// create a connection to the database
	if($cfg['multiple']['dsn']) {
		require($cfg['file'].'modules/generic/class/connwrapper.class.php');
		$conn = new connection($cfg);
	} else {
		$conn = &ADONewConnection($cfg['dsn']['0']['conn']);
	}
	// return in association form
	$conn->SetFetchMode(ADODB_FETCH_ASSOC);
	// connect to the DSN
	// error if connection not established
	if ($conn->ErrorMsg()) {
		// instantiate the error class and log
		$new_error = new error;
		// set the error message
		$error_text = "Error:".$conn->ErrorMsg();
		// log the error message as it occurred in ADODB
		$new_error->log("SQL","critical",$error_text,$cfg);
		// exit
		die();
	}
}
if ($authorised) {
	// load required files
	require($cfg['file'].'modules/generic/class/pop.class.php');
	require($cfg['file'].'modules/generic/class/mime.class.php');
	require($cfg['file'].'modules/external/class/smtp/htmlMimeMail.php');
	require($cfg['file'].'modules/generic/class/message.class.php');
	require($cfg['file'].'modules/generic/class/file.class.php');
	require($cfg['file'].'modules/generic/class/email.class.php');
	// set the complete file path
	$file_path = $cfg['file']."/modules";
	// open the directory
	$dir = opendir($file_path);
	// if folder accessible
	if ($dir) {
		// loop through all the files (modules)
		while(($file=readdir($dir)) !== FALSE) {
			// determine if hidden file not included
			if($file{0} != "." && $file != "CVS" && is_dir($file_path."/".$file)) {
				// set files in an array
				$modules[] = $file;
			}
		}
		// close the directory
		closedir($dir);
	}
	// go through all the modules to determine if it has a proses_daily
	$transaction_support = $cfg['dsn']['0']['transaction']['enable'];
	if(is_array($modules)) {
		foreach($modules as $value) {
			// transaction support enabled
			if($transaction_support) {
				// start transaction
				$conn->StartTrans();
			}
			if(file_exists($file_path."/".$value."/api_proses_daily.php")) {
				include($file_path."/".$value."/api_proses_daily.php");
			}
			if($transaction_support) {
				// end transaction
				$conn->CompleteTrans();
			}
		}
	}
}
?>