<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Create area
* @package TenderSystem
* @subpackage area
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global varibales are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required[0]['classification'] = "3";
$required[0]['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} elseif ($params['insertarea']) {
	// include files
	require($cfg['file'].'modules/area/class/area.class.php');
	// instatiate area object
	$new_area = new area;
	$info['searchinfo']['stateid']= $xml_params['stateid'] = $params['stateid'];
	$info['searchinfo']['areaname'] = $params['insertarea']['name'];
	if($exist_area = $new_area->search($info,$cfg,$conn)) {
		// Already exists
		$xml_params['exist_area'][]['name'] = $exist_area[0]['areaname'];
	} 
	// if a new area
	else {
		// insert area into database
		if($new_area->create_area($params['insertarea'],$cfg,$conn)) {
			$xml_params['created'] = "1";
		} else {
			$xml_params['created'] = "0";
		}
	}
	// generate xml 
	$xml = $new_xml->xml_generator("area","create_area",$new_area->error,$xml_params,$user,$cfg);
} else {
	$xml_params['stateid'] = $params['stateid'];
	$xml = $new_xml->xml_generator("area","create_area",$params['error'],$xml_params,$user,$cfg);
}
?>