<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Create state
* @package TenderSystem
* @subpackage area
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global varibales are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// set the required type and permission required
$required['classification'] = "3";
$required['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} else {
	// include required file
	require($cfg['file'].'modules/area/class/area.class.php');
	// instatiate xml object
	$new_xml = new xml;
	if($params['state']) {
		// instantiate object
		$new_state = new area;
		// insert area and states into database
		foreach($params['state'] as $state) {
			$info['searchinfo']['statename'] = $state['name'];
			// if state already exists
			if($exist_state = $new_state->search_state($info,$cfg,$conn)) {
				// Already exists
				$xml_params['exist_state'][]['name'] = $state['name'];
				$stateid = $exist_state[0]['stateid'];
				if(is_array($state['area'])) {
					// go through all the areas
					foreach($state['area'] as $area) {
						$info['searchinfo']['stateid'] = $stateid;
						$info['searchinfo']['areaname'] = $area;
						// check if area already exist
						if($exist_area = $new_state->search($info,$cfg,$conn)) {
							// Already exists
							$xml_params['exist_area'][]['name'] = $area;
						} 
						else {
							// A new area
							$insertarea['name'] = $area;
							$insertarea['state'] = $stateid;
							$insertarea['status'] = "1";
							if($new_state->create_area($insertarea,$cfg,$conn)) {
								$xml_params['area'][] = $insertarea;
							}
						}
					}
				}
			} 
			// if new state
			else {
				$insert['name'] = $state['name'];
				$insert['status'] = "1";
				if($stateid = $new_state->create_state($insert,$cfg,$conn)) {
					$xml_params['state'][] = $insert;
					// check if there are areas
					if(is_array($state['area'])) {
						// go through all the areas
						foreach($state['area'] as $area) {
							$insertarea['name'] = $area;
							$insertarea['state'] = $stateid;
							$insertarea['status'] = "1";
							if($new_state->create_area($insertarea,$cfg,$conn)) {
								$xml_params['area'][] = $insertarea;
							}
						}
					}
				}
				$xml_params['created'] = "1";
			}
		}
		$xml = $new_xml->xml_generator("area","create_state",$new_state->error,$xml_params,$user,$cfg);
	} else{
		// generate xml 
		$xml = $new_xml->xml_generator("area","create_state","",$xml_params,$user,$cfg);
	}
}
?>