<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Area class
* @package TenderSystem
* @subpackage area
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

Class area {
	// set the paramaters
	var $error;
	var $state;
	var $area;
	var $database;
	
	function area() {
		// allow to work on php5
		$this->error = array();	
	}
	
	function supplier_exists($id,$cfg,$conn) {
      	// query database to find out if there are suppliers available for the sub category
      	$sqlstr = "SELECT * ";
      	$sqlstr.= "FROM ~organisation ";
		$sqlstr.= "WHERE ~organisation.classification = '1' ";
		$sqlstr.= "AND ~organisation.id = '".$id."' ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$one = $conn->GetOne($sqlstr);
      	if ($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// set the response error
			$this->error[] = "1065";
			// response
			return FALSE;
        }
		return $one;
	}
	
	function create_area($insert,$cfg,$conn){
		$this->area = $insert;
		if (!$this->area['name']){
			// Missing area name
			$this->error[] = "243";
		}
		if (!$this->area['state']){
			// Missing state id
			$this->error[] = "242";
		}
		if(!empty($this->error)){
			// Error in area class
			$this->error[] = "240";
			return FALSE;
		}
		$new_database = new database;
		if(!$this->area['id']) {
			// generate an id 
			$this->area['id'] = $new_database->get_next_id("~area",$cfg,$conn);
		}
		$table_name = "~area";
		$new_database->parse_sql($table_name,$cfg);
		// extcute sql insert
		$recordSet = $conn->AutoExecute($table_name,$this->area,"INSERT");
      	if (!$recordSet) {
      		$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
      		// Error occurred while inserting into Database
			$this->error[] = "1064";
			// response
			return FALSE;
      	} 
      	// resturn the id
		return $this->area['id'];
	}
	
	function search($params,$cfg,$conn) {
		// prevent "Cannot use string offset as an array"
		if(!$params) {
			$this->area['searchinfo'] = array();
		} else {
			$this->area = $params;			
		}
		$sqlstr = "SELECT ~area.id AS areaid, ~area.name AS areaname, state.id AS stateid ";
		// include area_supplier info
		if($this->area['searchinfo']['organisationid']) {
			$sqlstr.= ", ~area_supplier.id AS areasupplierid ";
		}
		$sqlstr.= "FROM ~area, ~area_state state ";
		// include area_supplier info
		if($this->area['searchinfo']['organisationid']) {
			$sqlstr.= ", ~area_supplier ";
		}
		$sqlstr.= "WHERE ~area.status = '1' AND state.status = '1' ";
		$sqlstr.= "AND ~area.state = state.id ";
		// include area_supplier info
		if($this->area['searchinfo']['organisationid']) {
			$sqlstr.= "AND ~area.id = ~area_supplier.area ";
			$sqlstr.= "AND ~area_supplier.supplier = ".$this->area['searchinfo']['organisationid']."  ";
			$sqlstr.= "AND ~area_supplier.status = '1' ";
		}
		if($this->area['searchinfo']['stateid']) {
			$sqlstr.= "AND ~area.state = ".$this->area['searchinfo']['stateid']."  ";
		}
		if($this->area['searchinfo']['areaname']) {
			$sqlstr.= "AND ~area.name = '".$this->area['searchinfo']['areaname']."'  ";
		}
		if($this->area['searchinfo']['searchvalue']) {
			$sqlstr.= "AND ~areas.name LIKE %".$this->area['searchinfo']['searchvalue']."% ";
		}
		$sqlstr.= "ORDER BY ~area.name ASC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// error in area class
			$this->error[] = "240";
			// response
			return FALSE;
		}
		return $all;
	}
	
	function delete_area($id,$usersid,$cfg,$conn) {
		$new_database = new database;
		$update['status'] = "0";
		$update['deleted_by'] = $usersid;
		$new_database->setTime("deleted",$update,"",$cfg);
		$where = " id = ".$id." ";
		if(!$new_database->update_table("~area",$update,$where,$cfg,$conn)) {
			if(!empty($new_database->error)) {
				$this->error = array_merge($this->error,$new_database->error);	
			}
			// Error in area Class
			$this->error[] = "240";
			return FALSE;
		} 
      	return TRUE;
	}
	
	function create_state($insert,$cfg,$conn){
		$this->state = $insert;
		if (!$this->state['name']){
			// Missing state name
			$this->error[] = "13";
		}
		if(!empty($this->error)){
			// Error in area class
			$this->error[] = "240";
			return FALSE;
		}
		$new_database = new database;
		if(!$this->state['id']) {
			// generate an id 
			$this->state['id'] = $new_database->get_next_id("~area_state",$cfg,$conn);
		}
		$table_name = "~area_state";
		$new_database->parse_sql($table_name,$cfg);
		// extcute sql insert
		$conn->AutoExecute($table_name,$this->state,"INSERT");
		if ($conn->ErrorMsg()) {
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// Error occurred while inserting into Database
			$this->error[] = "1064";
			// response
			return FALSE;
		} 
		// resturn the id
		return $this->state['id'];
	}
	
	function search_state($params,$cfg,$conn) {
		// prevent "Cannot use string offset as an array"
		if(!$params) {
			$this->state['searchinfo'] = array();
		} else {
			$this->state = $params;
		}
		// sqlstr
		$sqlstr = "SELECT state.id AS stateid, state.name AS statename ";
		$sqlstr.= "FROM ~area_state state ";
		$sqlstr.= "WHERE state.status = '1' ";
		if($this->state['searchinfo']['searchvalue']) {
			$sqlstr.= "AND state.name LIKE %".$this->state['searchinfo']['searchvalue']."% ";
		}
		if($this->state['searchinfo']['statename']) {
			$sqlstr.= "AND state.name  ='".$this->state['searchinfo']['statename']."' ";
		}
		$sqlstr.= "ORDER BY upper(state.name) ASC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $all;
	}
	
	function delete_state($id,$usersid,$cfg,$conn) {
		$new_database = new database;
		$update['status'] = "0";
		$update['deleted_by'] = $usersid;
		$new_database->setTime("deleted",$update,"",$cfg);
		$where = " id = ".$id." ";
		if(!$new_database->update_table("~area_state",$update,$where,$cfg,$conn)) {
			if(!empty($new_database->error)) {
				$this->error = array_merge($this->error,$new_database->error);	
			}
			// Error in area Class
			$this->error[] = "240";
			return FALSE;
		} 
      	return TRUE;
	}
	
	function create_area_supplier($area,$supplier,$usersid,$cfg,$conn){
		if (!$area){
			// Missing area id
			$this->error[] = "244";
		}
		if (!$supplier){
			// Missing organisation id
			$this->error[] = "78";
		} elseif(!$this->supplier_exists($supplier,$cfg,$conn)) {
			// Supplier ID not in database
			$this->error[] = "356";
		}
		if(!empty($this->error)){
			// Error in area class
			$this->error[] = "240";
			return FALSE;
		}
		$new_database = new database;
		$table_name = "~area_supplier";
		$insert['id'] = $new_database->get_next_id($table_name,$cfg,$conn);
		$insert['area'] = $area;
		$insert['supplier'] = $supplier;
		$insert['status'] = "1";
		$insert['created_by'] = $usersid;
		$new_database->setTime("created",$insert,"",$cfg);
		$new_database->parse_sql($table_name,$cfg);
		// execute sql insert
		$conn->AutoExecute($table_name,$insert,"INSERT");
		if($conn->ErrorMsg()) {
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// Error occurred while inserting into Database
			$this->error[] = "1064";
			// response
				return FALSE;
		}
		// resturn the id
		return $insert['id'];
	}

	function delete_area_supplier($id,$usersid,$cfg,$conn) {
		$new_database = new database;
		$update['status'] = "0";
		$update['deleted_by'] = $usersid;
		$new_database->setTime("deleted",$update,"",$cfg);
		$where = " id = ".$id." ";
		if(!$new_database->update_table("~area_supplier",$update,$where,$cfg,$conn)) {
			if(!empty($new_database->error)) {
				$this->error = array_merge($this->error,$new_database->error);	
			}
			// Error in area Class
			$this->error[] = "240";
			return FALSE;
		} 
      	return TRUE;
	}
	
	function get_area_name($id,$cfg,$conn) {
		// query db to find out which suppliers provide the selected items
		$sqlstr = "SELECT name ";
		$sqlstr.= "FROM ~area ";
		$sqlstr.= "WHERE id = ".$id." ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		// execute the query
 		$area_name = $conn->GetOne($sqlstr);
       	if ($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// set the response error
			$this->error[] = "1065";
			// response
			return FALSE;
       	} 
		return $area_name;
	}

	function get_state_name_by_area($id,$cfg,$conn) {
		// query db to find out which suppliers provide the selected items
		$sqlstr = "SELECT state.name ";
		$sqlstr.= "FROM ~area_state state, ~area ";
		$sqlstr.= "WHERE ~area.id = ".$id." ";
		$sqlstr.= "AND state.id = ~area.state ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		// execute the query
 		$state_name = $conn->GetOne($sqlstr);
       	if ($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg()." SQL:".$sqlstr;
			$new_error->log("SQL","critical",$error_text,$cfg);
			// set the response error
			$this->error[] = "1065";
			// response
			return FALSE;
       	} 
		return $state_name;
	}
}
?>