<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Birthday Cron
* @package TenderSystem
* @subpackage birthday
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global varibales are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// include config file
require($cfg['file'].'modules/birthday/config.inc.php');
// determine if emails must be sent to administrators
if ($cfg['birthday']['admin']) {
	// include required classes
	require_once($cfg['file'].'modules/generic/class/message.class.php');
	require_once($cfg['file'].'modules/user/class/user.class.php');
    require_once($cfg['file'].'modules/generic/class/time.class.php');
	// get time info
	$this->time = ts_time($cfg);
	// determine tomorrows date
	$nextday = $this->time + 86400;
	$params['month'] = date("n", $nextday);
	$params['day'] = date("j", $nextday); 
	// determine what day it is
    $params['weekday'] = date("w");
	// day number for number of days checked
	$day_counter = 1;
	// determine if tomorrow is a holiday
    $new_time = new time;
    $determine_holiday = $new_time->check_holiday($params['day'],$params['month'],$cfg);
  	if (!$determine_holiday) {
		// instantiate object
		$new_user = new user;
		// determine if it is sun - thurs
		if ($params['weekday'] <= "4") {	
			//get users whose birthday is tomorrow			
			$users[0]['users'] = $new_user->get_birthdays($params,$cfg,$conn);
			// determine if thursday
			if ($params['weekday'] == "4") {
            	$day_counter++;	
		    	$nextday = $this->time + ($day_counter * 86400); 	
		    	$params['month'] = date("n", $nextday);
		    	$params['day'] = date("j", $nextday);
		    	$users[$day_counter-1]['users'] = $new_user->get_birthdays($params,$cfg,$conn);
		    	$day_counter++;	
		    	$nextday = $this->time + ($day_counter * 86400); 	
		    	$params['month'] = date("n", $nextday);
		    	$params['day'] = date("j", $nextday);
		     	$users[$day_counter-1]['users'] = $new_user->get_birthdays($params,$cfg,$conn);
		  	}
			// check if next day is holiday
			$nextday_holiday = TRUE;
			while($nextday_holiday) {
				$day_counter++;
				$nextday = $this->time + ($day_counter * 86400); 	
				$params['month'] = date("n", $nextday);
				$params['day'] = date("j", $nextday);
				$nextday_holiday = $new_time->check_holiday($params['day'],$params['month'],$cfg);
			    if ($nextday_holiday) {
					$users[$day_counter-1]['users'] = $new_user->get_birthdays($params,$cfg,$conn);
				}
				// loop control
				if ($day_counter = 20) {
					$nextday_holiday = FALSE;
				}
			}    		
		}
		// check if at least one user upcoming birthday
		$user_birthday = FALSE;
		for($k = 0; $k < $day_counter; $k++) {
			if ($users[$k]['users']) {	
				$user_birthday = TRUE;
			}
		}
        if ($user_birthday) {
			// get administrators
			$params['searchinfo']['classification'] = 3;
			$admin['users'] = $new_user->search($params, $cfg, $conn);
			// check if at least one administrator
            if ($admin['users']) {
				foreach ($admin['users'] as $admin_user) {
                    // get administrators info
                    $admin = $new_user->get_info($admin_user['usersid'], $cfg, $conn);
					// check if administrators profile == email or email / sms
					if (($admin['preference'] == 'm') || ($admin['preference'] == 'n')) {
						// open and set language file
						require($cfg['file'].'modules/birthday/language/'.$admin['language'].'/language.php');
	        			// include email body template
			        	require($cfg['file'].'modules/birthday/templates/admin_message.php');
						// set message paramaters
						$message['classification'] = "birthday_list_message";
						$message['subject'] = $subject;
						$message['body'] = $html;
						$message['name'] = $message['reference'] = $admin['name']." ".$admin['surname'];
						$message['email'] = $admin['email'];
                        // instantiate object
						$new_message = new message;
  						// send email to administrator
						$new_message->send_email_message($message,$admin['id'],"0",$cfg,$conn);
						// send sms notification
						if ($admin['preference'] == 'n') {
							$message['classification'] = "birthday_list_message_notification";
							$message['body'] = "birthday list has been sent to your email address";
							$message['name'] = $message['reference'] = $admin['name']." ".$admin['surname'];
							$message['email'] = $admin['email'];
							$message['phone_mobile'] = $admin['phone_mobile'];
							$new_message->send_sms_message($message,$admin['id'],"0",$cfg,$conn);
						}
					}
				}	
			}			
		}
	}
}
?>