<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Utilities
* @package TenderSystem
* @subpackage birthday
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required[0]['classification'] = "3";
$required[0]['permission'] = "all";

// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} else {
	// determine if birthday module is active
	if ($cfg['birthday']['enable']) {
		// instantiate the user class
		$new_user = new user;
		// month view
		if ($params['view'] == "month" && $params['month']) {
			// set the header
			$xml_params['header'] = $params['month'];
			// determine how many days are in the month
			$totaldays = date('t', mktime(0, 0, 0, $params['month'], 1, date("Y"))) + 1;
			// determine what is the first day
			// 	0 Sunday and 6 for Saturday
			$day_number = date('w');
			// set array counter
			$array_counter = 0;
			// insert spaces for blank days
			for ($i = 0; $i < $day_number; $i++) {
				$xml_params['day'][$array_counter]['date'] = "";
				// increment array counter
				$array_counter++;
			}
			// loop through every day and get the birthdays
			for ($i = 1; $i < $totaldays; $i++) {
				$params['day'] = $i;
				$xml_params['day'][$array_counter]['date'] = $i;
				$xml_params['day'][$array_counter]['birthday'] = $new_user->get_birthdays($params,$cfg,$conn);
				// increment array counter
				$array_counter++;
			}
			$xml = $new_xml->xml_generator("birthday","month",$new_user->error,$xml_params,$user,$cfg);
		} elseif ($params['view'] == "day" && $params['month'] && $params['day']) {
			$xml_params['header'] = sprintf("%04d-%02d-%02d", date("Y"), $params['month'], $params['day']);
			$xml_params['day'][0]['birthday'] = $new_user->get_birthdays($params,$cfg,$conn);
		} else {
			for ($i = 1; $i < 13; $i++) {
				// set params
				$params['month'] = $i;
				$xml_params['month'.$i][$i]['birthday'] = $new_user->get_birthdays($params,$cfg,$conn);
			}
			$xml = $new_xml->xml_generator("birthday","annual",$new_user->error,$xml_params,$user,$cfg);
		}
	} else {
		// module is inactive
		$error[0] = "e2";
		$xml = $new_xml->xml_generator("birthday","error",$error,$xml_params,$user,$cfg);
	}
}
?>