<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Create branch
* @package TenderSystem
* @subpackage branch
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required[0]['classification'] = "3";
$required[0]['permission'] = "all";
// or
$required[1]['classification'] = "2";
$required[1]['permission'] = "4";
// or
$required[2]['classification'] = "1";
$required[2]['permission'] = "2";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} elseif ($params['currentinfo']) {
	// branch info
	if($user['classification'] == "3") {
		$branch['organisation'] = $params['currentinfo'][0]['organisationid'];
	} else {
		$branch['organisation'] = $user['organisation'];
	}
	$branch['name'] = $params['currentinfo'][0]['branchname'];
	$branch['phone_prefix'] = $params['currentinfo'][0]['branchphone_prefix'];
	$branch['phone_work'] = $params['currentinfo'][0]['branchphone_work'];
	$branch['phone_fax'] = $params['currentinfo'][0]['branchphone_fax'];
	$branch['email'] = $params['currentinfo'][0]['branchemail'];
	$branch['branch_comment'] =  $params['currentinfo'][0]['branchcomment'];
	$branch['primary_address_street'] = $params['currentinfo'][0]['primary_address_street'];
	$branch['primary_address_city'] = $params['currentinfo'][0]['primary_address_city'];
	$branch['primary_address_state'] = $params['currentinfo'][0]['primary_address_state'];
	$branch['primary_address_postalcode'] = $params['currentinfo'][0]['primary_address_postalcode'];
	$branch['primary_address_country'] = $params['currentinfo'][0]['address_country'];
	$branch['alt_address_street'] = $params['currentinfo'][0]['alt_address_street'];
	$branch['alt_address_city'] = $params['currentinfo'][0]['alt_address_city'];
	$branch['alt_address_state'] = $params['currentinfo'][0]['alt_address_state'];
	$branch['alt_address_postalcode'] = $params['currentinfo'][0]['alt_address_postalcode'];
	$branch['alt_address_country'] = $params['currentinfo'][0]['address_country'];
	$branch['status'] = "1";
	// check if branch exists
	$new_branch = new branch;
	$info['searchinfo']['branchname'] = $branch['name'];
	$info['searchinfo']['organisationid'] = $branch['organisation'];
	if($new_branch->search($info,$cfg,$conn)) {
		$doinserts = FALSE;
		// Already exists
		$errors[] = "268";
	}
	// join errors
	if(!empty($new_branch->error)) {
		$errors = array_merge($errors,$new_branch->error);	
	}
	$xml_params['organisationid'] = $params['organisationid'];
	if($errors) {
		// resend old infomation
		$xml_params['currentinfo'] = $params['currentinfo'];
		// generate xml 
		$xml = $new_xml->xml_generator("branch","create",$errors,$xml_params,$user,$cfg);
	} else {
		// created by
		$branch['created_by'] = $user['id'];
		// insert branch into database
		if($id['id'] = $new_branch->create_branch($branch,$cfg,$conn)) {
			$xml_params['created'] = "1";
			$xml_params['editable'] = "0";
			$xml_params['branchinfo'][0] = $new_branch->get_profile($id,$cfg,$conn);
			// generate xml 
			$xml = $new_xml->xml_generator("branch","profile","",$xml_params,$user,$cfg);
		} else {
			$xml = $new_xml->xml_generator("branch","create",$new_branch->error,$xml_params,$user,$cfg);
		}
	}
} else {
	$xml_params['organisationid'] = $params['organisationid'];	
	$xml = $new_xml->xml_generator("branch","create",$params['error'],$xml_params,$user,$cfg);
}
?>