<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Branch profile
* @package TenderSystem
* @subpackage branch
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required['classification'] = "all";
$required['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} else { 
	// instantiate object
	$new_branch = new branch;
	if(!$params['id']) {
		$params['id'] = $user['branch'];
	}
	// check if editable 
	$xml_params['editable'] = "0";
	if($user['classification'] == "3") {
		$xml_params['editable'] = "1";
	} elseif ($user['organisation'] == $xml_params['branchinfo'][0]['organisationid']) {
		if ($user['classification'] == "1" && $user['permission'] == "2" ) {
			$xml_params['editable'] = "1";
		} elseif ($user['classification'] = "2" && $user['permission'] > "2") {
			$xml_params['editable'] = "1";
		}
	}
	// get branch info 
	$xml_params['branchinfo'][0] = $new_branch->get_profile($params,$cfg,$conn);
	// update branch info
	if($params['update'] && !isset($params['error'])) {
		// check permissions
		if ($xml_params['editable']) {
		  	// not allowed to changed organisation
			unset($params['update']['organisation']);
			unset($params['update']['branch']);
		  	if ($xml_params['branchinfo'][0]['status'] === "0") {
		  		// branch already deleted
		  		$errors[] = "364";
		  	} elseif ($params['update']['status'] === "0") {
		  		// ensure that not deleting own organisation
		  		if ($user['branch'] == $params['id']) {
		  			// unset status
		  			unset($params['update']['status']);
		  			// Can not delete own branch
					$errors[] = "224";
		  		} else {
		  			// set the user that deleted as well as date
		  			$params['update']['deleted_by'] = $user['id'];
		  			$new_database = new database;
					$new_database->setTime("deleted",$params['update'],"",$cfg);
		  		}
		  	}
		  	// create where clause 
			$params['where'] = " id = ".$params['id']." ";
			if ($new_branch->update_branch($params,$cfg,$conn)) {
				if($params['update']['status'] != "0") {
					$xml_params['updated'] = "1";
					// repopulate the branch info
					$xml_params['branchinfo'][0] = $new_branch->get_profile($params,$cfg,$conn);
				} else {
					$xml_params['deleted'] = "1";
					$xml_params['editable'] = "0";
				}
			}
		} else {
			// unauthorised to edit
			$errors[] = "52";
		}
	}
	// determine if not administrator
	if ($user['classification'] != "3") { 
		// determine if viewing own organisation
		if ($user['organisation'] != $xml_params['branchinfo'][0]['organisation']) {
			// ensure that suppliers can only see companies and vice versa
			if ($xml_params['branchinfo'][0]['classification'] == "3" || $xml_params['branchinfo'][0]['classification'] == $user['classification']) {
				// not allowed to view information
				unset($xml_params);
				$errors[] = "359";
				// generate xml 
				$xml = $new_xml->xml_generator("branch","error",$errors,$xml_params,$user,$cfg);
			}
		}
	}
	// continue
	if ($xml_params) {
		if(!empty($new_branch->error)) {
			$errors = array_merge($errors,$new_branch->error);
		}
		if(!empty($params['error'])) {
			$errors = array_merge($errors,$params['error']);
		}
		// generate xml
		$xml = $new_xml->xml_generator("branch","profile",$errors,$xml_params,$user,$cfg);
	}
}
?>