<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Branch class
* @package TenderSystem
* @subpackage branch
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

Class branch {
	// paramaters
	var $branch;
	// errors 
	var $error;	
	
	function branch() {
		// allows merging to work for php5
		$this->error = array();	
	}

	// inserts an organisation into the database
	function create_branch($branch,$cfg,$conn){
		$this->branch = $branch;
		if (!$this->branch['name']){
			// missing branch name
			$this->error[] = "87";
		}
		if (!$this->branch['organisation']){
			// Missing organisation id
			$this->error[] = "78";
		}
		if(!$this->branch['created_by']) {
			// missing created by
			$this->error[] = "239";
		}
		// errors 
		if(!empty($this->error)){
			// error in branch class 
			$this->error[] = "219";
			return FALSE;
		}
		$new_database = new database;
		$table_name = "~organisation_branch";
		// no id 
		if(!$this->branch['id']) {
			// generate an id 
			$this->branch['id'] = $new_database->get_next_id($table_name,$cfg,$conn);
		}
		$new_database->setTime("created",$this->branch,"",$cfg);
		$new_database->parse_sql($table_name,$cfg);
		// create sql string 
		$conn->AutoExecute($table_name,$this->branch,"INSERT");
      	if ($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
      		// Error occurred while inserting into Database
			$this->error[] = "1064";
			// error in branch class 
			$this->error[] = "219";
			// response
			return FALSE;
      	}
		// resturn the id
		return $this->branch['id'];
	}
	
	function get_profile($params,$cfg,$conn){
		$this->branch = $params;
		// Check if main parameters exist 
		if (!$this->branch['id']){
			// missing branch id
			$this->error[] = "79";
		}
		// errors 
		if(!empty($this->error)){
			// error in branch class 
			$this->error[] = "219";
			return FALSE;
		}
		$sqlstr = "SELECT id AS branchid, name AS branchname, phone_work, ";
		$sqlstr.= "phone_prefix, phone_fax, email, ";
		$sqlstr.= "primary_address_street, primary_address_city, primary_address_state, ";
		$sqlstr.= "primary_address_postalcode, primary_address_country, alt_address_street, ";
		$sqlstr.= "alt_address_city, alt_address_state, alt_address_postalcode, ";
		$sqlstr.= "alt_address_country, status, branch_comment AS \"comment\", ";
		$sqlstr.= "created_date, created_time, created_by, ";
		$sqlstr.= "organisation ";
		$sqlstr.= "FROM ~organisation_branch ";
		$sqlstr.= "WHERE id = '".$this->branch['id']."' ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$row = $conn->GetRow($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg()." SQL:".$sqlstr;
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		} elseif(!$row) {
			// branch does not exist
			$this->error[] = "225";
			// error in branch class 
			$this->error[] = "219";
			// response
			return FALSE;
		}
		$new_database->convertSingleTime($row,$cfg);
		$new_organisation = new organisation;
		// get organisation info
		$org_info = $new_organisation->get_info($row['organisation'],$cfg,$conn);
		if(!$org_info) {
			if(!empty($new_organisation->error)) {
				$this->error = array_merge($this->error,$new_organisation->error);
			}
			// Error in Branch class 
			$this->error[] = "219";
			// response
			return FALSE;
		}
		$row['organisationname'] = $org_info['name'];
		$row['orgstatus'] = $org_info['status'];
		$row['organisationid'] = $org_info['id'];
		$row['transaction_fee'] = $org_info['transaction_fee'];
		$row['user_fee'] = $org_info['user_fee'];
		$row['sms_fee'] = $org_info['sms_fee'];
		$row['classification'] = $org_info['classification'];
		$new_user = new user;
		// get the creator info
		$creator = $new_user->get_info($row['created_by'],$cfg,$conn);
		if(!$creator) {
			if(!empty($new_user->error)) {
				$this->error = array_merge($this->error,$new_user->error);
			}
			// Error in Branch class 
			$this->error[] = "219";
			// response
			return FALSE;
		}
		$row['creatorid'] = $creator['id'];
		$row['creatorname'] = $creator['name'];
		$row['creatorsurname'] = $creator['surname'];
		return $row;
	}
	
	function search($params,$cfg,$conn) {
		$this->branch = $params;
		// sqlstr
		$sqlstr = "SELECT  branch.id AS branchid, branch.name AS branchname ";
		if($this->branch['searchinfo']['extrainfo']) {
			$sqlstr.= ", ~organisation.id AS organisationid, ";
			$sqlstr.= "branch.phone_work, branch.email, branch.status, branch.phone_prefix ";
		}
		$sqlstr.= "FROM ~organisation_branch branch, ~organisation ";
		$sqlstr.= "WHERE ~organisation.id = branch.organisation ";
		$sqlstr.= "AND branch.status = '1' ";
		if($this->branch['searchinfo']['branchid']) {
			$sqlstr.= "AND branch.id = '".$this->branch['searchinfo']['branchid']."' ";
		}
		if($this->branch['searchinfo']['organisationid']) {
			$sqlstr.= "AND branch.organisation = '".$this->branch['searchinfo']['organisationid']."' ";
		}
		if($this->branch['searchinfo']['searchvalue']) {
			$sqlstr.= "AND branch.name LIKE %".$this->branch['searchinfo']['searchvalue']."% ";
		}
		if($this->branch['searchinfo']['branchname']) {
			$sqlstr.= "AND branch.name = '".$this->branch['searchinfo']['branchname']."' ";
		}
		$sqlstr.= "ORDER BY branch.name ASC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// error in branch class 
			$this->error[] = "219";
			// response
			return FALSE;
		}
		if($this->branch['searchinfo']['extrainfo']) {
			$new_organisation = new organisation;
			// get organisation names
			foreach($all as $key => $value) {
				// get organisation info
				$org_info = $new_organisation->get_info($value['organisationid'],$cfg,$conn);
				if(!$org_info) {
					if(!empty($new_organisation->error)) {
						$this->error = array_merge($this->error,$new_organisation->error);
					}
					// Error in Branch class 
					$this->error[] = "219";
					// response
					return FALSE;
				}
				$all[$key]['organisationname'] = $org_info['name'];
			}	
		}
		return $all;
	}
	
	/*
	 * function removed rather use update_branch
	 *
	function delete_branch($id,$usersid,$cfg,$conn) {
		$new_database = new database;
		$update['status'] = "0";
		$update['deleted_by'] = $usersid;
		$new_database->setTime("deleted",$update,"",$cfg);
		$where = " id = ".$id." ";
		if(!$new_database->update_table("~organisation_branch",$update,$where,$cfg,$conn)) {
			if(!empty($new_database->error)) {
				$this->error = array_merge($this->error,$new_database->error);	
			}
			// Error in area Class
			$this->error[] = "240";
			return FALSE;
		} 
      	return TRUE;
	}
	*/
	
	function update_branch($params,$cfg,$conn) {
		$this->branch = $params;
		// Check if main parameters exist 
		if (!$this->branch['update']){
			// missing update information
			$this->error[] = "230";
		}
		// Check if main parameters exist 
		if (!$this->branch['where']){
			// missing where clause
			$this->error[] = "231";
		}
		// errors 
		if(!empty($this->error)){
			// error in branch class 
			$this->error[] = "219";
			return FALSE;
		}
		// the table name
		$table_name = "~organisation_branch";
		$new_database = new database;
		$new_database->parse_sql($table_name,$cfg);
		// execute
		$conn->AutoExecute($table_name,$this->branch['update'],"UPDATE",$this->branch['where']);
	    if ($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while updating information on database
			$this->error[] = "1066";
			// response
			return FALSE;
      	}
		// return that branch updated
      	return TRUE;
	}
	
	function get_info($params,$cfg,$conn) {
		if(is_numeric($params)) {
			$this->user['id'] = $params;
		} else {
			$this->user = $params;
		}
		// Check if main parameters exist 
		if (!$this->user['id']){
			// Missing branch id
			$this->error[] = "79";
		}
		// errors 
		if(!empty($this->error)){
			// Error in branch Class
			$this->error[] = "219";
			return FALSE;
		}
		$sqlstr = "SELECT * ";
		$sqlstr.= "FROM ~organisation_branch ";
		$sqlstr.= "WHERE id = ".$this->user['id']." "; 
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$row = $conn->GetRow($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $row;
	}
}
?>