<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Create category
* @package TenderSystem
* @subpackage category
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instatiate xml object
$new_xml = new xml;
// set the required type and permission required
$required['classification'] = "3";
$required['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} else {
	// include required file
	require($cfg['file'].'modules/category/class/category.class.php');
	require($cfg['file'].'modules/generic/class/file.class.php');
	// find extra category classification
	$new_file = new file;
	$xml_params['show'] = "0";
	$new_file->link_api_find("category","classification",$xml_params,$user,$cfg,$conn);
	// uploading category names
	if($params['category']) {
		// instantiate object
		$new_category = new category;
		// insert category_sub and categorys into database
		foreach($params['category'] as $category) {
			unset($info);
			$info['searchinfo']['categoryname'] = $category['name'];
			// if already exist category
			if($exist_category = $new_category->search($info,$cfg,$conn)) {
				$xml_params['exist_category'][]['name'] = $category['name'];
				$categoryid = $exist_category[0]['categoryid'];
				// go through each sub-category
				foreach($category['category_sub'] as $category_sub) {
					$info['searchinfo']['category_subname'] = $category_sub;
					$info['searchinfo']['categoryid'] = $categoryid;
					// if already exist sub category
					if($exist_category_sub = $new_category->search_sub($info,$cfg,$conn)) {
						$xml_params['exist_category_sub'][]['name'] = $category_sub;
					}
					// if new sub category
					else {
						$insertcategory_sub['name'] = $category_sub;
						$insertcategory_sub['category'] = $categoryid;
						$insertcategory_sub['status'] = "1";
						if($new_category->create_category_sub($insertcategory_sub,$cfg,$conn)) {
							$xml_params['category_sub'][] = $insertcategory_sub;
						}
					}
				}
			} 
			// if new category
			else {
				$insert['name'] = $category['name'];
				if(is_numeric($params['categorytype'])) {
					$insert['classification'] = $params['categorytype'];
				} else {
					// set to default classification
					$insert['classification'] = $cfg['default']['classification'];
				}
				$insert['status'] = "1";
				if($categoryid = $new_category->create_category($insert,$cfg,$conn)) {
					$xml_params['category'][] = $insert;
					// go through each sub-category
					if(is_array($category['category_sub'])) {
						foreach($category['category_sub'] as $category_sub) {
							$insertcategory_sub['name'] = $category_sub;
							$insertcategory_sub['category'] = $categoryid;
							$insertcategory_sub['status'] = "1";
							if($new_category->create_category_sub($insertcategory_sub,$cfg,$conn)) {
								$xml_params['category_sub'][] = $insertcategory_sub;
							}
						}
					}
				}
			}
			$xml_params['created'] = "1";
		}
		if(!empty($new_category->error)) {
			$errors = array_merge($errors,$new_category->error);
		}
		$xml = $new_xml->xml_generator("category","create",$errors,$xml_params,$user,$cfg);
	} elseif($params['genericapp']) {
		// get the file into a string
 		$xml_content = file_get_contents($cfg['file']."modules/category/language/".$user['language']."/".$params['genericapp'].".xml");
		// create parser
		$xml_parser = xml_parser_create();
		// parse xml into $xml_array
		$good_parse = xml_parse_into_struct($xml_parser, $xml_content, $xml_array, $index);
		// free parser
		xml_parser_free($xml_parser);
		if(!$xml_content) {
			// Cannot open file
			$errors[] = "77";
			// generate xml 
			$xml = $new_xml->xml_generator("category","create",$errors,$xml_params,$user,$cfg);
		} elseif(!$good_parse) {
			// Could not parse information
			$errors[] = "265";
			// generate xml 
			$xml = $new_xml->xml_generator("category","create",$errors,$xml_params,$user,$cfg);
		} else {
			// status of category
			$insert['category']['status'] = "1";
			// get information from xml_array
			foreach($xml_array as $value) {
				// category id
				if(strtolower($value['tag']) == "id" && $value['level'] == "2") {
					$insert['category']['id'] = $value['value'];
				}
				// category name
				if(strtolower($value['tag']) == "name" && $value['level'] == "2") {
					$insert['category']['name'] = $value['value'];
				}
				// category type
				if(strtolower($value['tag']) == "classification" && $value['level'] == "2") {
					$insert['category']['classification'] = $value['value'];
				}
				// category_sub start id and sub category start
				if(strtolower($value['tag']) == "category_sub" && $value['level'] == "2" && $value['type'] == "open") {
					$category_sub_id  = $value['attributes']['START_ID'];
					$in_categroy_sub = TRUE;
				}
				// sub category name
				if(strtolower($value['tag']) == "name" && $value['level'] == "3" && $in_categroy_sub) {
					$category_sub['id'] = $category_sub_id++;
 					$category_sub['name'] = trim($value['value']);
					$category_sub['status'] = "1";
					$insert['category_sub'][] = $category_sub;
				}
				// sub category end
				if(strtolower($value['tag']) == "category_sub" && $value['level'] == "2" && $value['type'] == "close") {
					$in_categroy_sub = FALSE;
				}
				// category brands start
				if(strtolower($value['tag']) == "brand" && $value['level'] == "2" && $value['type'] == "open") {
					$in_brand = TRUE;
				}
				// category brands
				if(strtolower($value['tag']) == "name" && $value['level'] == "3" && $in_brand) {
 					$insert['category_brand'][] = trim($value['value']);
				}
				// category brands end
				if(strtolower($value['tag']) == "brand" && $value['level'] == "2" && $value['type'] == "close") {
					$in_brand = FALSE;
				}	
			}
			// instantiate object
			$new_category = new category;
			// insert category_sub and categorys into database
			$info['searchinfo']['categoryname'] = $insert['category']['name'];
			if($exist_category = $new_category->search($info,$cfg,$conn)) {
				// Already exists
				$xml_params['exist_category'][]['name'] = $insert['category']['name'];
			} else {
				// insert category
				if($categoryid = $new_category->create_category($insert['category'],$cfg,$conn)) {
					$xml_params['category'][] = $insert['category'];
					if($insert['category_sub']) {
						// insert the sub categories
						foreach($insert['category_sub'] as $category_sub) {
							$category_sub['category'] = $categoryid;
							// insert a sub category
							if($new_category->create_category_sub($category_sub,$cfg,$conn)) {
								$xml_params['category_sub'][] = $category_sub;
							}
						}
					}
					if($insert['category_brand']) {
						// insert the category_brands
						foreach($insert['category_brand'] as $brand) {
							$brandinfo['searchinfo']['brandname'] = $brand;
							$result = $new_category->search_brand($brandinfo,$cfg,$conn);
							// check if brand exist
							if($result) {
								$brandid = $result[0]['brandid'];
							} else {
								// create the brand
								$insertbrand['name'] = $brand;
								$insertbrand['status'] = "1";
								$brandid = $new_category->create_brand($insertbrand,$cfg,$conn);
								$xml_params['brand'][]['name'] = $brand;
							}
							// link brand and category
							$new_category->create_category_brand($categoryid,$brandid,$cfg,$conn);
						}
					}
				}
				$xml_params['created'] = "1";
			}
			if(!empty($new_category->error)) {
				$errors = array_merge($errors,$new_category->error);
			}
			$xml = $new_xml->xml_generator("category","create",$errors,$xml_params,$user,$cfg);
		}
	} else{
		// instantiate objects
		$new_category = new category;
		$new_file = new file;
		// no uploads to show
		$xml_params['show'] = 0;
		$folder = "modules/category/language/".$user['language'];
		if(file_exists($cfg['file']."/".$folder)) {
			$files = $new_file->read_folder($folder,$cfg);		
		}
		if($files) {
			foreach ($files as $file) {
				if(substr(strrchr($file, "."), 1) == "xml") {
					$xml_content = file_get_contents($cfg['file']."/".$folder."/".$file);
					// create parser
					$xml_parser = xml_parser_create();
					// parse xml into $xml_array
					$good_parse = xml_parse_into_struct($xml_parser, $xml_content, $xml_array, $index);
					// free parser
					xml_parser_free($xml_parser);
					$info['searchinfo']['categoryid'] = "0";
					if($good_parse) {
						// get information from xml_array
						foreach($xml_array as $value) {
							// category id
							if(strtolower($value['tag']) == "id" && $value['level'] == "2") {
								$info['searchinfo']['categoryid']  = $value['value'];
								break;
							}
						}
						// check if already uploaded
						if($info['searchinfo']['categoryid'] && !$new_category->search($info,$cfg,$conn)) {
							// set files in an array
							$xml_params['genericapp'][] = basename($file, ".xml");
						}
					}
				}
			}
		}
		// generate xml 
		$xml = $new_xml->xml_generator("category","create",$new_file->error,$xml_params,$user,$cfg);
	}
}
?>