<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Create brand
* @package TenderSystem
* @subpackage category
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// set the required type and permission required
$required[0]['classification'] = "3";
$required[0]['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} else {
	// instatiate xml object
	$new_xml = new xml;
	$xml_params['show'] = "0";
	if($params['brandnames']) {
		// include required file
		include($cfg['file'].'modules/category/class/category.class.php');
		// instantiate object
		$new_brand = new category;
		// insert category_sub and categorys into database
		foreach($params['brandnames'] as $brand) {
			$info['searchinfo']['brandname'] = $brand;
			if($exist_brand = $new_brand->search_brand($info,$cfg,$conn)) {
				// Already exists
				$xml_params['exist_brand'][]['name'] = $exist_brand[0]['brandname'];
			} else {
				$insert['name'] = $brand;
				$insert['status'] = "1";
				if($new_brand->create_brand($insert,$cfg,$conn)) {
					$xml_params['brand'][] = $insert;
					$xml_params['created'] = "1";
				}
			}
		}
		if(!empty($new_brand->error)) {
			$errors = array_merge($errors,$new_brand->error);
		}
		$xml = $new_xml->xml_generator("category","create_brand",$errors,$xml_params,$user,$cfg);
	} else{
		// generate xml 
		$xml = $new_xml->xml_generator("category","create_brand",$new_file->error,$xml_params,$user,$cfg);
	}
}
?>