<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Show brand
* @package TenderSystem
* @subpackage category
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required[0]['classification'] = "3";
$required[0]['permission'] = "all";
// or
$required[1]['classification'] = "1";
$required[1]['permission'] = "4";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} else{
	// include files
	require($cfg['file'].'modules/category/class/category.class.php');
	$new_category = new category;
	// get brands
	$xml_params['brand'] =$new_category->all_brands($cfg,$conn);
	// brand max id
	foreach($xml_params['brand'] as $category) {
		$xml_params['brandmax'] = max($xml_params['brandmax'],$category['brandid']);
	}
	$params['searchinfo']['categoryid'] = $params['categoryid'];
	// get selected categorys
	$xml_params['selectedbrand'] =$new_category->search_brand($params,$cfg,$conn);
	if(empty($new_category->error) && $params['action']) {
		if(is_array($params['check'])) {
			$check = $params['check'];
		} else {
			$check = array();
		}
		$old_check = array();
		// get what is currently selected
		if ($xml_params['selectedbrand']) {
			foreach($xml_params['selectedbrand'] as $selectedbrand) {
				$old_check[$selectedbrand['brandid']] = $selectedbrand['categorybrandid'];
			}
		}
		
		// was not checked but is now checked
		foreach($check as $key => $value) {
			if(!$old_check[$key]) {
				if($new_category->create_category_brand($params['categoryid'],$key,$cfg,$conn)) {
					$xml_params['updated'] = "1";
				}
			}
		}
		// was checked but is now not checked
		foreach($old_check as $key => $value) {
			if(!$check[$key]) {
				if($new_category->delete_category_brand($value,$user['id'],$cfg,$conn)) {
					$xml_params['updated'] = "1";
				}
			}
		}
		// get selected categorys again
		$xml_params['selectedbrand'] =$new_category->search_brand($params,$cfg,$conn);
	}
	$xml_params['categoryid']	= $params['categoryid'];
	// generate xml
	$xml = $new_xml->xml_generator("category","show_brand",$new_category->error,$xml_params,$user,$cfg);
}
?>