<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Category class
* @package TenderSystem
* @subpackage category
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

Class category {
	// set the paramaters
	var $category;
	var $subcategory;
	var $brand;
	var $error;
	
	function category() {
		// allow php5 to work
		$this->error = array();	
	}
	
	function create_category($insert,$cfg,$conn){
		$this->category = $insert;
		if (!$this->category['name']){
			// Missing category name
			$this->error[] = "245";
		}
		if (!$this->category['classification']){
			// Missing category type
			$this->error[] = "246";
		}
		if(!empty($this->error)){
			// Error in category class
			$this->error[] = "247";
			return FALSE;
		}
		$new_database = new database;
		$table_name = "~category";
		if(!$this->category['id']) {
			// generate an id
			// keep the first 1000 categories for generic categories 
			$this->category['id'] = $new_database->get_next_id($table_name,$cfg,$conn,1000);
		}
		$new_database->setTime("created",$this->category,"",$cfg);
		$new_database->parse_sql($table_name,$cfg);
		// insert or replace
		$conn->Replace($table_name,$this->category,"id",TRUE);
      	if ($conn->ErrorMsg()) {
      		$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
      		// Error occurred while inserting into Database
			$this->error[] = "1064";
			// response
			return FALSE;
      	} 
      	// resturn the id
		return $this->category['id'];
	}
	
	function create_brand($insert,$cfg,$conn){
		$this->category = $insert;
		if (!$this->category['name']){
			// Missing brand name
			$this->error[] = "250";
		}
		if(!empty($this->error)){
			// Error in category class
			$this->error[] = "247";
			return FALSE;
		}
		$new_database = new database;
		$table_name = "~brand";
		if(!$this->category['id']) {
			// generate an id
			// keep the first 1000 brands for generic brands 
			$this->category['id'] = $new_database->get_next_id($table_name,$cfg,$conn,1000);
		}
		$new_database->setTime("created",$this->category,"",$cfg);
		$new_database->parse_sql($table_name,$cfg);
		// extcute sql insert
		$recordSet = $conn->AutoExecute($table_name,$this->category,"INSERT");
      	if ($conn->ErrorMsg()) {
      		$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
      		// Error occurred while inserting into Database
			$this->error[] = "1064";
			// response
			return FALSE;
      	} 
      	// resturn the id
		return $this->category['id'];
	}
	
	function create_category_sub($insert,$cfg,$conn){
		$this->category = $insert;
		if (!$this->category['name']){
			// Missing category name
			$this->error[] = "245";
		}
		if (!$this->category['category']){
			// Missing category id
			$this->error[] = "248";
		}
		if(!empty($this->error)){
			// Error in category class
			$this->error[] = "247";
			return FALSE;
		}
		$new_database = new database;
		$table_name = "~category_sub";
		if(!$this->category['id']) {
			// generate an id
			// keep the first 1000 subcategories for generic sub categories 
			$this->category['id'] = $new_database->get_next_id($table_name,$cfg,$conn,1000);
		}
		$new_database->setTime("created",$this->category,"",$cfg);
		$new_database->parse_sql($table_name,$cfg);
		// insert or replace
		$conn->Replace($table_name,$this->category,"id",TRUE);
      	if ($conn->ErrorMsg()) {
      		$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
      		// Error occurred while inserting into Database
			$this->error[] = "1064";
			// response
			return FALSE;
      	} 
      	// resturn the id
		return $this->category['id'];
	}
	
	function search($params,$cfg,$conn) {
		$this->category = $params;
		// sqlstr
		$sqlstr = "SELECT ~category.id AS categoryid, ~category.name AS categoryname ";
		$sqlstr.= "FROM ~category ";
		if(isset($this->category['searchinfo']['categorystatus'])) {
			$sqlstr.= "WHERE ~category.status = ".$this->category['searchinfo']['categorystatus']." ";
		} else {
			$sqlstr.= "WHERE ~category.status = '1' ";
		}
		if($this->category['searchinfo']['searchvalue']) {
			$sqlstr.= "AND upper(~category.name) LIKE '%".strtoupper($this->category['searchinfo']['searchvalue'])."%' ";
		}
		if($this->category['searchinfo']['categoryname']) {
			$sqlstr.= "AND ~category.name = '".$this->category['searchinfo']['categoryname']."' ";
		}
		if($this->category['searchinfo']['categoryid']) {
			$sqlstr.= "AND ~category.id =".$this->category['searchinfo']['categoryid']." ";
		}
		if($this->category['searchinfo']['categorytype']) {
			$sqlstr.= "AND ~category.classification =".$this->category['searchinfo']['categorytype']." ";
		}
		$sqlstr.= "ORDER BY upper(~category.name) ASC, ~category.id ASC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $all;
	}
	
	function search_sub($params,$cfg,$conn) {
		$this->category = $params;
		// sqlstr
		$sqlstr = "SELECT subcategory.id AS subcategoryid, subcategory.name AS subcategoryname, ~category.id AS categoryid ";
		$sqlstr.= "FROM ~category, ~category_sub subcategory ";
		$sqlstr.= "WHERE subcategory.status = '1' AND ~category.status = '1' ";
		$sqlstr.= "AND ~category.id = subcategory.category ";
		if($this->category['searchinfo']['categoryid']) {
			$sqlstr.= "AND ~category.id = ".$this->category['searchinfo']['categoryid']." ";
		}
		if($this->category['searchinfo']['categorytype']) {
			$sqlstr.= "AND ~category.classification = ".$this->category['searchinfo']['categorytype']." ";
		}
		if($this->category['searchinfo']['searchvalue']) {
			$sqlstr.= "AND upper(subcategory.name) LIKE '%".strtoupper($this->category['searchinfo']['searchvalue'])."%' ";
		}
		if($this->category['searchinfo']['category_subname']) {
			$sqlstr.= "AND subcategory.name = '".$this->category['searchinfo']['category_subname']."' ";
		}
		$sqlstr.= "ORDER BY upper(subcategory.name) ASC, subcategory.id ASC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $all;
	}
	
	function all_brands($cfg,$conn) {
		// sqlstr
		$sqlstr = "SELECT DISTINCT ~brand.id AS brandid, ~brand.name AS brandname  ";
		$sqlstr.= "FROM ~brand ";
		$sqlstr.= "WHERE ~brand.status = '1' ";
		$sqlstr.= "ORDER BY ~brand.name ASC, ~brand.id ASC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $all;
	}
	
	function search_brand($params,$cfg,$conn) {
		$this->category = $params;
		// sqlstr
		$sqlstr = "SELECT DISTINCT ~brand.id AS brandid, ~brand.name AS brandname,  ";
		$sqlstr.="~category_brand.id AS categorybrandid, ~category_brand.category ";
		$sqlstr.= "FROM ~brand , ~category_brand ";
		$sqlstr.= "WHERE ~brand.status = '1' ";
		$sqlstr.="AND ~category_brand.brand = ~brand.id ";
		$sqlstr.="AND ~category_brand.status = '1' ";
		if($this->category['searchinfo']['categoryid']) {
			$sqlstr.="AND ~category_brand.category = ".$this->category['searchinfo']['categoryid']." ";
		}
		if($this->category['searchinfo']['searchvalue']) {
			$sqlstr.= "AND upper(~brand.name) LIKE %".strtoupper($this->category['searchinfo']['searchvalue'])."% ";
		}
		if($this->category['searchinfo']['brandname']) {
			$sqlstr.= "AND upper(~brand.name) = '".strtoupper($this->category['searchinfo']['brandname'])."' ";
		}
		$sqlstr.= "ORDER BY ~brand.name ASC, ~brand.id ASC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $all;
	}
	
	function delete_category($id,$usersid,$cfg,$conn) {
		$new_database = new database;
		// set update info 
		$update['deleted_by'] = $usersid;
		$update['status'] = "0";
		// create where clause 
		$where = " id = ".$id." ";
		$new_database->setTime("deleted",$update,"",$cfg);
		if(!$new_database->update_table("~category",$update,$where,$cfg,$conn)) {
			if(!empty($new_database->error)) {
				$this->error = array_merge($this->error,$new_database->error);
			}
			// Error in Category Class
			$this->error[] = "247";
			return FALSE;
		}
		// response
      	return TRUE;
	}
	
	function delete_category_sub($id,$usersid,$cfg,$conn) {		
		$new_database = new database;
		$update['status'] = "0";
		$update['deleted_by'] = $usersid;
		$new_database->setTime("deleted",$update,"",$cfg);
		$where = "id = ".$id;
		if(!$new_database->update_table("~category_sub",$update,$where,$cfg,$conn)) {
			if(!empty($new_database->error)) {
				$this->error = array_merge($this->error,$new_database->error);
			}
			// Error in Category Class
			$this->error[] = "247";
			return FALSE;
		} 
		// return that category_brand deleted
      	return TRUE;
	}
	
	function delete_brand($id,$usersid,$cfg,$conn) {		
		$new_database = new database;
		$update['status'] = "0";
		$update['deleted_by'] = $usersid;
		$new_database->setTime("deleted",$update,"",$cfg);
		$where = "id = ".$id;
		if(!$new_database->update_table("~brand",$update,$where,$cfg,$conn)) {
			if(!empty($new_database->error)) {
				$this->error = array_merge($this->error,$new_database->error);
			}
			// Error in Category Class
			$this->error[] = "247";
			return FALSE;
		} 
		// return that category_brand deleted
      	return TRUE;
	}

	function create_category_brand($category,$brand,$cfg,$conn){
		if (!$category){
			// Missing category id
			$this->error[] = "248";
		}
		if (!$brand){
			// Missing brand id
			$this->error[] = "266";
		}
		if(!empty($this->error)){
			// Error in category class
			$this->error[] = "247";
			return FALSE;
		}
		$new_database = new database;
		$table_name = "~category_brand";
		// generate an id 
		$insert['id'] = $new_database->get_next_id($table_name,$cfg,$conn);
		$insert['brand'] = $brand;
		$insert['category'] = $category;
		$insert['status'] = "1";
		$new_database->setTime("created",$insert,"",$cfg);
		$new_database->parse_sql($table_name,$cfg);
		// insert or replace
		$conn->Replace($table_name,$insert,"id",TRUE);
		if ($conn->ErrorMsg()) {
			$new_error = new error;
				$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
				$new_error->log("SQL","critical",$error_text,$cfg);
				// Error occurred while inserting into Database
				$this->error[] = "1064";
				// response
				return FALSE;
		} 
		// return the id
		return $insert['id'];
	}

	function delete_category_brand($id,$usersid,$cfg,$conn) {		
		$new_database = new database;
		$update['status'] = "0";
		$update['deleted_by'] = $usersid;
		$new_database->setTime("deleted",$update,"",$cfg);
		$where = "id = ".$id;
		if(!$new_database->update_table("~category_brand",$update,$where,$cfg,$conn)) {
			if(!empty($new_database->error)) {
				$this->error = array_merge($this->error,$new_database->error);
			}
			// Error in Category Class
			$this->error[] = "247";
			return FALSE;
		} 
		// return that category_brand deleted
      	return TRUE;
	}
	
	/**
	 * Get information about tender item
	 * 
	 * @param array id tender_item ID
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed array of tenders quotes or FALSE on error  
	 */
	function get_category($id,$cfg,$conn) {
		if(!$id) {
			// Missing tender item id
			$this->error[] = "273";
		}
		// errors 
		if(!empty($this->error)) {
			$this->error[] = "317";
			// reponse
			return FALSE;
		}
		$sqlstr = "SELECT *  ";
		// FROM
		$sqlstr.= "FROM ~category ";
		// WHERE
		$sqlstr.= "WHERE status = 1 ";
		$sqlstr.= "AND id = '".$id."' ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$row = $conn->GetRow($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $row;
	}
	
	/**
	 * Get information about tender item
	 * 
	 * @param array id tender_item ID
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed array of tenders quotes or FALSE on error  
	 */
	function get_category_name($id,$cfg,$conn) {
		if(!$id) {
			// Missing tender item id
			$this->error[] = "273";
		}
		// errors 
		if(!empty($this->error)) {
			$this->error[] = "317";
			// reponse
			return FALSE;
		}
		$sqlstr = "SELECT name  ";
		// FROM
		$sqlstr.= "FROM ~category ";
		// WHERE
		$sqlstr.= "WHERE status = 1 ";
		$sqlstr.= "AND id = '".$id."' ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$one = $conn->GetOne($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $one;
	}
	
	/**
	 * Get information about tender item
	 * 
	 * @param array id tender_item ID
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed array of tenders quotes or FALSE on error  
	 */
	function get_category_sub_name($id,$cfg,$conn) {
		if(!$id) {
			// Missing tender item id
			$this->error[] = "273";
		}
		// errors 
		if(!empty($this->error)) {
			$this->error[] = "317";
			// reponse
			return FALSE;
		}
		$sqlstr = "SELECT name  ";
		// FROM
		$sqlstr.= "FROM ~category_sub ";
		// WHERE
		$sqlstr.= "WHERE status = 1 ";
		$sqlstr.= "AND id = '".$id."' ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$one = $conn->GetOne($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $one;
	}
	
	/**
	 * Get information about tender item
	 * 
	 * @param array id tender_item ID
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed array of tenders quotes or FALSE on error  
	 */
	function get_category_sub($id,$cfg,$conn) {
		if(!$id) {
			// Missing tender item id
			$this->error[] = "273";
		}
		// errors 
		if(!empty($this->error)) {
			$this->error[] = "317";
			// reponse
			return FALSE;
		}
		$sqlstr = "SELECT *  ";
		// FROM
		$sqlstr.= "FROM ~category_sub ";
		// WHERE
		$sqlstr.= "WHERE status = 1 ";
		$sqlstr.= "AND id = '".$id."' ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$row = $conn->GetRow($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $row;
	}
}
?>