<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Display attachment
* @package TenderSystem
* @subpackage generic
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// set the user language
$user['language'] = $params['language'];
// instantiate the xml object
$new_xml = new xml;
// load required files
require($cfg['file'].'modules/generic/class/file.class.php');
if ($params["user_id"] && $params["id"] && $params["authentication"]/* && $params["ip"]*/) {
	$new_file = new file;
	$display_file = $new_file->file_display($params,$cfg,$conn);
	// determine if successfull
	if($display_file) {
		// generate xml -> set to error so that if header cannot be found will display error
		$xml = $new_xml->xml_generator("generic","error",$new_file->error,$display_file,$user,$cfg);
	} else {
		// log the error - they will only be displayed if an error occurs
		$new_error = new error;
		$error_text = "Unauthorised file display requested for attachment ID:".$params["id"]." from IP:".$params["ip"]." using user ID:".$params["user_id"]."."; 
		$new_error->log("FILE","serious",$error_text,$cfg);
		// incorrect information to display the required file
		$error[] = "293";
		// generate xml 
		$xml = $new_error->response_xml($error,$user,$cfg);
	}
} else {
	// log the error
	$new_error = new error;
	$error_text = "Insufficient information provided for file display requested for attachment ID:".$params["id"]." from IP:".$params["ip"]." using user ID:".$params["user_id"]."."; 
	$new_error->log("FILE","serious",$error_text,$cfg);
	// insufficient information to display the required file
	$error[] = "292";
	// generate xml 
	$xml = $new_error->response_xml($error,$user,$cfg);
}

?>