<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Message API
* @package TenderSystem
* @subpackage generic
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required['classification'] = "3";
$required['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} elseif(is_array($params['error'])) {
	// generate xml 
	$xml = $new_xml->xml_generator("report","show_tender_item",$params['error'],"",$user,$cfg);
} else {
	// load required files
	require($cfg['file'].'modules/generic/class/message.class.php');
	if ($params["id"]) {
		$new_message = new message;
		$display_file = $new_message->message_display($params,$cfg,$conn);
		// determine if successfull
		if($display_file) {
			// set unknown error
			$error[] = "2";
			$error[] = "1";
			// generate xml -> set to error so that if header cannot be found will display error
			$xml = $new_xml->xml_generator("generic","error",$error,$display_file,$user,$cfg);
		} else {
			// log the error - they will only be displayed if an error occurs
			$new_error = new error;
			$error_text = "Unauthorised file display requested for attachment ID:".$params["id"]." from IP:".$params["ip"]." using user ID:".$params["user_id"]."."; 
			$new_error->log("FILE","serious",$error_text,$cfg);
			// incorrect information to display the required file
			$error[] = "293";
			// generate xml 
			$xml = $new_error->response_xml($error,$user,$cfg);
		}
	} else {
		// log the error
		$new_error = new error;
		$error_text = "Insufficient information provided for message display requested for message ID:".$params["id"]; 
		$new_error->log("FILE","serious",$error_text,$cfg);
		// insufficient information to display the required file
		$error[] = "292";
		// generate xml 
		$xml = $new_error->response_xml($error,$user,$cfg);
	}
}
?>