<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Message API
* @package TenderSystem
* @subpackage generic
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// load required files
require($cfg['file'].'modules/generic/class/message.class.php');
if ($params["receipt_code"]) {
	$new_message = new message;
	$id = $new_message->check_receipt($params["receipt_code"],$cfg,$conn);
	if($id) {
		if(!$params["receipt_ip"]) {
			$params["receipt_ip"] = "0.0.0.0";
		}
		$new_message->update_receipt_status($id,$params["receipt_ip"],$params["status"],$cfg,$conn);
	} else {
		// instantiate the error class and log
		$new_error = new error;
		// convert error message
		require($cfg['file']."modules/generic/language/".$cfg['language']."/error.php");
		// SMS application error:
		$error_text[] = $lang['361']." ".$params["receipt_code"];
		// log the error
		$new_error->log("Message","warning",$error_text,$cfg);	
	}
}
$xml = "<response>Nothing</response>"
?>