<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Resend messages
* @package TenderSystem
* @subpackage generic
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// only administrator
$required[0]['classification'] = "3";
$required[0]['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($type,$permission,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} else {
	require($cfg['file'].'modules/generic/class/message.class.php');
	require($cfg['file'].'modules/external/class/smtp/htmlMimeMail.php');
	$new_message = new message;
	$info = $new_message->message_display($params,$cfg,$conn);
	$message['subject'] = $info['subject'];
	$message['body'] = $info['body'];
	$message['name'] = $info['name'];
	if($params['email']) {
		$message['email'] = $params['email'];
	} else {
		$message['email'] = $info['email'];
	}
	$message['classification'] = $info['classification'];
	$message['reference'] = $info['reference'];
	if($params['phone_mobile']) {
		$message['phone_mobile'] = $params['phone_mobile'];
	} else {
		$message['phone_mobile'] = $info['phone_mobile'];
	}
	if($info['send_method'] == "email") {
		$result = $new_message->send_email_message($message,$user['id'],$user['id'],$cfg,$conn);
	} elseif($info['send_method'] == "sms") {
		$result = $new_message->send_sms_message($message,$user['id'],$user['id'],$cfg,$conn);
	} 
	// send the email
	if (!$result) {
		// Message errors 
		$error = $new_message->error;
		// Error sending email
		$error = "202";
		$xml = $new_xml->xml_generator( "generic", "error",$error,"",$user,$cfg);
	} else {
		$xml = $new_xml->xml_generator( "generic", "error",$error,"",$user,$cfg);
	}
}

?>