<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Error class
* @package TenderSystem
* @subpackage generic
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

Class error {
	// set the paramaters
	
    function log($type,$status,$text,$cfg) {
		// set the date
        $now = date("j-m-Y H:i:s");
		// determine if text is an array
		if (is_array($text)) {
			foreach ($text as $value) {
				$error_text.= $value;			
			}
		} else {
			$error_text = $text;		
		}
		// set the message to log
        $error_text = str_pad($now,22).str_pad($type,10).str_pad($status,10).$error_text.chr(13).chr(10);
		// set the error path
		$error_file = $cfg['error']['file'];
		// determine if dynamic path
		if (substr($error_file,0,1) == ".") {
			// set complete path
			$error_file = $cfg['file'].substr($error_file,1);
		}
        // log the error
        error_log($error_text,3,$error_file);
		// determine if email must be sent
		if ($cfg['error']['email'] == "all") {
			// send email
			$send_error_mail = TRUE;
		} elseif ($cfg['error']['email'] == "critical") {
			if ($status == "critical") {
				// send email
				$send_error_mail = TRUE;
			}
		} elseif ($cfg['error']['email'] == "serious") {
			if ($status == "serious" || $status == "critical") {
				// send email
				$send_error_mail = TRUE;
			}
		}
		// send email if required
		if ($send_error_mail) {
			// header
			$email_header = "TenderSystem ".$status." error";
			// header
			$email_header = "TenderSystem ".$status." error";
			// send error mail
			// use mail as error_lg ads an additional header which is not allowed in safe_mode
			mail($cfg['smtp']['support']['email'], $email_header, $error_text);
		}
		// response
		return TRUE;
    } 
	
	function response_xml($error,$user,$cfg) {
		// determine if it is a session error
		if ($cfg['error']['session']) {
			// set paramaters
			$paramaters['sessionexpire'] = "true";
		}
		// insert error code
		if (!$error) {
			// set unknown error
			$error[] = "2";
			$error[] = "1";
		}
		// instantiate xml object
		$new_xml = new xml;
		$xml = $new_xml->xml_generator("generic","error",$error,$paramaters,$user,$cfg);
		// determine if the request was via api or included
		if ($cfg['api']['connection'] == 'module') {
			// return the xml
			return $xml;
		} else {
			// set the header information
			header("Content-type: text/xml");
			// return response xml
			echo $xml;
			// die
			die();
		}			
	}
}
?>