<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* POP class
* @package TenderSystem
* @subpackage generic
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

class pop {
    var $count;
    var $email;
	var $response;
	var $error;

    function retrieve($cfg) {
		// determine if pop is active
		if ($cfg['pop']['status']) {
			// open the connection
	        $this->connection = fsockopen($cfg['pop']['server'],$cfg['pop']['port'],$errno,$errstr,30);
			// connection could not be established
	        if (!$this->connection){
				// log that pop status not set
				$this->response['error'] = "POP connection could not be established. POP server is down or incorrect server and port settings.";
				$this->response['error'].= "Error number:".$errno." Error".$errstr;
				$new_error = new error;
				$new_error->log("POP","critical",$this->response['error'],$cfg);
				// response
				return FALSE;
	        }
			$output = fgets($this->connection,128);
			// submit username
			$username = $cfg['pop']['tender']['username'];
			fputs($this->connection, "user $username\r\n");
			$output = fgets($this->connection,128);
			if (substr($output,0,1) != "+") {
				// close the socket connection
				fclose($this->connection);
				// log that pop status not set
				$this->response['error'] = "Invalid POP username. Change username in POP settings if valid email username. POP response:".str_replace("\r\n","",$output);
				$new_error = new error;
				$new_error->log("POP","critical",$this->response['error'],$cfg);
				// response
				return FALSE;
			}
			// submit password
			$password = $cfg['pop']['tender']['password'];
			fputs($this->connection, "pass $password\r\n");
			$output = fgets($this->connection,128);
			if (substr($output,0,1) != "+") {
				// close the socket connection
				fclose($this->connection);
				// log that pop status not set
				$this->response['error'] = "POP response:".str_replace("\r\n","",$output);
				$new_error = new error;
				$new_error->log("POP","critical",$this->response['error'],$cfg);
				// response
				return FALSE;
			}
			// find out how many email have to be parsed
			fputs($this->connection, "stat\r\n");
			$output = fgets($this->connection,1024);
			list($response, $this->count, $size) = split(" ", $output);
			if ($this->count == 0) {
				// close the POP connection
				fputs($this->connection, "quit\r\n");
				// close the socket connection
				fclose($this->connection);
				// set that there are no emails to process
				$this->response['emails'] = "No emails to process.";
				// response
				return FALSE;
			} else {
				// set that there are no emails to process
				$this->response['emails'] = $this->count." emails to parse.";
			}
			// loop through emails and set data
			for ($i = 1; $i < $this->count+1; $i++) {
				// retrive the mail
				fputs($this->connection, "retr $i\r\n");
				$output = fgets($this->connection,1024);
				if (substr($output,0,1) != "+") {
					// close the socket connection
					fclose($this->connection);
					// log that pop status not set
					$this->response['error'] = "Error occurred while retrieving mail number: ".$i." POP response:".str_replace("\r\n","",$output);
					$new_error = new error;
					$new_error->log("POP","critical",$this->response['error'],$cfg);
					// response
					return FALSE;
				}
				// set the email
				while ($output = fgets($this->connection,1024)) {
					if( (substr($output,0,1)  ==  ".") && (strlen(trim($output)) == 1) ) {
			            break;
			        }
			        $this->email[$i-1].= $output;
			    }
			}
			// response
	        return TRUE;
		} else {
			// log that pop status not set
			$error_text = "POP server status is inactive. Please activate in POP settings.";
			$new_error = new error;
			$new_error->log("POP","critical",$error_text,$cfg);
			// response
			return FALSE;
		}
    }
	
	function delete_mail($i) {
		// delete the email
		fputs($this->connection, "dele $i\r\n");
		// determine if deleted successfully
		$output = fgets($this->connection,1024);
		if (substr($output,0,1) != "+") {
			// log that pop status not set
			$this->response['error'] = "An error occcured while deleting the email number:".$i."POP response:".str_replace("\r\n","",$output);
			$new_error = new error;
			$new_error->log("POP","critical",$this->response['error'],$cfg);
			// response
			return FALSE;
		}
	}
	
	function close_connection() {
		// close the POP connection
		fputs($this->connection, "quit\r\n");
		// determine if deleted successfully
		$output = fgets($this->connection,1024);
		if (substr($output,0,1) != "+") {
			// log that pop status not set
			$this->response['error'] = "An error occcured while closing connection. POP response:".str_replace("\r\n","",$output);
			$new_error = new error;
			$new_error->log("POP","critical",$this->response['error'],$cfg);
			// response
			return FALSE;
		}
		// close the socket connection
		fclose($this->connection);
	}
}
?>