<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Security class
* @package TenderSystem
* @subpackage generic
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

Class security {
	// set paramaters
	var $error;
	
	function validate_ip($remote_ip,$cfg) {
		// no ip present
		if (!$remote_ip) {
			// Instantiate the error file and error mail objects;
			$new_error = new error;
			// set the error message
			$error_text = "No remote ip address present for API request.";
			$new_error->log("Security","critical",$error_text,$cfg);
			// error response
			$this->error[] = "26";
			// response
			return FALSE;
		} else {
			// set the allowable ip array size
			if(in_array($remote_ip,$cfg['security']['ip'])) {
				return TRUE;
			} else {
				require($cfg['file']."modules/session/language/".$cfg['language']."/session_error.php");
	       		// instantiate the error class and log
				$new_error = new error;
				$error_text = $lang['unauthorisedapi']." ".$remote_ip;
				// set the error message
				$new_error->log("Security","critical",$error_text,$cfg);
				// error response
				$this->error[] = "41";
				// response
				return FALSE;
			}
		}
	}
	
	function sanitise_array($array) {
		foreach($array as $key => $value) {
			if(is_array($value)) {
				$params[$key] = $this->sanitise_array($value);
			} else {
				$params[$key] = $this->sanitise($value);
			}
		}
		return $params;
	}
	
	function sanitise_post($post) {
		if($post['crc32'] != crc32($post['all'])) {
			// data corrupted
			return FALSE;	
		}
		$tmp = unserialize(base64_decode($post['all']));
		$params =  $this->sanitise($tmp);
		return $params;
	}
	
	function sanitise($str) {
		// unacceptable strings
		// Notice: \ removed from magic quote insert
		$this->unacceptable_array = array('<','>','\'\\','"',"\'");
		$this->replace_array = array('&lt;','&gt;','&apos;',' inch','&apos;');
		// determine if it is an array
		if (is_array($str)) {
			// convert via the process_array function
			$response = $this->process_array($str);
		} else {
			// urldecode string
			$str = urldecode($str);
			// remove strings that are dangerous
			$response = trim(str_replace($this->unacceptable_array,$this->replace_array,$str));
		}
		return $response;
	}
	
	function process_array($str) {
		// loop through every paramater and return a string containing the array
		foreach ($str as $key => $value) {
			// determine if the value is an array
			if (is_array($value)) {
				$response[$key] = $this->process_array($str[$key]);
			} else {
				$response[$key] = trim(str_replace($this->unacceptable_array,$this->replace_array,$value));
			}
		}
		// return the string
		return $response;
	}
	
	function permission_authentication($required,$user,$cfg) {
		// determine if type present
		if (isset($required[0]) ) {
			foreach ($required as $level) {
				$authorised_type = FALSE;
				if ($level['classification'] == "all" || $level['classification'] == $user['classification'] || (is_array($level['classification']) && in_array($user['classification'],$level['classification']))) {
					// set that it is an authorised type
					$authorised_type = TRUE;
				}
				$authorised_permission = FALSE;
				if ($level['permission']  == "all" || $level['permission'] == $user['permission'] || ( is_array($level['permission']) && in_array($user['permission'],$level['permission']))) {
					// set that it is an authorised type
					$authorised_permission = TRUE;
				}
				if($authorised_type && $authorised_permission) {
					// passed
					return TRUE;
				}
			}
		} else {
			$authorised_type = FALSE;
			if ($required['classification'] == "all" || $required['classification'] == $user['classification'] || (is_array($required['classification']) && in_array($user['classification'],$required['classification']))) {
				// set that it is an authorised type
				$authorised_type = TRUE;
			}
			$authorised_permission = FALSE;
			if ($required['permission']  == "all" || $required['permission'] == $user['permission'] || (is_array($required['permission']) && in_array($user['permission'],$required['permission']))) {
				// set that it is an authorised type
				$authorised_permission = TRUE;
			}
			if($authorised_type && $authorised_permission) {
				return TRUE;
			}
		}
		// unauthorised to perform the request
		$this->error[] = "52";
		// instantiate error object
		$new_error = new error;
		// set the error message
		$error_text = "Unauthorised API type request for type from id:".$user['id']." name:".$user['name']." ".$user['surname'];
		if ($user['session']) {
			$error_text.= " [session]";
		}
		$new_error->log("Security","critical",$error_text,$cfg);
		// response 
		return FALSE;	
	}
}
?>