<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Time class
* @package TenderSystem
* @subpackage generic
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

Class time {
	var $day;
	var $month;
	var $holiday;
	
	/*
	 * Function to determine holiday
	 * @input day = integer
	 * @input month = integer
	 * @output = Binary
	 */
	function check_holiday($day, $month, $cfg) {
		// set paramaters
		$this->day = ltrim($day, "0");
		$this->month = ltrim($month, "0");
		$this->holiday = FALSE;
		for($i = 0; $i < 40; $i++) {
			if (!empty($cfg['holiday'][$i]['date'])) {
				$holiday_date = $cfg['holiday'][$i]['date'];
				$holiday_day = substr($holiday_date, 3, 2);
				$holiday_month = substr($holiday_date, 0, 2);
				// trim white spaces
				$holiday_day = ltrim($holiday_day, "0");
				$holiday_month = ltrim($holiday_month, "0");
				if (($this->day == $holiday_day) && ($this->month == $holiday_month)) {
					$this->holiday = TRUE;
					continue;
				}
			} else {
				// this will break holidays if they are not sequentially indexed
				continue;
			}
    	}
		return $this->holiday;
	}
} 
?>