<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* XML class
* @package TenderSystem
* @subpackage generic
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

Class xml {
	// set paramaters
	var $xml;
	
	// generate xml
	function xml_generator($module,$function,$error,$paramaters,$user,&$cfg) {
		// add a couple more paramters
		$paramaters['localdisplay'] = $cfg['local']['display'];
		$paramaters['localprecurrency'] = $cfg['local']['precurrency'];
		$paramaters['localpostcurrency'] = $cfg['local']['postcurrency'];
		$href="modules/".$module."/templates/".$function;
		// create the default xml file
		$xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n";
		$xml.= "<?xml-stylesheet type=\"text/xsl\" href=\"./".$href.".xsl\" ?>\r\n\r\n";
		$xml.= "<response>\r\n";
		$xml.= " <user>\r\n";
		// id
		if ($user['id']) {
			$xml.= "  <usersid>".$user['id']."</usersid>\r\n";
		}
		// organisationid
		if ($user['organisation']) {
			$xml.= "  <organisationid>".$user['organisation']."</organisationid>\r\n";
		}
		// id
		if ($user['branch']) {
			$xml.= "  <branchid>".$user['id']."</branchid>\r\n";
		}
		// name
		if ($user['name']) {
			$xml.= "  <name>".$user['name']."</name>\r\n";
		}
		// surname
		if ($user['surname']) {
			$xml.= "  <surname>".$user['surname']."</surname>\r\n";
		}
		// theme
		if ($user['theme']) {
			$xml.= "  <theme>".$user['theme']."</theme>\r\n";
		} else {
			$xml.= "  <theme>".$cfg['theme']."</theme>\r\n";
		}
		// lang
		if ($user['language']) {
			$xml.= "  <language>".$user['language']."</language>\r\n";
		} else {
			$xml.= "  <language>".$cfg['language']."</language>\r\n";
		}
		// type
		if ($user['classification']) {
			$xml.= "  <classification>".$user['classification']."</classification>\r\n";
			if ($user['classification'] == "1") {
				$expire_time = $cfg['login']['agent'] + 5;
				$xml.= "  <expire>".$expire_time."</expire>\r\n";
			} elseif ($user['classification'] == "2") {
				$expire_time = $cfg['login']['subscriber'] + 5;
				$xml.= "  <expire>".$expire_time."</expire>\r\n";			
			} elseif ($user['classification'] == "3") {
				$expire_time = $cfg['login']['admin'] + 5;
				$xml.= "  <expire>".$expire_time."</expire>\r\n";
			}
		}
		// permission
		if ($user['permission']) {
			$xml.= "  <permission>".$user['permission']."</permission>\r\n";
		}
		if ($cfg['error']['codes']) {
			$xml.= "  <errorcodes/>\r\n";
		}
		$xml.= " </user>\r\n";
		// if username or password is not present
		if ($error) {
			if(!$user['language']) {
				$user['language'] = 'en';
			}
			require($cfg['file']."modules/generic/language/".$user['language']."/error.php");
			// filter out generic errors
			if (is_array($error)) {
				foreach($error as $value) {
					if(!$lang[$value]) {
						if($value) {
							$xml.= " <error>".$value."</error>\r\n";
						}
					} else {
						if($cfg['error']['codes']) {
							$xml.= " <error_text>".$value.":".$lang[$value]."</error_text>\r\n";
						} else {
							$xml.= " <error_text>".$lang[$value]."</error_text>\r\n";
						}
					}
				}
			} else {
				if(!$lang[$error]) {
					if($error) {
						$xml.= " <error>".$error."</error>\r\n";
					}
				} else {
					$xml.= " <error_text>".$error.": ".$lang[$error]."</error_text>\r\n";
				}
			}
		}
		// session expire
		if (isset($cfg['error']['session'])) {
			// set paramaters
			$xml.= "<sessionexpire>true</sessionexpire>";
		}
		// determine if debug active
		if ($cfg['debug']) {
			// set paramaters
			$paramaters['debug'] = $cfg['debug'];
		}
		// insert array
		if (is_array($paramaters)) {
			// set the xml
			$xml.= $this->xml_loop($paramaters);
		}
		// display
		return $xml;
	}
	
	function xml_loop($param) {
		// set the array keys
		$array_keys = array_keys($param);
		// set the response variable
		$response = "";
		// loop through every paramater
		foreach ($array_keys as $key) {
			// determine if it is an array
			if (is_array($param[$key])) {
				// determine the loop increment
				$size = sizeof($param[$key]);
				// loop through every response
				foreach($param[$key] as $value) {
	 				// open the xml tag
	 				$response.= "<".$key.">";
	 				if (is_array($value)) {
	 					// set a spacer
	 					$response.= "\r\n";
	  					// re loop through function
	  					$response.= $this->xml_loop($value);
	 				} else {
	 					// populate
	 					$response.= $value;
	 				}
	 				// close the xml tag
	 				$response.= "</".$key.">\r\n";
				}
			} else {
				// open the xml tag
				$response.= "<".$key.">";
				// replace & with &amp; done seperate because &lt; and &gt; contains &
				$param[$key] = str_replace("&","&amp;",$param[$key]);
				// replace < with &lt; and > with &gt;
				$set_value = str_replace(array("<",">","&apos;"),array("&lt;","&gt;","'"),$param[$key]);
				// populate
				$response.= $set_value;
				// close the xml tag
				$response.= "</".$key.">\r\n";
			}
		}
		// response
		return $response;
	}
}
?>
