<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Generic
* @package TenderSystem
* @subpackage generic
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

if(!function_exists("ts_time")) {
	// get the time with the local duration already added
	function ts_time($cfg) {
		return time() + $cfg['local']['duration'];
	}
}

// execute a function file
function execute_function($params,$module,$function,$user,$cfg,$conn) {
	// empty error array (removing this might break php5.0)
	// instantiate object
	$new_security = new security;
	$errors = array();
	$xml = "";
	if (file_exists($cfg['file']."modules/".$module."/api_".$function.".php")) {
		// if module has settings check
		if(file_exists($cfg['file']."modules/".$module."/config.inc.php")) {
			include($cfg['file']."modules/".$module."/config.inc.php");
		}
		// include execution file
		require($cfg['file']."modules/".$module."/api_".$function.".php");
	} else {
		// instantiate the error class and log
		$new_error = new error;
		// instantiate language
		include($cfg['file']."modules/generic/language/".$cfg['language']."/error_text.php");
		if (!is_dir($cfg['file']."modules/".$module)) {
			// set the error text
			$error_text = $lang['unknownmodule']. " : ".$module;
			// log the error
			$new_error->log("API","serious",$error_text,$cfg);
			// 1059 - Unknown API Module requested
			$error[] = "1059";
			// proses the reponse error and display
			$xml = $new_error->response_xml($error,$user,$cfg);
		
		} else {
			// set the error text
			$error_text = $lang['unknownfunction']." : ".$function." (".$lang['module'].":".$module.")";
			// log the error
			$new_error->log("API","serious",$error_text,$cfg);
			// 1060 - Unknown API Function requested
			$error[] = "1060";
			// instantiate the error class
			$new_error = new error;
			// proses the reponse error and display
			$xml = $new_error->response_xml($error,$user,$cfg);
		}
	}
	return $xml;
}
// create a random seed
mt_srand();
// so that oracle will work
define('ADODB_ASSOC_CASE',0);
// set the variables
$module = $params['module'];
$function = $params['function'];
// create a connection to the database
if($cfg['multiple']['dsn']) {
	require_once($cfg['file'].'modules/generic/class/connwrapper.class.php');
	$conn = new connection($cfg);
} else {
	$conn = &ADONewConnection($cfg['dsn']['0']['conn']);
}
// error if connection not established
if (!$conn) {
	// instantiate the error class and log
	$new_error = new error;
	// include language
	include($cfg['file']."modules/generic/language/".$cfg['language']."/error_text.php");
	// set the error message
	$error_text = "Could not connect to database, Check database settings ";
	// log the error message as it occurred in ADODB
	$new_error->log("SQL","critical",$error_text,$cfg);
	// 1061 - Could not connect to database
	$error[] = "1061";
	// proses the reponse error and display
	$xml = $new_error->response_xml($error,"",$cfg);
} else {
	// return in association form.
	$conn->SetFetchMode(ADODB_FETCH_ASSOC);
	// transaction support enabled
	if($cfg['dsn']['0']['transaction']['enable'] && ($params['module'] != "generic")) {
		// start transaction
		$conn->StartTrans();
	}
	// set the session object
	$new_session = new session;
	// public modules
	$public_modules['public'] = TRUE;
	// public functions
	$public_functions['session']['login'] = TRUE;
	$public_functions['password']['reset'] = TRUE;
	$public_functions['password']['confirm'] = TRUE;
	$public_functions['procure']['purchase_order'] = TRUE;
	$public_functions['generic']['attachment'] = TRUE;
	$public_functions['generic']['test'] = TRUE;
	$public_functions['generic']['message_receipt'] = TRUE;
	$public_functions['session']['login'] = TRUE;
	if(!$params['session'] && $function != "settings" && ($public_modules[$module] || $public_functions[$module][$function])) {
		// execution public function
		$xml = execute_function($params,$module,$function,array(),$cfg,$conn);
	} else {
		// set the session object
		$new_session = new session;
		// validate user
		$session_params['session'] = $params['session'];
		$session_params['server_ip'] = $_SERVER['REMOTE_ADDR'];;
		$session_params['ip'] = $params['ip'];
		$user = $new_session->validate($session_params,$cfg,$conn);
		// error handling
		if (!$user) {
			// check if public function
			if($function != "settings" && ($public_modules[$module] || $public_functions[$module][$function])) {
				// execution public function
				$xml = execute_function($params,$module,$function,array(),$cfg,$conn);
			} else {
				// set that this is a session error
				$cfg['error']['session'] = TRUE;
				// instantiate the xml object
				$new_xml = new xml;
				// generate xml 
				$xml = $new_xml->xml_generator("session","error",$new_session->error,$xml_params,$user,$cfg);
			}
		} else {
			// execution function
			$xml = execute_function($params,$module,$function,$user,$cfg,$conn);
		}
	}
	if($cfg['dsn']['0']['transaction']['enable'] && ($params['module'] != "generic")) {
		// end transaction
		$conn->CompleteTrans();
	}
	// close the database connection
	$conn->Close();
}
?>