<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Create language
* @package TenderSystem
* @subpackage language
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required[0]['classification'] = "3";
$required[0]['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} elseif ($params['lang']) {
	$xml_params = $params;
	// include required file
	require($cfg['file'].'modules/generic/class/file.class.php');
	// instantiate objects
	$new_file = new file;
	// Already exists
	$language = $new_file->read_folder("modules/generic/language",$cfg);
	// create language folder in every module that has a language folder
	$file_path = $cfg['file']."modules";
	// open the directory
	$dir = opendir($file_path);
	// if folder accessible
	if ($dir) {
		// loop through all the folders (modules)
		while(($file=readdir($dir)) !== FALSE) {
			// determine if hidden file not included
			if($file{0} != "." && $file != "CVS" && is_dir($file_path."/".$file)) {
				$full_path = $file_path."/".$file;
				// open the module directory
				$module_dir = opendir($full_path);
				if ($module_dir) {
					// loop through all the folders in the module
					while(($module_file=readdir($module_dir)) !== FALSE) {
						if(is_dir($full_path."/".$module_file) && $module_file=="language") {
							// set files in an array
							if(!mkdir($full_path."/language/".$params['lang'], 0775)) {
								// failed to create folders
								$errors = "e2";
							} else {
								$xml_params['created']="1";
							}
							break;
						}
					}
					// close the module directory
					closedir($module_dir);
				}
			}
		}
		// close the directory
		closedir($dir);
	} else {
		$errors = "308";
	}
	$xml_params['reflang'] = $user['language'];
	$xml_params['lang'] = $params['lang'];
	// join errors
	if(!empty($new_file->error)) {
		$errors = array_merge($errors,$new_file->error);
	}
	$xml = $new_xml->xml_generator("languageeditor","create",$errors,$xml_params,$user,$cfg);
} else {
	$xml = $new_xml->xml_generator("languageeditor","create",$params['error'],$xml_params,$user,$cfg);
}
?>