<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Edit language
* @package TenderSystem
* @subpackage language
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required[0]['classification'] = "3";
$required[0]['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} else {
	$xml_params['guimodule'] = $params['guimodule'];
	$xml_params['inactiveguimodule'] = $params['inactiveguimodule'];
	$xml_params['nocalendar'] = $params['nocalendar'];
	$xml_params['nocountry'] = $params['nocountry'];
    $xml_params['nolanguage'] = $params['nolanguage'];
	$xml_params['lang'] = $params['lang'];
	$xml_params['reflang'] = $params['reflang'];
	$xml_params['updated'] = $params['updated'];
	$errors = $params['error'];
	$file_path = $cfg['file']."modules/";
	// open the directory
	$dir = opendir($file_path);
	// if folder accessible
	if ($dir) {
		// loop through all the files (modules)
		while(($file=readdir($dir)) !== FALSE) {
			// determine if hidden file not included
			if($file{0} != "." && $file != "CVS" && is_dir($file_path."/".$file)) {
				$full_path = $file_path.$file;
				if(is_dir($full_path."/language")) {
					$xml_params['appmodule'][] = $file;
					if(file_exists($full_path."/language/".$params['lang']) && $lang_dir = opendir($full_path."/language/".$params['lang'])) {
						$active = FALSE;
						while(($lang_file=readdir($lang_dir)) !== FALSE) {
							if(strpos($lang_file,"~") === FALSE && strpos($lang_file,"php") !== FALSE) {
								$active = TRUE;
							}
						}
						closedir($lang_dir);
						if(!$active) {
							$xml_params['inactiveappmodule'][] = $file;
						}
					} else {
						$xml_params['inactiveappmodule'][] = $file;
					}
				}
			}
		}
		// close the directory
		closedir($dir);
	}
	$xml = $new_xml->xml_generator("languageeditor","edit",$errors,$xml_params,$user,$cfg);
}
?>