<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Export data
* @package TenderSystem
* @subpackage loader
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required[0]['classification'] = "3";
$required[0]['permission'] = "2";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} elseif (is_array($params['tablename'])) {
	if(isset($cfg['dsn']['0']['prefix'])) {
		$prefix = $cfg['dsn']['0']['prefix'];
	} else {
		$prefix = $cfg['db']['prefix'];
	}
	foreach($params['tablename'] as $value) {
		$sqlstr = "SELECT * FROM ".$prefix.$value." ORDER BY id ASC "; 
		if($rs = $conn->Execute($sqlstr)) {
			if($rs->RecordCount() > 0) {
				$data[trim($value)] = rs2tab($rs);
			}	
		} else {
			// instantiate the error class and log
			$new_error = new error;
			// set the error message
			$error_text = "Could not export data. Error Message : ".$conn->ErrorMsg()." SQL :".$sqlstr;
			// log the error message as it occurred in ADODB
			$new_error->log("SQL","critical",$error_text,$cfg);
			$params['error'][] = "e7";
		}
	}
	$xml_params['coded_data'] = base64_encode(serialize($data));
	$xml = $new_xml->xml_generator("loader","remove",$params['error'],$xml_params,$user,$cfg);
} else {
	$xml = $new_xml->xml_generator("loader","error",$params['error'],$xml_params,$user,$cfg);
}

function rs2tab(&$rs)
{
	$result = "";
	$fields = array_keys($rs->fields);
	$last_field = end($fields);
	foreach($fields as $value) {
		if($value != $last_field) {
			$result .= strtolower($value)."\t";	
		} else {
			$result .= strtolower($value)."\n";	
		}
	}
	$rows = $rs->GetArray();
	foreach($rows as $value) {
		foreach($value as $key1 => $value1) {
			if($key1 != $last_field) {
				$result .= str_replace(array("\t","\n")," ",$value1)."\t";	
			} else {
				$result .= str_replace(array("\t","\n")," ",$value1)."\n";	
			}
		}
	}
	return $result;
}
?>