<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Delete message
* @package TenderSystem
* @subpackage log
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required[0]['classification'] = "3";
$required[0]['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} else {
	// include file 
	require_once($cfg['file'].'modules/generic/class/message.class.php');
	require_once($cfg['file'].'modules/user/class/user.class.php');
	require_once($cfg['file'].'modules/external/class/smtp/htmlMimeMail.php');
	$new_message = new message;
	// check permissions
	if ($user['classification'] == "3" ) {
		$new_message = new message;
		$xml_params['deleted'] = 0;
		foreach($params['check'] as $key => $selectedmessagevalue) {
			$params['id'] = $key;  
			if($new_message->delete_message($key,$user['id'],$cfg,$conn)) {
				$xml_params['deleted']++;								
			}
		}	
		if ($xml_params['deleted'] == 0) {			
			// get administrators
			$param['searchinfo']['classification'] = 3;
			$new_user = new user;
			$admin['users'] = $new_user->search($param, $cfg, $conn);
			// check if at least one administrator
			if ($admin['users']) {
				foreach ($admin['users'] as $admin_user) {
            		// get administrators info
                	$admin = $new_user->get_info($admin_user['usersid'], $cfg, $conn);
					// check if administrators profile == email or email / sms
					if (($admin['preference'] == 'm') || ($admin['preference'] == 'n')) {
						// open and set language file
						require($cfg['file'].'modules/log/language/'.$admin['language'].'/language.php');
	        			// include email body template
			        	require($cfg['file'].'modules/log/templates/admin_message.php');
						// set message paramaters
						$message['classification'] = "email_delete_message";
						$message['subject'] = $subject;
						$message['body'] = $html;
						$message['name'] = $message['reference'] = $admin['name']." ".$admin['surname'];
						$message['email'] = $admin['email'];
						//instantiate object
						$new_message = new message;
						// send email to administrator
						$new_message->send_email($message,$cfg,$conn);
						// send sms notification
						if ($admin['preference'] == 'n') {
							$message['classification'] = "email_delete_message_notification";
							$message['body'] = "list of deleted emails has been sent to your email address";
							$message['name'] = $message['reference'] = $admin['name']." ".$admin['surname'];
							$message['email'] = $admin['email'];
							$message['phone_mobile'] = $admin['phone_mobile'];
							$new_message->send_sms($message,$cfg,$conn);
						}						
					}
				}
			}
		}
		$xml = $new_xml->xml_generator("log","delete_messages",$new_message->error,$xml_params,$user,$cfg);
	} else {
		// Insufficient authority 
		$error[] = "1067";
		$xml = $new_xml->xml_generator("log","delete_messages",$error,"",$user,$cfg);
	}	
}
?>