<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Messenger class
* @package TenderSystem
* @subpackage messenger
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

Class messenger {
	var $error;
	var $usersid;
	var $messenger;
	var $body;
	var $subject;
	var $email_body;
	var $email_subject;
	var $sms_message;
	var $response;
	var $counter;
	
	function messenger() {
		// allow php5 to work
		$this->error = array();	
	}

	/**
	 * Send messages to multiple users
	 * 
	 * @param array message_info Contains all message info from users to the actually message
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 * 
	 * @return array A list of all the users and wether or not the message was successfull 
	 */
	function send_messages($message_info,$usersid,$cfg,$conn) {
		// set counter
		$this->counter = 0;
		$this->usersid = $usersid;
		$this->body = $message_info['body'];
		$this->subject = $message_info['subject'];
		if($message_info['classification'] == "sms") {
			$this->prepare_sms();
			$this->send_sms($message_info['users'],$cfg,$conn);
		} elseif($message_info['classification'] == "email") {
			$this->prepare_email();
			$this->send_email($message_info['users'],$cfg,$conn);
		} elseif($message_info['classification'] == "prefer") {
			$this->prepare_sms();
			$this->prepare_email();
			$this->send_prefer($message_info['users'],$cfg,$conn);
		} else {
			$this->error = "e4";
		}
		// return the response
		return $this->response;
	}

	/**
	 *  Prepares the message to be sent as a email 
	 */
	function prepare_email() {
		$this->email_body = str_replace("\n","<br/>",$this->body);
		$this->email_subject = str_replace("\n"," ",$this->subject);
		// strip tags
		$find = array("[b]","[/b]","[br/]","[/i]","[i]","[u]","[/u]","[a","|]","[/a]","href=|");
		$replace = array("<b>","</b>","<br/>","</i>","<i>","<u>","</u>","<a","\">","</a>","href=\"");
		$this->email_body = str_replace($find,$replace,$this->email_body);
	}

	/**
	 *  Prepares the message to be sent as a sms 
	 */
	function prepare_sms() {
		// strip tags
		$find = array("[b]","[/b]","[/i]","[i]","[u]","[/u]","[a","|]","[/a]","href=|");
		$this->sms_message = str_replace($find,"",$this->body);
	}

	/**
	 * Send email messages to multiple users
	 * 
	 * @param array user_list List of users to send message to
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 * 
	 */
	function send_sms($user_list,$cfg,$conn) {
		$new_users = new user;
		$new_message = new message;
		foreach($user_list as $value) {
			if($users = $new_users->get_profile($value,$cfg,$conn)) {
				$body= $this->replace_user_tags($users,$this->sms_message);
				$message['classification'] = "messenger_sms";
				$message['subject'] = $this->sms_message;
				$message['body'] = $body;
				$message['name'] = $message['reference'] = $users['name']." ".$users['surname'];
				$message['phone_mobile'] = $users['phone_mobile'];
				$message['phone_prefix'] = $users['phone_prefix'];
				$message_id = $new_message->send_sms_message($message,$users['id'],$this->usersid,$cfg,$conn);
				// set response
				$this->response['sent'][$this->counter]['name'] = $users['name']." ".$users['surname'];
				$this->response['sent'][$this->counter]['method'] = "sms";
				$this->response['sent'][$this->counter]['address'] = $users['phone_mobile'];
				if (!$message_id) {
					// Message errors
					if(!empty($new_message->error)) { 
						$this->error = array_merge($this->error,$new_message->error);
					}
					$this->response['sent'][$this->counter]['status'] = "0";
					// increment counter
					$this->counter++;
				} else {
					// set that message sent successfully
					$this->response['sent'][$this->counter]['status'] = $new_message->response['status'];
					// increment counter
					$this->counter++;
				}
			} elseif(!empty($new_users->error)) {
				$this->error = array_merge($this->error,$new_users->error);
			}
		}
	}

	/**
	 * Send sms messages to multiple users
	 * 
	 * @param array user_list List of users to send message to
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 * 
	 */
	function send_email($user_list,$cfg,$conn) {
		$new_users = new user;
		$new_message = new message;
		foreach($user_list as $value) {
			if($users = $new_users->get_profile($value,$cfg,$conn)) {
				$subject = $this->replace_user_tags($users,$this->email_subject);
				$body = $this->replace_user_tags($users,$this->email_body);
				$message['classification'] = "messenger_sms";
				$message['subject'] = $subject;
				$message['body'] = $body;
				$message['name'] = $message['reference'] = $users['name']." ".$users['surname'];
				$message['email'] = $users['email'];
				$message_id = $new_message->send_email_message($message,$users['id'],$this->usersid,$cfg,$conn);
				$this->response['sent'][$this->counter]['name'] = $users['name']." ".$users['surname'];
				$this->response['sent'][$this->counter]['method'] = "email";
				$this->response['sent'][$this->counter]['address'] = $users['email'];
				if (!$message_id) {
					// Message errors 
					if(!empty($new_message->error)) {
						$this->error = array_merge($this->error,$new_message->error);
					}
					$this->response['sent'][$this->counter]['status'] = "0";
					// increment counter
					$this->counter++;
				} else {
					// set that message sent successfully
					$this->response['sent'][$this->counter]['status'] = $new_message->response['status'];
					// increment counter
					$this->counter++;
				}
			} elseif(!empty($new_users->error)) {
				$this->error = array_merge($this->error,$new_users->error);
			}
		}
	}
	
	/**
	 * Replaces special tags with user information
	 * 
	 * @param array users the user information
	 * @param array msg the message
	 * 
	 */
	function replace_user_tags($users,$msg) {
		$find = array("[name/]","[surname/]","[company/]","[branch/]","[phonework/]","[phonemobile/]","[email/]","[phonefax/]");
		$replace = array($users['name'],$users['surname'],$users['organisationname'],$users['branchname'],$users['phone_work'],$users['phone_mobile'],$users['email'],$users['phone_fax']);
		return str_replace($find,$replace,$msg);
	}

	/**
	 * Send messages to multiple users
	 * 
	 * @param array user_list List of users to send message to
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 * 
	 */
	function send_prefer($user_list,$cfg,$conn) {
		$new_users = new user;
		$new_message = new message;
		foreach($user_list as $value) {
			if($users = $new_users->get_profile($value,$cfg,$conn)) {
				// send email
				if($users['preference'] == "m" || $users['preference'] == "n") {
					$subject = $this->replace_user_tags($users,$this->email_subject);
					$body = $this->replace_user_tags($users,$this->email_body);
					$message['classification'] = "messenger_email";
					$message['subject'] = $subject;
					$message['body'] = $body;
					$message['name'] = $message['reference'] = $users['name']." ".$users['surname'];
					$message['email'] = $users['email'];
					$message_id = $new_message->send_email_message($message,$users['id'],$this->usersid,$cfg,$conn);
					$this->response['sent'][$this->counter]['name'] = $users['name']." ".$users['surname'];
					$this->response['sent'][$this->counter]['method'] = "email";
					$this->response['sent'][$this->counter]['address'] = $users['email'];
					if (!$message_id) {
						// Message errors 
						if(!empty($new_message->error)) {
							$this->error = array_merge($this->error,$new_message->error);
						}
						$this->response['sent'][$this->counter]['status'] = "0";
						// increment counter
						$this->counter++;
					} else {
						// set that message sent successfully
						$this->response['sent'][$this->counter]['status'] = $new_message->response['status'];
						// increment counter
						$this->counter++;
					}
				} 
				// send sms
				if($users['preference'] == "n") {
					$body= $this->replace_user_tags($users,$this->sms_message);
					$message['classification'] = "messenger_sms";
					$message['subject'] = $this->sms_message;
					$message['body'] = $body;
					$message['name'] = $message['reference'] = $users['name']." ".$users['surname'];
					$message['phone_mobile'] = $users['phone_mobile'];
					$message['phone_prefix'] = $users['phone_prefix'];
					$message_id = $new_message->send_sms_message($message,$users['id'],$this->usersid,$cfg,$conn);
					// set response
					$this->response['sent'][$this->counter]['name'] = $users['name']." ".$users['surname'];
					$this->response['sent'][$this->counter]['method'] = "sms";
					$this->response['sent'][$this->counter]['address'] = $users['phone_mobile'];
					if (!$message_id) {
						// Message errors 
						if(!empty($new_message->error)) {
							$this->error = array_merge($this->error,$new_message->error);
						}
						$this->response['sent'][$this->counter]['status'] = "0";
						// increment counter
						$this->counter++;
					} else {
						// set that message sent successfully
						$this->response['sent'][$this->counter]['status'] = $new_message->response['status'];
						// increment counter
						$this->counter++;
					}
				}
			} elseif(!empty($new_users->error)) {
				$this->error = array_merge($this->error,$new_users->error);
			}
		}
	}

	/**
	 * Returns the organisations and branches
	 * 
	 * @param array params search info
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 * 
	 * @return array List of organisation and branches
	 */
	function get_receiver_info($params,$cfg,$conn) {
		$new_organisation = new organisation;
		// search
		$xml_params['organisation'] = $new_organisation->search($params,$cfg,$conn);
		$new_branch = new branch;
		// search
		$xml_params['branch'] = $new_branch->search($params,$cfg,$conn);
		if(!empty($new_organisation->error)) {
			$this->error = array_merge($this->error,$new_organisation->error);	
		}
		if(!empty($new_branch->error)) {
			$this->error = array_merge($this->error,$new_branch->error);	
		}
		if(!empty($params['error'])) {
			$this->error = array_merge($this->error,$params['error']);	
		}
		return $xml_params;
	}
}
?>