<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Company link
* @package TenderSystem
* @subpackage organisation
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required[0]['classification'] = "3";
$required[0]['permission'] = "all";
// or
$required[1]['classification'] = "1";
$required[1]['permission'] = "4";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} else {
	// include files
	require($cfg['file'].'modules/generic/class/file.class.php');
	require($cfg['file'].'modules/area/class/area.class.php');
	require($cfg['file'].'modules/organisation/class/supplier.class.php');
	$new_area = new area;
	$new_organisation = new supplier;
	$new_file = new file;
	// get organisations
	$info['searchinfo']['classification'] = "2";
	$xml_params['organisation'] =$new_organisation->search($info,$cfg,$conn);
	// get selected organisations
	$xml_params['selectedorganisation'] =$new_organisation->search_panel($params['organisationid'],$cfg,$conn);
	if(empty($new_organisation->error) && $params['update']) {
		if(is_array($params['check'])) {
			$check = $params['check'];
		} else {
			$check = array();	
		}
		$old_check = array();
		// get old check
		if (is_array($xml_params['selectedorganisation'])) {
			foreach($xml_params['selectedorganisation'] as $value) {
				$old_check[$value['organisationid']] =  $value['id'];
			}
		}
		// check for new suppliers on panel
		foreach($check as $key => $value) {
			if(!$old_check[$key]) {
				$insert['supplier'] = $params['organisationid'];
				$insert['organisation'] = $key;
				$insert['status'] = "1";
				$insert['created_by'] = $user['id'];
				$new_organisation->create_organisation_supplier($insert,$cfg,$conn);
				$xml_params['updated'] = "1";
			}
		}
		// check for remove of suppliers from panel
		foreach($old_check as $key => $value) {
			if(!$check[$key]) {
				$new_organisation->delete_organisation_supplier($value,$user['id'],$cfg,$conn);
				$xml_params['updated'] = "1";
			}
		}
	}
	// get selected supplier again
	if($xml_params['updated']) {
		$xml_params['selectedorganisation'] =$new_organisation->search_panel($params['organisationid'],$cfg,$conn);
	}
	if($params['update']) {
		// check needs
		$info['searchinfo']['organisationid'] = $params['organisationid'];
		if(!$new_area->search($info,$cfg,$conn)) {
			$xml_params['needarea'] = "1";
		}
		// look for organisation setup links
		$xml_params['organisationinfo'][0]['classification'] = "1";
		$xml_params['organisationinfo'][0]['organisationid'] = $params['organisationid'];
		$new_file->link_api_find("organisation","setup",$xml_params,$user,$cfg,$conn);
	}
	$xml_params['organisationid'] = $params['organisationid'];
	// generate xml
	$xml = $new_xml->xml_generator("organisation","company_link",$new_organisation->error,$xml_params,$user,$cfg);
}

?>