<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Company link
* @package TenderSystem
* @subpackage organisation
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required[0]['classification'] = "3";
$required[0]['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} elseif ($params['currentinfo']) {
	require($cfg['file'].'modules/user/class/subscriber.class.php');
	require($cfg['file'].'modules/user/class/admin.class.php');
	require($cfg['file'].'modules/user/class/agent.class.php');
	require($cfg['file'].'modules/password/class/password.class.php');
	require($cfg['file'].'modules/generic/class/message.class.php');
	require($cfg['file'].'modules/external/class/smtp/htmlMimeMail.php');
	$xml_params['classification'] = $params['classification'];
	$xml_params['branchid'] = $params['branchid'];
	$xml_params['organisationid'] = $params['organisationid'];
	// user info 
	$users['username'] = str_replace(" ","_", $params['currentinfo'][0]['repusername']);
	if(strlen($users['username']) < 5) {
		$errors[] = "262";
	}
	$users['name'] =  $params['currentinfo'][0]['repname'];
	$users['surname'] =  $params['currentinfo'][0]['repsurname'];
	$users['phone_prefix'] =  $params['currentinfo'][0]['repphone_prefix'];
	$users['phone_work'] =  $params['currentinfo'][0]['repphone_work'];
	$users['phone_fax'] =  $params['currentinfo'][0]['repphone_fax'];
	$users['phone_mobile'] =  $params['currentinfo'][0]['repphone_mobile'];
	$users['email'] =  $params['currentinfo'][0]['repemail'];
	$users['preference'] =  $params['currentinfo'][0]['reppreference'];
	$users['classification'] =  $params['currentinfo'][0]['classification'];
	$users['permission'] =  $params['currentinfo'][0]['reppermission'];
	$users['theme'] =  $params['currentinfo'][0]['reptheme'];
	$users['language'] =  $params['currentinfo'][0]['replang'];
	$users['date_of_birth'] =  $params['currentinfo'][0]['repdate_of_birth'];
	$users['skype'] =  $params['currentinfo'][0]['repskype'];
	$users['instant_messager'] =  $params['currentinfo'][0]['repinstant_messager'];
	$users['im_contact'] =  $params['currentinfo'][0]['repim_contact'];
	if($params['currentinfo'][0]['repmandate']) {
		$users['mandate'] =  $params['currentinfo'][0]['repmandate'];
	}
	$users['status'] = "2";
	// org info
	$org['name'] =  $params['currentinfo'][0]['organisationname'];
	$org['registered_name'] =  $params['currentinfo'][0]['registered_name'];
	$org['classification'] =  $params['currentinfo'][0]['classification'];
	$org['rep_position'] =  $params['currentinfo'][0]['repposition'];
	$org['transaction_fee'] =  $params['currentinfo'][0]['transaction_fee'];
	$org['transaction_min'] =  $params['currentinfo'][0]['transaction_min'];
	$org['registration_number'] =  $params['currentinfo'][0]['registration_number'];
	$org['vat_number'] =  $params['currentinfo'][0]['vat_number'];
	$org['user_fee'] =  $params['currentinfo'][0]['user_fee'];
	$org['sms_fee'] =  $params['currentinfo'][0]['sms_fee'];
	$org['rating'] =  $params['currentinfo'][0]['rating'];
	$org['status'] = "1";
	// branch info
	$branch['name'] =  $params['currentinfo'][0]['branchname'];
	$branch['phone_prefix'] =  $params['currentinfo'][0]['branchphone_prefix'];
	$branch['phone_work'] =  $params['currentinfo'][0]['branchphone_work'];
	$branch['phone_fax'] =  $params['currentinfo'][0]['branchphone_fax'];
	$branch['email'] =  $params['currentinfo'][0]['branchemail'];
	$branch['branch_comment'] =  $params['currentinfo'][0]['branchcomment'];
	$branch['primary_address_street'] =  $params['currentinfo'][0]['primary_address_street'];
	$branch['primary_address_city'] =  $params['currentinfo'][0]['primary_address_city'];
	$branch['primary_address_state'] =  $params['currentinfo'][0]['primary_address_state'];
	$branch['primary_address_postalcode'] =  $params['currentinfo'][0]['primary_address_postalcode'];
	$branch['primary_address_country'] =  $params['currentinfo'][0]['address_country'];
	$branch['alt_address_street'] =  $params['currentinfo'][0]['alt_address_street'];
	$branch['alt_address_city'] =  $params['currentinfo'][0]['alt_address_city'];
	$branch['alt_address_state'] =  $params['currentinfo'][0]['alt_address_state'];
	$branch['alt_address_postalcode'] =  $params['currentinfo'][0]['alt_address_postalcode'];
	$branch['alt_address_country'] =  $params['currentinfo'][0]['address_country'];
	$branch['status'] = "1";
	$doinserts = TRUE;
	// check if organisation already exists
	$new_org = new organisation;
	$info['searchinfo']['organisationname'] =  $org['name'];
	if($new_org->search($info,$cfg,$conn)) {
		// Already exists
		$errors[] = "263";
		if(!empty($new_org->error)) {
			$errors = array_merge($errors,$new_org->error);
		}
	}
	$new_branch =  new branch;
	if($users['classification'] == "3") {
		$new_users = new admin;
	} elseif($users['classification'] == "2") {
		$new_users = new subscriber;
	} elseif($users['classification'] == "1") {
		$new_users = new agent;
	} else {
		$new_users = new user;
	}
	if($new_users->get_id_by_username($users['username'],$cfg,$conn,TRUE)) {
		// Already exists
		$errors[] = "267";
		if(!empty($new_user->error)) {
			$errors = array_merge($errors,$new_user->error);
		}
	}
	if($errors) {
		// resend old infomation
		$xml_params['currentinfo'] = $params['currentinfo'];
		$xml_params['language'] = $params['language'];
		$xml_params['theme'] = $params['theme'];
		// generate xml 
		$xml = $new_xml->xml_generator("organisation","create",$errors,$xml_params,$user,$cfg);
	} else {
		$new_database = new database;
		// organisation id 
		$org['id'] = $new_database->get_next_id("~organisation",$cfg,$conn);
		$users['organisation'] =  $org['id'];
		$branch['organisation'] =  $org['id'];
		// user id
		$users['id'] = $new_database->get_next_id("~users",$cfg,$conn);
		 $org['rep_user_id'] = $users['id'];
		// branch id
		$branch['id'] = $new_database->get_next_id("~organisation_branch",$cfg,$conn);
		$users['branch'] = $branch['id'];
		// created by
		$branch['created_by'] = $users['created_by'] =  $org['created_by'] = $user['id'];
		// administrator
		$users['administrator'] = $user['id'];
		// insert organisation into database
		if($profile['id'] = $new_org->create_organisation( $org,$cfg,$conn)) {
			// insert branch into database
			 if($new_branch->create_branch($branch,$cfg,$conn)) {
				// insert user into database
				if($users['id'] = $new_users->create_user($users,$cfg,$conn)){
					$xml_params['created'] = "1";
					$new_password = new password;
					$new_password->send_password($users,$user['id'],$cfg,$conn);
					// join errors
					if($new_password->error) {
						$errors = $errors + $new_password->error;
					}
				}
				// join errors
				if(!empty($new_user->error)) {
					$errors = $errors + $new_user->error;
				}
			}
			// join errors
			if(!empty($new_branch->error)) {
				$errors = $errors + $new_branch->error;
			}
		}
		// join errors
		if($new_org->error) {
			$errors = $errors + $new_org->error;
		}
		if($errors) {
			// resend old infomation
			$xml_params['language'] = $params['language'];
			$xml_params['theme'] = $params['theme'];
			$xml_params['currentinfo'] = $params['currentinfo'];
			// generate xml 
			$xml = $new_xml->xml_generator("organisation","create",$errors,$xml_params,$user,$cfg);
		} else {
			$xml_params['editable'] = "0";
			// get organisation profile
			$xml_params['organisationinfo'][0] = $new_org->get_profile($profile,$cfg,$conn);
			if($xml_params['organisationinfo'][0]['classification'] == "1") {
				$xml_params['needarea'] = "1";
				$xml_params['needcategory'] = "1";
				$xml_params['needcompany'] = "1";
			}
			$xml = $new_xml->xml_generator("organisation","profile",$new_org->error,$xml_params,$user,$cfg);
		}
	}
} else {
	// generate xml 
	$xml = $new_xml->xml_generator("organisation","create","",$xml_params,$user,$cfg);
}
?>